# バッチ設計書 10-dual-boot.sh

## 概要

本ドキュメントは、Redoxをストレージデバイスの空き領域にインストールし、ブートエントリを追加するscripts/dual-boot.shスクリプトの設計仕様を定義するものです。このスクリプトは、systemd-boot対応のデュアルブート構成を作成します。

### 本バッチの処理概要

dual-boot.shは、既存のLinuxシステム上にRedox OSをデュアルブート構成でインストールするためのスクリプトです。Redoxのファイルシステムイメージをビルドし、popsicleツールを使用して指定されたパーティションに書き込み、systemd-bootにブートエントリを追加します。

**業務上の目的・背景**：Redox OSを実機で評価・テストするためには、仮想マシンではなく物理ハードウェアで実行する必要がある場合があります。このスクリプトを使用することで、既存のLinux環境を維持しながら、Redox OSを別パーティションにインストールし、ブートメニューから選択して起動できるようになります。これにより、開発者は実機でのRedox OSのパフォーマンスや動作を検証できます。

**バッチの実行タイミング**：手動実行。Redox OSをデュアルブート構成でインストールしたいときに使用します。

**主要な処理内容**：
1. 対象ディスクパーティションの指定（デフォルト: REDOX_INSTALLラベル）
2. filesystem.imgのビルド（make実行）
3. popsicleツールでパーティションへのイメージ書き込み
4. EFIシステムパーティション（ESP）へのブートローダーコピー
5. systemd-bootエントリファイルの作成

**前後の処理との関連**：事前にパーティションを作成し、REDOX_INSTALLというラベルを付けておく必要があります。インストール後は、システム再起動時にsystemd-bootメニューからRedox OSを選択できます。

**影響範囲**：指定されたパーティションの内容が完全に上書きされます。ESPにブートローダーとエントリファイルが追加されます。

## バッチ種別

インストール処理 / ブート設定

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| sudo権限 | パーティション書き込みとESP操作にroot権限が必要 |
| popsicle | popsicleツールがインストール済みであること |
| systemd-boot | ホストシステムがsystemd-bootを使用していること |
| パーティション | インストール先パーティションが作成済みであること |
| ビルド環境 | Redoxビルドシステムがセットアップ済みであること |

### 実行可否判定

- 指定されたデバイスがブロックデバイスとして存在すること
- EFIシステムパーティション（ESP）が存在すること
- ブートローダーがビルド済みであること

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| device | 文字列 | No | /dev/disk/by-partlabel/REDOX_INSTALL | インストール先パーティション |
| ARCH | 環境変数 | No | uname -m | アーキテクチャ |
| CONFIG_NAME | 環境変数 | No | desktop | 設定名 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| build/ARCH/CONFIG_NAME/filesystem.img | バイナリ | Redoxファイルシステムイメージ |
| recipes/core/bootloader/target/.../bootloader.efi | バイナリ | EFIブートローダー |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| パーティション | RedoxFS | Redoxファイルシステム |
| ESP/EFI/redox.efi | バイナリ | Redoxブートローダー |
| ESP/loader/entries/redox.conf | テキスト | systemd-bootエントリ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | redox.conf |
| 出力先 | ESP/loader/entries/ |
| 文字コード | UTF-8 |
| 内容 | title, efiパス |

## 処理フロー

### 処理シーケンス

```
1. デバイス指定確認
   └─ 引数またはデフォルトパーティションを使用

2. デバイス存在確認
   └─ ブロックデバイスとして存在するか確認

3. 環境変数設定
   ├─ ARCH: 未設定なら uname -m
   └─ CONFIG_NAME: 未設定なら desktop

4. イメージビルド
   └─ rm -f IMAGE && make IMAGE

5. パーティション書き込み
   └─ sudo popsicle IMAGE DISK

6. ESPパス取得
   └─ bootctl --print-esp-pathでESPを特定

7. ブートローダーコピー
   └─ sudo cp bootloader.efi ESP/EFI/redox.efi

8. ブートエントリ作成
   └─ sudo tee ESP/loader/entries/redox.conf

9. 同期
   └─ sync

10. 完了メッセージ
    └─ マウント手順の案内
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{デバイス指定?}
    B -->|Yes| C[指定デバイス使用]
    B -->|No| D[REDOX_INSTALLパーティション使用]
    C --> E{ブロックデバイス?}
    D --> E
    E -->|No| F[エラー終了]
    E -->|Yes| G[ARCH/CONFIG_NAME設定]
    G --> H[filesystem.imgビルド]
    H --> I[popsicleでイメージ書き込み]
    I --> J[ESP取得]
    J --> K{ESP存在?}
    K -->|No| L[エラー終了]
    K -->|Yes| M[EFI/ディレクトリ作成]
    M --> N[bootloader.efiコピー]
    N --> O[redox.conf作成]
    O --> P[sync実行]
    P --> Q[完了メッセージ]
    Q --> R[バッチ終了]
```

## データベース操作仕様

このバッチはデータベース操作を行いません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | デバイスなし | 指定デバイスがブロックデバイスでない | 正しいパーティションを指定 |
| 1 | ESPなし | EFIシステムパーティションが見つからない | systemd-boot環境か確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

- デバイスが存在しない場合：パーティションを作成してラベルを設定
- ESPがない場合：systemd-boot環境であることを確認
- ビルドエラー時：ビルドシステムのセットアップを確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし（sync前に中断した場合、部分的な書き込み状態になる可能性あり） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回のインストール |
| 目標処理時間 | ビルド時間 + 書き込み時間（数分〜数十分） |
| メモリ使用量上限 | ビルドシステムに依存 |

## 排他制御

同一パーティションへの同時書き込みは不可能です（popsicleによる排他制御）。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | なし（set -xによるトレース） | - |
| 進捗ログ | 各コマンド実行時 | set -xによるコマンドエコー |
| 終了ログ | 完了時 | "Finished installing Redox OS dual boot" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 特になし | 標準出力 |

## 備考

- デフォルトパーティションラベルはREDOX_INSTALLです
- systemd-bootのブートエントリとしてredox.confが作成されます
- ブートローダーはrecipes/core/bootloader/からコピーされます
- set -xによりコマンドがエコーされ、実行内容を確認できます
- インストール後、scripts/mount-redoxfs.shでパーティションをマウントできます
- UEFIブート環境でのみ動作します（従来のBIOSブートには非対応）
- popsicleはSystem76が開発したディスクイメージ書き込みツールです
- syncコマンドで書き込みを確実にフラッシュしてからメッセージを表示します
