# バッチ設計書 11-category.sh

## 概要

本ドキュメントは、Redoxオペレーティングシステムのビルドシステムにおけるcategory.shバッチの設計仕様を定義するものである。

### 本バッチの処理概要

このバッチは、Cookbookレシピのカテゴリに対して一括でビルドコマンドやクリーンコマンドを実行するためのユーティリティスクリプトである。

**業務上の目的・背景**：Redoxのビルドシステムでは、レシピ（パッケージ）が「core」「wip」「wip/dev」などのカテゴリに分類されている。開発者が特定カテゴリ内の全レシピに対して一括操作を行いたい場合、個別に指定するのは非効率である。本バッチは、カテゴリ単位での一括ビルド・クリーン操作を可能にし、開発効率を向上させる。

**バッチの実行タイミング**：手動実行。開発者が特定カテゴリのレシピを一括でビルドまたはクリーンしたいときに随時実行される。

**主要な処理内容**：
1. コマンドライン引数から「アクション」と「カテゴリ」を取得
2. 引数のバリデーション（両方必須）
3. makeコマンドに適切な形式でアクションとカテゴリを渡して実行

**前後の処理との関連**：本バッチは独立して実行可能であり、特定の前提バッチはない。ビルド後は各レシピのstageディレクトリにビルド成果物が生成される。

**影響範囲**：指定されたカテゴリ内の全レシピに対してmakeコマンドが実行されるため、該当カテゴリのビルドディレクトリ全体に影響する。

## バッチ種別

ユーティリティ（ビルド操作支援）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| redoxディレクトリでの実行 | プロジェクトルートディレクトリで実行する必要がある |
| Makefileの存在 | プロジェクトのMakefileが存在すること |
| レシピカテゴリの存在 | 指定するカテゴリがrecipes配下に存在すること |

### 実行可否判定

引数が2つ（アクションとカテゴリ）指定されているかを確認し、不足している場合はUsageを表示して終了（exit 1）する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| action | string | Yes | N/A | 実行するアクション（f, r, c, u, p またはmakeが理解する組み合わせ） |
| recipe-category | string | Yes | N/A | 対象カテゴリのパス（例: core, wip, wip/dev） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| コマンドライン引数 | string | ユーザー指定のアクションとカテゴリ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | makeコマンドの実行結果 |
| 標準エラー | テキスト | エラーメッセージまたはUsage情報 |

### 出力ファイル仕様

直接のファイル出力はないが、makeコマンドの実行によりビルド成果物が各レシピディレクトリに生成される。

| 項目 | 内容 |
|-----|------|
| ファイル名 | makeの実行結果による |
| 出力先 | recipes/カテゴリ/レシピ名/target/ |
| 文字コード | N/A |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. 引数チェック
   └─ $1（アクション）と$2（カテゴリ）の両方が指定されているか確認
2. 引数不足時の処理
   └─ Usage情報を標準エラーに出力し、exit 1で終了
3. makeコマンド実行
   └─ make "${1#-}"."--category-$2" の形式でmakeを呼び出す
      └─ ${1#-}：アクションから先頭のハイフンを除去
      └─ --category-$2：カテゴリ指定のmakeターゲット形式
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{引数チェック<br/>$1と$2が存在?}
    B -->|No| C[Usage表示]
    C --> D[exit 1]
    B -->|Yes| E[makeコマンド実行<br/>make action.--category-category]
    E --> F[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

N/A

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 引数エラー | アクションまたはカテゴリが未指定 | 正しい引数を指定して再実行 |
| make依存 | ビルドエラー | makeの実行に失敗 | makeのエラーメッセージを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 自動リトライなし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

手動で問題を修正し、再度スクリプトを実行する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（シェルスクリプト） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | カテゴリ内のレシピ数に依存 |
| 目標処理時間 | レシピ数・ビルド内容に依存 |
| メモリ使用量上限 | makeプロセスに依存 |

## 排他制御

本バッチは複数同時実行を想定していない。同一カテゴリに対する同時実行は避けること。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| Usage情報 | 引数エラー時 | 使用方法とパラメータの説明 |
| ビルドログ | make実行中 | makeの標準出力 |
| エラーログ | エラー発生時 | makeのエラー出力 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| N/A | N/A | 手動実行のため監視対象外 |

## 備考

- アクションパラメータは先頭にハイフンがあっても除去される（${1#-}の処理）
- makeターゲットは「アクション.--category-カテゴリ」の形式で指定される
- 対応アクション例：
  - f: fetch（ソース取得）
  - r: rebuild（再ビルド）
  - c: clean（クリーン）
  - u: update（更新）
  - p: package（パッケージ作成）
