# バッチ設計書 12-check-ci-config.sh

## 概要

本ドキュメントは、Redoxオペレーティングシステムのビルドシステムにおけるcheck-ci-config.shバッチの設計仕様を定義するものである。

### 本バッチの処理概要

このバッチは、CI（継続的インテグレーション）構成ファイル内に登録されていないパッケージ（レシピ）を検出するためのユーティリティスクリプトである。

**業務上の目的・背景**：RedoxのCIシステムでは、ci.toml構成ファイルでビルド対象パッケージを管理している。新しいレシピが追加された場合や、既存のレシピがCI構成に未登録の場合、CIビルドから漏れてしまう可能性がある。本バッチは、レシピディレクトリに存在するがCI構成ファイルに未登録のパッケージを自動検出し、CIの網羅性を確保する。

**バッチの実行タイミング**：手動実行。CI構成の整合性確認時や、新規レシピ追加後の確認作業時に随時実行される。

**主要な処理内容**：
1. fstoolsをビルドして必要なツールを準備
2. list_recipesでwip以外の全レシピを取得し、連想配列に格納
3. redox_installerでCI構成ファイルからパッケージリストを取得
4. 両者を比較し、CI構成に未登録のレシピを検出・表示

**前後の処理との関連**：本バッチ実行前にfstoolsのビルドが必要。検出結果に基づいてCI構成ファイル（ci.toml）を手動で更新する。

**影響範囲**：読み取り専用の検査スクリプトであり、システムの状態を変更しない。出力は標準出力に表示されるのみ。

## バッチ種別

ユーティリティ（CI構成検査）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| redoxディレクトリでの実行 | プロジェクトルートディレクトリで実行する必要がある |
| Makefileの存在 | make build/fstoolsが実行可能であること |
| CI構成ファイルの存在 | config/{ARCH}/ci.tomlが存在すること |

### 実行可否判定

特に事前判定なし。fstoolsのビルドに失敗した場合はset -eにより即座に終了する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| ARCH | string | No | x86_64 | 対象アーキテクチャ |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| recipes/ | ディレクトリ | レシピディレクトリ群 |
| config/{ARCH}/ci.toml | TOML | CI構成ファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 未登録パッケージとレシピパスの一覧 |

### 出力ファイル仕様

ファイル出力なし（標準出力のみ）。

| 項目 | 内容 |
|-----|------|
| ファイル名 | N/A |
| 出力先 | 標準出力 |
| 文字コード | UTF-8 |
| 区切り文字 | スペース（32文字幅フォーマット） |

## 処理フロー

### 処理シーケンス

```
1. アーキテクチャ設定
   └─ 引数があればそれを使用、なければx86_64をデフォルトとする
2. fstoolsビルド
   └─ make build/fstoolsを実行
3. レシピリスト取得
   └─ build/fstools/bin/list_recipesで全レシピを取得
   └─ wip/ディレクトリを除外（grep -v '^recipes/wip/'）
   └─ 連想配列packagesにレシピ名とパスを格納
4. CI構成パッケージ取得
   └─ redox_installer --list-packagesでCI登録パッケージを取得
   └─ 連想配列の該当エントリを空にマーク
5. 結果出力
   └─ 連想配列を走査し、値が空でないエントリ（未登録）を表示
   └─ 32文字幅でパッケージ名とレシピパスをフォーマット出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[アーキテクチャ設定]
    B --> C[make build/fstools]
    C --> D[list_recipesで<br/>レシピ一覧取得]
    D --> E[wip/を除外]
    E --> F[連想配列に格納]
    F --> G[redox_installerで<br/>CI登録パッケージ取得]
    G --> H[登録済みパッケージを<br/>連想配列から除外]
    H --> I[未登録パッケージを<br/>フォーマット出力]
    I --> J[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

N/A

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 非0 | ビルドエラー | make build/fstoolsが失敗 | ビルド環境を確認 |
| 非0 | ツール不存在 | list_recipesまたはredox_installerがない | fstoolsを再ビルド |
| 非0 | 構成ファイル不存在 | ci.tomlが存在しない | 対象ARCHの構成ファイルを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 自動リトライなし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

set -eにより、エラー発生時は即座に処理を中断する。手動で問題を修正後、再実行する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（シェルスクリプト） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数百レシピ |
| 目標処理時間 | fstoolsビルド時間に依存（初回数分） |
| メモリ使用量上限 | 連想配列サイズに依存 |

## 排他制御

読み取り専用のため、排他制御は不要。複数同時実行可能。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| ヘッダ出力 | 処理開始時 | "Checking for missing packages in {config}" |
| カラムヘッダ | 結果出力前 | "PACKAGE" "RECIPE" |
| 結果出力 | 処理完了時 | 未登録パッケージとレシピパス |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| N/A | N/A | 手動実行のため監視対象外 |

## 備考

- wip（Work In Progress）ディレクトリのレシピはチェック対象外
- 出力はソート済み
- 連想配列（declare -A）を使用するため、bash 4.0以上が必要
- list_recipesとredox_installerはfstoolsに含まれるRust製ツール
