# バッチ設計書 13-commit-hash.sh

## 概要

本ドキュメントは、Redoxオペレーティングシステムのビルドシステムにおけるcommit-hash.shバッチの設計仕様を定義するものである。

### 本バッチの処理概要

このバッチは、指定されたレシピのソースコードに対して、現在のGitブランチとコミットハッシュを表示するためのユーティリティスクリプトである。

**業務上の目的・背景**：Redoxの各レシピはGitリポジトリからソースコードを取得してビルドする。開発者やメンテナーがレシピのバージョンを追跡・確認する際、どのブランチのどのコミットでビルドされているかを知る必要がある。本バッチは、この情報を簡単に取得できるようにし、バージョン管理とデバッグを支援する。

**バッチの実行タイミング**：手動実行。レシピのバージョン確認時、バグ報告時、またはアップデート作業前の状態確認時に随時実行される。

**主要な処理内容**：
1. コマンドライン引数からレシピ名を取得
2. find_recipeツールでレシピのパスを解決
3. レシピのsourceディレクトリに移動
4. git branch -vでブランチ情報とコミットハッシュを表示

**前後の処理との関連**：本バッチ実行前にfstoolsがビルドされている必要がある（target/release/find_recipeが存在すること）。また、レシピのソースコードがすでに取得（fetch）されている必要がある。

**影響範囲**：読み取り専用の情報表示スクリプトであり、システムの状態を変更しない。

## バッチ種別

ユーティリティ（バージョン情報表示）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| redoxディレクトリでの実行 | プロジェクトルートディレクトリで実行する必要がある |
| find_recipeの存在 | target/release/find_recipeが存在すること |
| レシピソースの存在 | レシピのsourceディレクトリが存在し、Gitリポジトリであること |

### 実行可否判定

引数が1つ（レシピ名）指定されているかを確認し、不足している場合はUsageを表示して終了（exit 1）する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| recipe_name | string | Yes | N/A | 対象レシピの名前 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| コマンドライン引数 | string | レシピ名 |
| レシピsourceディレクトリ | Gitリポジトリ | ソースコードのGitリポジトリ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | git branch -vの出力（ブランチ名、コミットハッシュ、コミットメッセージ） |

### 出力ファイル仕様

ファイル出力なし（標準出力のみ）。

| 項目 | 内容 |
|-----|------|
| ファイル名 | N/A |
| 出力先 | 標準出力 |
| 文字コード | UTF-8 |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. 引数チェック
   └─ 引数が1つでない場合、Usageを表示してexit 1
2. レシピパス取得
   └─ target/release/find_recipeを使用してレシピディレクトリを解決
3. ディレクトリ移動
   └─ レシピのsourceサブディレクトリに移動
4. Git情報表示
   └─ git branch -vを実行してブランチとコミット情報を出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{引数チェック<br/>$# = 1?}
    B -->|No| C[Usage表示]
    C --> D[exit 1]
    B -->|Yes| E[find_recipeで<br/>レシピパス取得]
    E --> F[sourceディレクトリに移動]
    F --> G[git branch -v実行]
    G --> H[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

N/A

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 引数エラー | レシピ名が未指定 | 正しい引数を指定して再実行 |
| 非0 | パス解決エラー | find_recipeでレシピが見つからない | レシピ名を確認 |
| 非0 | ディレクトリエラー | sourceディレクトリが存在しない | make f.レシピ名でソースを取得 |
| 非0 | Gitエラー | sourceがGitリポジトリでない | ソースの状態を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 自動リトライなし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

エラー発生時は手動で問題を修正後、再実行する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（シェルスクリプト） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1レシピ |
| 目標処理時間 | 1秒以内 |
| メモリ使用量上限 | 最小限 |

## 排他制御

読み取り専用のため、排他制御は不要。複数同時実行可能。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| Usage情報 | 引数エラー時 | 使用方法の説明 |
| Git情報 | 正常終了時 | ブランチ名、コミットハッシュ、コミットメッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| N/A | N/A | 手動実行のため監視対象外 |

## 備考

- find_recipeはfstoolsに含まれるRust製ツール（target/release/find_recipe）
- git branch -vは現在のブランチに*マークを付けて表示し、短縮コミットハッシュとコミットメッセージも含む
- レシピのソースがまだ取得されていない場合は、先に`make f.レシピ名`を実行する必要がある
