# バッチ設計書 14-find-recipe.sh

## 概要

本ドキュメントは、Redoxオペレーティングシステムのビルドシステムにおけるfind-recipe.shバッチの設計仕様を定義するものである。

### 本バッチの処理概要

このバッチは、レシピ名からレシピディレクトリを検索するためのユーティリティスクリプトである。ただし、ソースコードの内容を確認すると、実際にはイメージ内のファイルがどのパッケージに含まれているかを調査する機能を持っている。

**業務上の目的・背景**：Redoxのビルドシステムでは、多数のレシピがディレクトリ階層に分散して配置されている。開発者がビルドイメージ内のファイルがどのパッケージ（レシピ）から提供されているかを特定したい場合、手動での調査は困難である。本バッチは、イメージをマウントしてファイル一覧を取得し、各ファイルの提供元パッケージを特定する機能を提供する。

**バッチの実行タイミング**：手動実行。ファイルの出所調査、パッケージ構成の確認、競合調査時に随時実行される。

**主要な処理内容**：
1. 環境変数（ARCH、CONFIG_NAME）を設定
2. イメージをアンマウント（既存マウントのクリア）
3. イメージをマウント
4. ビルドディレクトリ内の全ファイルを列挙
5. 各ファイルに対応するレシピのstageディレクトリを検索
6. ファイルとパッケージの対応を出力
7. イメージをアンマウント

**前後の処理との関連**：ビルドが完了している必要がある。また、RedoxFSがマウント可能な状態であること。

**影響範囲**：イメージのマウント/アンマウントを行うため、他のマウント操作と競合する可能性がある。

## バッチ種別

ユーティリティ（ファイル・パッケージ対応調査）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| redoxディレクトリでの実行 | プロジェクトルートディレクトリで実行する必要がある |
| ビルド完了 | 対象アーキテクチャ・構成でのビルドが完了していること |
| RedoxFS利用可能 | make mount/unmountが実行可能であること |

### 実行可否判定

特に事前判定なし。ビルドディレクトリが存在しない場合はfindがエラーとなる。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| 引数なし | - | - | - | コマンドライン引数は受け取らない |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| build/{ARCH}/{CONFIG_NAME}/ | ディレクトリ | ビルドイメージ（マウント後） |
| recipes/*/target/{ARCH}-unknown-redox/stage/ | ディレクトリ | レシピのビルド成果物 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | ファイルパス: パッケージ名（複数の場合はスペース区切り） |

### 出力ファイル仕様

ファイル出力なし（標準出力のみ）。

| 項目 | 内容 |
|-----|------|
| ファイル名 | N/A |
| 出力先 | 標準出力 |
| 文字コード | UTF-8 |
| 区切り文字 | コロンとスペース |

## 処理フロー

### 処理シーケンス

```
1. 環境変数設定
   └─ ARCH=$(uname -m)、CONFIG_NAME=desktop
2. イメージアンマウント（クリア）
   └─ make unmount（エラー無視）
3. イメージマウント
   └─ make mount
4. ファイル列挙
   └─ build/{ARCH}/{CONFIG_NAME}/内の全ファイルをfindで取得
   └─ パスの先頭5階層を除去してソート・重複除去
5. パッケージ検索ループ
   └─ 各ファイルに対してrecipes配下のstageディレクトリを検索
   └─ 見つかればパッケージ名を、見つからなければ設定ファイルを参照するよう案内
6. イメージアンマウント
   └─ make unmount（エラー無視）
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[環境変数設定<br/>ARCH, CONFIG_NAME]
    B --> C[make unmount<br/>エラー無視]
    C --> D[make mount]
    D --> E[findでファイル列挙]
    E --> F[パス整形・ソート]
    F --> G{ファイルあり?}
    G -->|Yes| H[stageディレクトリ検索]
    H --> I{パッケージ発見?}
    I -->|Yes| J[パッケージ名出力]
    I -->|No| K[設定ファイル参照案内]
    J --> L{次のファイル?}
    K --> L
    L -->|Yes| G
    L -->|No| M[make unmount]
    G -->|No| M
    M --> N[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

N/A

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 非0 | マウントエラー | イメージが存在しないまたはマウント失敗 | ビルドを実行後に再実行 |
| 非0 | ディレクトリエラー | ビルドディレクトリが存在しない | 対象構成でビルドを実行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 自動リトライなし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

マウント/アンマウントのエラーは || true で無視される。致命的エラーの場合は手動でアンマウントし再実行。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（シェルスクリプト） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | イメージ内のファイル数（数千〜数万） |
| 目標処理時間 | ファイル数に依存（数分〜数十分） |
| メモリ使用量上限 | findとシェルパイプラインに依存 |

## 排他制御

make mount/unmountを使用するため、他のマウント操作との同時実行は避けること。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 結果出力 | ファイルごと | ファイルパス: パッケージ名またはno packages案内 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| N/A | N/A | 手動実行のため監視対象外 |

## 備考

- デフォルトのARCHはuname -mで取得（実行環境のアーキテクチャ）
- デフォルトのCONFIG_NAMEはdesktop
- パッケージが見つからないファイルは「no packages, see config/{ARCH}/{CONFIG_NAME}.toml」と表示
- 処理時間はイメージサイズとファイル数に大きく依存する
- バッチ一覧のfind-recipe.shとソースコード内容が異なる（バッチ一覧は「レシピ名からレシピディレクトリを検索」だが、実際は「イメージ内ファイルのパッケージ特定」）
