# バッチ設計書 15-include-recipes.sh

## 概要

本ドキュメントは、Redoxオペレーティングシステムのビルドシステムにおけるinclude-recipes.shバッチの設計仕様を定義するものである。

### 本バッチの処理概要

このバッチは、指定したパターンにマッチするレシピを検索し、ファイルシステム構成ファイルに追加可能な形式で出力するユーティリティスクリプトである。

**業務上の目的・背景**：Redoxのファイルシステム構成（tomlファイル）では、各レシピを「レシピ名 = {}」の形式で記述する。開発中（WIP）のレシピや特定の条件を持つレシピをテスト目的で一時的に構成に追加したい場合、手動で記述するのは手間がかかる。本バッチは、recipe.tomlファイル内のパターンマッチによりレシピを検索し、コピー＆ペースト可能な形式で出力することで、迅速なテスト構成の作成を支援する。

**バッチの実行タイミング**：手動実行。WIPレシピのテスト時、特定機能を持つレシピの一括追加時に随時実行される。

**主要な処理内容**：
1. コマンドライン引数からパターンを取得
2. recipes配下のrecipe.tomlファイルを対象にgrep -rlで検索
3. マッチしたレシピごとにディレクトリ名（レシピ名）を抽出
4. ファイルシステム構成形式（レシピ名 = {} # マッチ行）で出力

**前後の処理との関連**：本バッチの出力は、ファイルシステム構成ファイル（例：config/x86_64/desktop.toml）に追加して使用する。

**影響範囲**：読み取り専用の検索スクリプトであり、システムの状態を変更しない。出力は標準出力に表示されるのみ。

## バッチ種別

ユーティリティ（レシピ検索・構成生成）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| redoxディレクトリでの実行 | プロジェクトルートディレクトリで実行する必要がある |
| recipesディレクトリの存在 | レシピディレクトリが存在すること |

### 実行可否判定

引数（パターン）が指定されているかを確認し、不足している場合はUsageを表示して終了（exit 1）する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| pattern | string | Yes | N/A | 検索パターン（正規表現対応） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| recipes/**/recipe.toml | TOML | レシピ構成ファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | レシピ名 = {}    # マッチ行 の形式 |

### 出力ファイル仕様

ファイル出力なし（標準出力のみ）。

| 項目 | 内容 |
|-----|------|
| ファイル名 | N/A |
| 出力先 | 標準出力 |
| 文字コード | UTF-8 |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. 引数チェック
   └─ 引数が空の場合、Usageを表示してexit 1
2. パターン検索
   └─ grep -rl "$*" "$cookbook_recipes" --include recipe.toml
   └─ recipes配下のrecipe.tomlファイルを対象に検索
3. 結果処理ループ
   └─ 各マッチファイルに対して：
      └─ dirnameでディレクトリパスを取得
      └─ basenameでレシピ名を抽出
      └─ マッチ行を再度grepで取得
      └─ 「レシピ名 = {}    # マッチ行」の形式で出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{引数あり?}
    B -->|No| C[Usage表示]
    C --> D[exit 1]
    B -->|Yes| E[grep -rlで<br/>recipe.tomlを検索]
    E --> F{マッチあり?}
    F -->|Yes| G[dirname/basenameで<br/>レシピ名抽出]
    G --> H[マッチ行を取得]
    H --> I[構成形式で出力]
    I --> J{次のファイル?}
    J -->|Yes| G
    J -->|No| K[バッチ終了]
    F -->|No| K
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

N/A

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 引数エラー | パターンが未指定 | 正しい引数を指定して再実行 |
| 非0 | 検索エラー | grepでエラー発生 | パターンの正規表現構文を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 自動リトライなし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

エラー発生時は手動で問題を修正後、再実行する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（シェルスクリプト） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | レシピ数（数百） |
| 目標処理時間 | 数秒以内 |
| メモリ使用量上限 | 最小限 |

## 排他制御

読み取り専用のため、排他制御は不要。複数同時実行可能。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| Usage情報 | 引数エラー時 | 使用方法とパターン例 |
| 結果出力 | 正常終了時 | ファイルシステム構成形式のレシピリスト |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| N/A | N/A | 手動実行のため監視対象外 |

## 備考

- 検索対象はrecipe.tomlファイルのみ（recipe.shは対象外）
- 出力形式はTOMLのテーブルエントリ形式に準拠
- 出力末尾のコメントにはマッチ行が含まれるため、追加理由の追跡が可能
- 使用例：`./scripts/include-recipes.sh "TODO.*error"` - TODOとerrorを含むレシピを検索
- WIPレシピの迅速なテスト構成作成を主な用途として想定
