# バッチ設計書 16-pkg-size.sh

## 概要

本ドキュメントは、Redoxオペレーティングシステムのビルドシステムにおけるpkg-size.shバッチの設計仕様を定義するものである。

### 本バッチの処理概要

このバッチは、レシピのパッケージサイズ（stage.pkgarおよびstage.tar.gz）を表示するユーティリティスクリプトである。

**業務上の目的・背景**：Redoxのパッケージシステムでは、各レシピのビルド成果物がstage.pkgarとstage.tar.gzとしてパッケージ化される。パッケージメンテナーは、ライブラリリンクサイズポリシーを遵守するため、パッケージサイズを定期的に確認する必要がある。本バッチは、指定したレシピまたは全レシピのパッケージサイズを簡単に確認できる機能を提供し、サイズポリシーの適用と管理を支援する。

**バッチの実行タイミング**：手動実行。パッケージサイズの確認時、リリース前のサイズチェック時、サイズ最適化作業時に随時実行される。

**主要な処理内容**：
1. 引数の解析（ヘルプ表示、レシピ指定、または全レシピ）
2. 引数なしの場合：全recipesディレクトリからstage.pkgarとstage.tar.gzを検索
3. 引数ありの場合：指定されたレシピのパッケージファイルを検索
4. ls -hsでサイズを表示

**前後の処理との関連**：レシピがビルド済みである必要がある（stage.pkgarまたはstage.tar.gzが存在すること）。

**影響範囲**：読み取り専用の情報表示スクリプトであり、システムの状態を変更しない。

## バッチ種別

ユーティリティ（パッケージサイズ確認）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| redoxディレクトリでの実行 | プロジェクトルートディレクトリで実行する必要がある |
| recipesディレクトリの存在 | レシピディレクトリが存在すること |
| ビルド済みパッケージ | stage.pkgarまたはstage.tar.gzが存在すること |

### 実行可否判定

特に事前判定なし。パッケージファイルが存在しない場合は何も出力されない。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| recipe | string | No | N/A | 対象レシピ名（複数指定可能） |
| -h/--help | flag | No | N/A | ヘルプ表示 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| recipes/**/stage.pkgar | バイナリ | pkgar形式パッケージ |
| recipes/**/stage.tar.gz | バイナリ | tar.gz形式パッケージ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | サイズ（人間可読形式）とファイルパス |

### 出力ファイル仕様

ファイル出力なし（標準出力のみ）。

| 項目 | 内容 |
|-----|------|
| ファイル名 | N/A |
| 出力先 | 標準出力 |
| 文字コード | UTF-8 |
| 区切り文字 | タブ |

## 処理フロー

### 処理シーケンス

```
1. 引数解析
   └─ 引数なし：全レシピモード
   └─ -h/--help：ヘルプ表示モード
   └─ その他：指定レシピモード
2. 全レシピモード
   └─ find recipes \( -name stage.pkgar -o -name stage.tar.gz \)
   └─ ls -hsで各ファイルのサイズを表示
3. 指定レシピモード
   └─ 各レシピに対してループ
      └─ find recipes -name $recipeでレシピパスを検索
      └─ recipe.tomlまたはrecipe.shの存在を確認
      └─ find $recipe_path \( -name stage.pkgar -o -name stage.tar.gz \)
      └─ ls -hsでサイズを表示
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{引数あり?}
    B -->|No| C[全recipesを検索<br/>stage.pkgar/stage.tar.gz]
    C --> D[ls -hsで表示]
    D --> E[バッチ終了]
    B -->|Yes| F{-h/--help?}
    F -->|Yes| G[Usage表示]
    G --> H[exit 0]
    F -->|No| I[レシピループ開始]
    I --> J[find recipes -name $recipe]
    J --> K{recipe.toml/sh<br/>存在?}
    K -->|Yes| L[パッケージ検索]
    L --> M[ls -hsで表示]
    M --> N{次のレシピ?}
    K -->|No| N
    N -->|Yes| I
    N -->|No| E
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

N/A

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 0 | ヘルプ表示 | -h/--helpオプション指定 | 正常終了 |
| 0 | パッケージなし | 対象パッケージが存在しない | 先にビルドを実行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 自動リトライなし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

特になし。パッケージが存在しない場合は何も出力されないのみ。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（シェルスクリプト） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | レシピ数（数百）×パッケージファイル数 |
| 目標処理時間 | 数秒〜数十秒 |
| メモリ使用量上限 | 最小限 |

## 排他制御

読み取り専用のため、排他制御は不要。複数同時実行可能。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| Usage情報 | -h/--helpオプション時 | 使用方法の説明 |
| サイズ情報 | 正常終了時 | サイズ（KB/MB等）とファイルパス |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| N/A | N/A | 手動実行のため監視対象外 |

## 備考

- ls -hsオプションにより、サイズは人間可読形式（K, M, G等）で表示
- stage.pkgarはRedox独自のパッケージ形式
- stage.tar.gzは標準的なtar.gz圧縮形式
- パッケージメンテナーがライブラリリンクサイズポリシーを確認するために使用
- レシピ指定時はrecipe.tomlまたはrecipe.shの存在を確認してからパッケージを検索
- パッケージファイルが存在しないレシピは単にスキップされる（エラーにならない）
