# バッチ設計書 17-show-package.sh

## 概要

本ドキュメントは、Redoxオペレーティングシステムのビルドシステムにおけるshow-package.shバッチの設計仕様を定義するものである。

### 本バッチの処理概要

このバッチは、レシピのstageフォルダとsysrootフォルダの内容を一覧表示するユーティリティスクリプトである。

**業務上の目的・背景**：Redoxのビルドシステムでは、各レシピのビルド成果物がstageディレクトリに、ビルドに必要な依存ファイルがsysrootディレクトリに格納される。開発者がビルド結果を確認したり、パッケージ内容を検査したりする際に、これらのディレクトリ内容を把握することが重要である。本バッチは、指定されたレシピのstageとsysrootの内容を簡単に確認できる機能を提供する。

**バッチの実行タイミング**：手動実行。ビルド成果物の確認時、パッケージ内容の検査時、デバッグ時に随時実行される。

**主要な処理内容**：
1. コマンドライン引数からレシピ名を取得
2. find_recipeツールでレシピのパスを解決
3. レシピのtargetディレクトリ内のstageとsysrootを検索
4. ls -1で各ディレクトリの内容を表示

**前後の処理との関連**：本バッチ実行前にfstoolsがビルドされている必要がある。また、レシピがビルド済みである必要がある。

**影響範囲**：読み取り専用の情報表示スクリプトであり、システムの状態を変更しない。

## バッチ種別

ユーティリティ（ビルド成果物表示）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| redoxディレクトリでの実行 | プロジェクトルートディレクトリで実行する必要がある |
| find_recipeの存在 | target/release/find_recipeが存在すること |
| レシピのビルド完了 | stageまたはsysrootディレクトリが存在すること |

### 実行可否判定

- 引数（レシピ名）が指定されているかを確認し、不足している場合はUsageを表示して終了（exit 1）
- find_recipeが存在しない場合はエラーメッセージを表示して終了（exit 1）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| recipe | string | Yes | N/A | 対象レシピ名（複数指定可能） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| recipes/*/target/*/stage/ | ディレクトリ | ビルド成果物（パッケージ内容） |
| recipes/*/target/*/sysroot/ | ディレクトリ | ビルド時の依存ファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | stageとsysrootディレクトリの内容一覧 |

### 出力ファイル仕様

ファイル出力なし（標準出力のみ）。

| 項目 | 内容 |
|-----|------|
| ファイル名 | N/A |
| 出力先 | 標準出力 |
| 文字コード | UTF-8 |
| 区切り文字 | N/A（1行1ファイル） |

## 処理フロー

### 処理シーケンス

```
1. 引数チェック
   └─ 引数が空の場合、Usageを表示してexit 1
2. find_recipe存在チェック
   └─ target/release/find_recipeが実行可能でない場合
      └─ エラーメッセージ表示してexit 1
3. レシピループ
   └─ 各レシピに対して：
      └─ find_recipeでレシピディレクトリを取得
      └─ ls -1 "$recipe_dir/target"/*/{stage,sysroot}で内容表示
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{引数あり?}
    B -->|No| C[Usage表示]
    C --> D[exit 1]
    B -->|Yes| E{find_recipe<br/>存在?}
    E -->|No| F[エラー表示<br/>make fstools案内]
    F --> G[exit 1]
    E -->|Yes| H[レシピループ開始]
    H --> I[find_recipeで<br/>パス取得]
    I --> J[ls -1でstage/sysroot<br/>内容表示]
    J --> K{次のレシピ?}
    K -->|Yes| H
    K -->|No| L[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

N/A

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 引数エラー | レシピ名が未指定 | 正しい引数を指定して再実行 |
| 1 | ツール不存在 | find_recipeがない | make fstoolsを実行 |
| 非0 | パス解決エラー | レシピが見つからない | レシピ名を確認 |
| 非0 | ディレクトリエラー | stage/sysrootが存在しない | レシピをビルド |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 自動リトライなし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

エラー発生時は手動で問題を修正後、再実行する。find_recipeがない場合はmake fstoolsを実行。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（シェルスクリプト） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 指定されたレシピ数 |
| 目標処理時間 | 1秒以内（レシピ単位） |
| メモリ使用量上限 | 最小限 |

## 排他制御

読み取り専用のため、排他制御は不要。複数同時実行可能。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| Usage情報 | 引数エラー時 | 使用方法とレシピ例 |
| エラー情報 | find_recipe不存在時 | ツール不存在メッセージとmake fstools案内 |
| 結果出力 | 正常終了時 | stage/sysrootディレクトリ内容 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| N/A | N/A | 手動実行のため監視対象外 |

## 備考

- find_recipeはtarget/release/find_recipeにあるRust製ツール
- stageディレクトリにはパッケージとしてインストールされるファイルが格納
- sysrootディレクトリにはビルド時に参照される依存ファイル（ヘッダ、ライブラリ等）が格納
- ls -1オプションにより、1行1ファイルで出力される
- ワイルドカード（`*`）を使用しているため、複数のターゲットアーキテクチャのディレクトリがある場合は全て表示される
- 使用例：`./scripts/show-package.sh kernel`
