# バッチ設計書 18-ventoy.sh

## 概要

本ドキュメントは、Redoxオペレーティングシステムのビルドシステムにおけるventoy.shバッチの設計仕様を定義するものである。

### 本バッチの処理概要

このバッチは、複数のアーキテクチャと構成のRedoxブータブルISOイメージを作成し、Ventoyフォーマットのデバイスにコピーするユーティリティスクリプトである。

**業務上の目的・背景**：Ventoyは、ISOイメージをUSBドライブに配置するだけでブート可能にするオープンソースツールである。Redoxの開発者やテスターは、複数のアーキテクチャ（i686、x86_64）と構成（demo、desktop）の組み合わせでテストを行う必要がある。本バッチは、これらの全組み合わせのISOイメージを自動的にビルドし、Ventoyデバイスにコピーすることで、マルチブートテスト環境の構築を自動化する。

**バッチの実行タイミング**：手動実行。リリーステスト時、マルチ環境テスト時、開発者向けイメージ配布時に随時実行される。

**主要な処理内容**：
1. Ventoyデバイスのマウント確認
2. 全アーキテクチャ（i686、x86_64）×全構成（demo、desktop）のループ
3. 各組み合わせでmakeを実行してISOイメージをビルド
4. ビルドしたISOをVentoyデバイスにコピー
5. syncで書き込みを同期

**前後の処理との関連**：本バッチ実行前にVentoyデバイスがマウントされている必要がある。各アーキテクチャ・構成のビルド環境が整っていること。

**影響範囲**：ビルドディレクトリにISOイメージを生成し、Ventoyデバイスにファイルを書き込む。

## バッチ種別

ユーティリティ（イメージ作成・配布）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| redoxディレクトリでの実行 | プロジェクトルートディレクトリで実行する必要がある |
| Ventoyデバイスのマウント | /media/${USER}/Ventoyにマウントされていること |
| ビルド環境 | 対象アーキテクチャのビルドに必要なツールチェーンが揃っていること |

### 実行可否判定

Ventoyマウントポイント（/media/${USER}/Ventoy）の存在を確認し、存在しない場合は「Ventoy not mounted」を表示してexit 1で終了する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | コマンドライン引数は受け取らない |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Redoxソースコード | 各種 | ビルド対象のソースコード |
| config/{ARCH}/{CONFIG}.toml | TOML | 各構成のビルド設定 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| build/{ARCH}/{CONFIG}/redox-live.iso | ISO | ビルドされたISOイメージ |
| /media/${USER}/Ventoy/redox-{CONFIG}-{ARCH}.iso | ISO | コピー先ISOイメージ |
| 標準出力 | テキスト | cpコマンドの出力と完了メッセージ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | redox-{CONFIG}-{ARCH}.iso |
| 出力先 | /media/${USER}/Ventoy/ |
| 文字コード | N/A（バイナリ） |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. 初期設定
   └─ ARCHS配列: (i686 x86_64)
   └─ CONFIGS配列: (demo desktop)
   └─ VENTOYパス: /media/${USER}/Ventoy
2. Ventoyマウント確認
   └─ ディレクトリが存在しない場合、エラー終了
3. ネストループ
   └─ 外側: ARCHSをイテレート
      └─ 内側: CONFIGSをイテレート
         └─ makeでISOイメージをビルド
         └─ cp -vでVentoyにコピー
4. 同期処理
   └─ syncコマンドで書き込みを確定
5. 完了メッセージ
   └─ 処理した構成とアーキテクチャを表示
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{Ventoy<br/>マウント済み?}
    B -->|No| C[エラー表示]
    C --> D[exit 1]
    B -->|Yes| E[ARCHループ開始<br/>i686, x86_64]
    E --> F[CONFIGループ開始<br/>demo, desktop]
    F --> G[make ARCH CONFIG<br/>redox-live.iso]
    G --> H[cp -v to Ventoy]
    H --> I{次のCONFIG?}
    I -->|Yes| F
    I -->|No| J{次のARCH?}
    J -->|Yes| E
    J -->|No| K[sync実行]
    K --> L[完了メッセージ表示]
    L --> M[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

N/A

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | マウントエラー | Ventoyがマウントされていない | Ventoyデバイスをマウント |
| 非0 | ビルドエラー | makeが失敗 | ビルドエラーを修正 |
| 非0 | コピーエラー | cpが失敗（容量不足等） | Ventoyデバイスの空き容量確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 自動リトライなし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

set -eにより、エラー発生時は即座に処理を中断する。手動で問題を修正後、再実行する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（シェルスクリプト） |
| コミットタイミング | syncコマンドで全書き込みを確定 |
| ロールバック条件 | N/A（手動でファイル削除） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 4イメージ（2アーキテクチャ×2構成） |
| 目標処理時間 | ビルド時間に依存（数十分〜数時間） |
| メモリ使用量上限 | ビルドプロセスに依存 |

## 排他制御

ビルドとファイルコピーを行うため、同時実行は避けること。Ventoyデバイスへの同時書き込みは避けること。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| エラーログ | Ventoy未マウント時 | "Ventoy not mounted" |
| コピーログ | 各イメージコピー時 | cp -vの出力 |
| 完了ログ | 処理完了時 | "Finished copying configs... for archs..." |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| N/A | N/A | 手動実行のため監視対象外 |

## 備考

- Ventoyは https://www.ventoy.net/ で提供されるマルチブートUSBツール
- 対応アーキテクチャ: i686（32ビット）、x86_64（64ビット）
- 対応構成: demo（最小構成）、desktop（デスクトップ環境）
- 出力ISOファイル名: redox-{CONFIG}-{ARCH}.iso（例: redox-desktop-x86_64.iso）
- 全4パターンのイメージが作成される:
  - redox-demo-i686.iso
  - redox-desktop-i686.iso
  - redox-demo-x86_64.iso
  - redox-desktop-x86_64.iso
- ビルド時間は環境とキャッシュ状態に大きく依存する
- Linuxシステムでの実行を想定（/media/${USER}/Ventoyパス）
