# バッチ設計書 19-recipe-match.sh

## 概要

本ドキュメントは、Redoxオペレーティングシステムのビルドシステムにおけるrecipe-match.shバッチの設計仕様を定義するものである。

### 本バッチの処理概要

このバッチは、指定したテキストを含むレシピ構成ファイルを検索し、構文ハイライト付きで表示するユーティリティスクリプトである。

**業務上の目的・背景**：Redoxのビルドシステムには多数のレシピが存在し、それぞれが構成ファイル（recipe.toml、recipe.sh等）を持つ。開発者が特定の設定やパターンを含むレシピを調査したい場合、手動での検索は非効率である。本バッチは、ripgrep（rg）による高速検索とbatによる構文ハイライト表示を組み合わせ、レシピ構成の調査を効率化する。

**バッチの実行タイミング**：手動実行。レシピ設定の調査時、特定機能を持つレシピの検索時、設定パターンの確認時に随時実行される。

**主要な処理内容**：
1. コマンドライン引数から検索パターンを取得
2. ripgrep（rg）でrecipes配下を大文字小文字無視で検索
3. マッチしたファイルをパスでソート
4. batで構文ハイライト付きで内容を表示

**前後の処理との関連**：本バッチは独立して実行可能。ripgrepとbatがインストールされている必要がある。

**影響範囲**：読み取り専用の検索・表示スクリプトであり、システムの状態を変更しない。

## バッチ種別

ユーティリティ（レシピ検索・表示）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| redoxディレクトリでの実行 | プロジェクトルートディレクトリで実行する必要がある |
| ripgrep（rg）のインストール | rgコマンドが利用可能であること |
| bat のインストール | batコマンドが利用可能であること |

### 実行可否判定

特に事前判定なし。検索パターンが空の場合は何も出力されない。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| pattern | string | Yes | N/A | 検索パターン（正規表現対応） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| recipes/** | 各種 | レシピ構成ファイル群 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 構文ハイライト付きファイル内容 |

### 出力ファイル仕様

ファイル出力なし（標準出力のみ）。

| 項目 | 内容 |
|-----|------|
| ファイル名 | N/A |
| 出力先 | 標準出力 |
| 文字コード | UTF-8 |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. 検索実行
   └─ rg "$1" -li --sort=path recipes
      └─ $1: 検索パターン
      └─ -l: ファイル名のみ出力
      └─ -i: 大文字小文字無視
      └─ --sort=path: パスでソート
      └─ recipes: 検索対象ディレクトリ
2. 結果表示
   └─ bat --decorations=always
      └─ 検索結果のファイル群を構文ハイライト付きで表示
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[rg実行<br/>パターン検索]
    B --> C{マッチあり?}
    C -->|Yes| D[bat実行<br/>構文ハイライト表示]
    D --> E[バッチ終了]
    C -->|No| E
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

N/A

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 非0 | ツール不存在 | rgまたはbatがインストールされていない | ツールをインストール |
| 非0 | パターンエラー | 無効な正規表現パターン | パターンを修正 |
| 0 | マッチなし | 検索結果が空 | パターンを変更して再検索 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 自動リトライなし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

エラー発生時は手動で問題を修正後、再実行する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（シェルスクリプト） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | レシピ数（数百） |
| 目標処理時間 | 数秒以内 |
| メモリ使用量上限 | 最小限 |

## 排他制御

読み取り専用のため、排他制御は不要。複数同時実行可能。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 結果出力 | 正常終了時 | 構文ハイライト付きファイル内容 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| N/A | N/A | 手動実行のため監視対象外 |

## 備考

- ripgrep（rg）は高速なgrep代替ツール（https://github.com/BurntSushi/ripgrep）
- bat は構文ハイライト付きcat代替ツール（https://github.com/sharkdp/bat）
- -iオプションにより大文字小文字を区別しない検索が行われる
- --sort=pathオプションによりファイルパスでソートされた結果が得られる
- --decorations=alwaysオプションにより常にファイル名などの装飾が表示される
- スクリプトは非常にシンプルで、1行のコマンドパイプラインで構成されている
- 引数チェックがないため、引数なしで実行するとエラーになる可能性がある
