# バッチ設計書 2-native_bootstrap.sh

## 概要

本ドキュメントは、ネイティブ環境でのRedoxビルドシステムをセットアップするnative_bootstrap.shスクリプトの設計仕様を定義するものです。このスクリプトは、Rustup、ビルド依存パッケージのインストール、およびリポジトリのクローンを行います。

### 本バッチの処理概要

native_bootstrap.shは、Redox OSの開発環境を一括セットアップするためのブートストラップスクリプトです。macOS、Linux各ディストリビューション（Arch Linux、Debian/Ubuntu、Fedora、SUSE、Gentoo、Solus）、およびFreeBSDに対応し、各プラットフォームのパッケージマネージャを自動検出して必要な依存パッケージをインストールします。

**業務上の目的・背景**：Redox OSの開発を始めるには、Rustツールチェーン、クロスコンパイル用のツール、各種ライブラリなど多数の依存関係を正しくセットアップする必要があります。このスクリプトは、異なるOS環境における依存関係の違いを抽象化し、開発者が単一のコマンドで開発環境を構築できるようにします。これにより、新規開発者のオンボーディング時間を大幅に短縮し、環境構築に関するトラブルを最小化します。

**バッチの実行タイミング**：初回セットアップ時に1回実行します。環境の再構築や依存パッケージの更新が必要な場合にも使用できます。

**主要な処理内容**：
1. 動作環境（OS）の検出とパッケージマネージャの特定
2. Rustup/Rustツールチェーンのインストールと設定
3. プラットフォーム固有の依存パッケージのインストール
4. エミュレータ（QEMU/VirtualBox）のインストール
5. Cargo経由でjust、cbindgenツールのインストール
6. Redoxリポジトリのクローンと初期設定ファイルの作成

**前後の処理との関連**：このバッチは環境構築の最初のステップであり、前提となる処理はありません。完了後は、build.shまたはmakeコマンドを使用してRedox OSのビルドを開始できます。

**影響範囲**：システム全体のパッケージ（sudo権限で実行）、ユーザーのホームディレクトリ（~/.cargo）、およびカレントディレクトリ（redoxリポジトリのクローン先）に影響します。

## バッチ種別

セットアップ処理 / 環境構築

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 初回のみ（随時） |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| インターネット接続 | パッケージダウンロードのため必須 |
| sudo権限 | パッケージインストールにroot権限が必要 |
| サポートOS | macOS、Linux（Arch/Debian/Ubuntu/Fedora/SUSE/Gentoo/Solus）、FreeBSD |
| パッケージマネージャ | brew/port（macOS）、apt-get/dnf/pacman/zypper/emerge/eopkg（Linux）、pkg（FreeBSD） |

### 実行可否判定

- サポートされるパッケージマネージャが存在すること
- インターネット接続が可能であること

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| -h, --help | フラグ | No | - | ヘルプ表示 |
| -u [branch] | 文字列 | No | master | gitリポジトリの更新とRustの更新 |
| -s | フラグ | No | - | 現在のTravisビルドステータスを確認 |
| -e [emulator] | 文字列 | No | qemu | インストールするエミュレータ（virtualbox/qemu） |
| -p [package manager] | 文字列 | No | apt-get | Ubuntu用パッケージマネージャ（apt-fast/aptitude） |
| -d | フラグ | No | - | 依存関係のみインストール（boot処理をスキップ） |
| -y | フラグ | No | - | 非対話モード（自動yes応答） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| https://sh.rustup.rs | シェルスクリプト | Rustupインストーラ |
| https://gitlab.redox-os.org/redox-os/redox.git | Git | Redoxリポジトリ |
| https://api.travis-ci.org/ | JSON API | ビルドステータス確認用 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| ~/.cargo | ディレクトリ | Rustツールチェーンとcargoバイナリ |
| ~/.rustup | ディレクトリ | Rustupツールチェーン管理 |
| redox/ | ディレクトリ | クローンされたRedoxリポジトリ |
| redox/.config | テキストファイル | ビルド設定（PODMAN_BUILD=0） |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | .config |
| 出力先 | redox/ |
| 文字コード | UTF-8 |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. オプション解析
   └─ -h/-u/-s/-e/-p/-d/-yオプションを解析

2. バナー表示
   └─ Redox bootstrapの開始メッセージを表示

3. macOS警告（macOSの場合）
   └─ ネイティブビルドは推奨されない旨の警告を表示

4. Rust環境セットアップ
   └─ rustInstall()関数でrustupとRustをインストール
   └─ multirustがインストールされている場合はアンインストールを促す

5. OS検出とパッケージインストール
   ├─ macOS: osx()→osx_homebrew()/osx_macports()
   ├─ SUSE: suse()
   ├─ Debian/Ubuntu: ubuntu()
   ├─ Fedora: fedora()
   ├─ Gentoo: gentoo()
   ├─ Solus: solus()
   ├─ Arch Linux: archLinux()
   └─ FreeBSD: freebsd()

6. Cargoツールインストール
   └─ just 1.42.4、cbindgen 0.29.0をインストール

7. ブート処理（-dオプションがない場合）
   └─ boot()関数でリポジトリクローンと初期設定

8. 完了メッセージ表示
   └─ ビルド手順のガイダンスを表示
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{ヘルプ要求?}
    B -->|Yes| C[usage表示]
    C --> D[終了]
    B -->|No| E[バナー表示]
    E --> F{macOS?}
    F -->|Yes| G[macOS警告表示]
    G --> H[rustInstall]
    F -->|No| H
    H --> I{rustupインストール済み?}
    I -->|No| J[rustupインストール]
    J --> K[OS検出]
    I -->|Yes| K
    K --> L{OS種別判定}
    L -->|macOS| M[osx関数実行]
    L -->|SUSE| N[suse関数実行]
    L -->|Debian/Ubuntu| O[ubuntu関数実行]
    L -->|Fedora| P[fedora関数実行]
    L -->|Gentoo| Q[gentoo関数実行]
    L -->|Solus| R[solus関数実行]
    L -->|Arch| S[archLinux関数実行]
    L -->|FreeBSD| T[freebsd関数実行]
    M & N & O & P & Q & R & S & T --> U[cargoInstall just/cbindgen]
    U --> V{-d指定?}
    V -->|Yes| W[依存関係のみで終了]
    V -->|No| X[boot関数実行]
    X --> Y[リポジトリクローン]
    Y --> Z[.config作成]
    Z --> AA[完了メッセージ]
    AA --> AB[バッチ終了]
    W --> AB
```

## データベース操作仕様

このバッチはデータベース操作を行いません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | サポート外OS | サポートされないプラットフォームで実行 | サポートOSで再実行 |
| 1 | エミュレータ不明 | 未知のエミュレータ名指定 | qemuまたはvirtualboxを指定 |
| 1 | multirust存在 | 非推奨のmultirustがインストール済み | multirustをアンインストール後に再実行 |
| 1 | Rust未インストール | rustupインストールを拒否後Rustが見つからない | 手動でRustをインストール |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

- パッケージインストール失敗時：パッケージマネージャのログを確認し、手動でインストール
- ネットワークエラー時：接続を確認後に再実行
- 権限エラー時：sudo権限を確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし（set -eにより途中失敗時は即終了） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回のセットアップ実行 |
| 目標処理時間 | ネットワーク速度とパッケージ数に依存（数分〜数十分） |
| メモリ使用量上限 | パッケージマネージャに依存 |

## 排他制御

同一システムでの同時実行は想定されていません。パッケージマネージャによってはロック機構が働きます。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | "Welcome to the Redox bootstrap"バナー |
| 進捗ログ | 各処理ステップ | "Installing packages..."等のメッセージ |
| 終了ログ | バッチ終了時 | "Well it looks like you are ready to go!"メッセージ |
| エラーログ | エラー発生時 | エラー内容とガイダンス |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 特になし | 標準出力 |
| ビルドステータス | Travisビルド失敗時 | 標準出力（-sオプション時） |

## 備考

- macOSでのネイティブビルドは推奨されません。podman_bootstrap.shの使用が推奨されます
- FreeBSDではmakeの代わりにgmakeを使用する必要があります
- cargoInstall関数は既にインストール済みのバージョンがある場合はスキップします
- Travisビルドステータスチェックは非推奨のTravis CI APIを使用しています
