# バッチ設計書 20-recipe-path.sh

## 概要

本ドキュメントは、Redoxオペレーティングシステムのビルドシステムにおけるrecipe-path.shバッチの設計仕様を定義するものである。

### 本バッチの処理概要

このバッチは、レシピ名からレシピパスを検索して出力するシンプルなユーティリティスクリプトである。

**業務上の目的・背景**：Redoxのビルドシステムには多数のレシピが階層的なディレクトリ構造に配置されている。開発者がレシピの場所を素早く特定したい場合、ディレクトリ構造を覚えている必要があるが、本バッチを使用することでレシピ名を指定するだけでパスを取得できる。これにより、スクリプトや他のツールからのレシピパス取得が容易になる。

**バッチの実行タイミング**：手動実行。レシピの場所を確認したいとき、他のスクリプトからレシピパスを取得するときに随時実行される。

**主要な処理内容**：
1. コマンドライン引数からレシピ名を取得
2. findコマンドでrecipes配下を最大4階層まで検索
3. マッチしたパスを出力

**前後の処理との関連**：本バッチは独立して実行可能。出力されたパスは他のスクリプトやコマンドで使用可能。

**影響範囲**：読み取り専用の検索スクリプトであり、システムの状態を変更しない。

## バッチ種別

ユーティリティ（レシピパス検索）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| redoxディレクトリでの実行 | recipesディレクトリが相対パスでアクセス可能であること |
| recipesディレクトリの存在 | レシピディレクトリが存在すること |

### 実行可否判定

特に事前判定なし。レシピ名が指定されていない場合は何も出力されない。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| recipe | string | Yes | N/A | 対象レシピ名（複数指定可能） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| recipes/** | ディレクトリ | レシピディレクトリ群（最大4階層） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | レシピのフルパス |

### 出力ファイル仕様

ファイル出力なし（標準出力のみ）。

| 項目 | 内容 |
|-----|------|
| ファイル名 | N/A |
| 出力先 | 標準出力 |
| 文字コード | UTF-8 |
| 区切り文字 | N/A（1行1パス） |

## 処理フロー

### 処理シーケンス

```
1. 変数設定
   └─ FIND_RECIPE="find recipes -maxdepth 4 -name"
2. レシピループ
   └─ 各レシピ名に対して：
      └─ ${FIND_RECIPE} "${recipe}"を実行
      └─ マッチしたパスを出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{引数あり?}
    B -->|No| C[バッチ終了]
    B -->|Yes| D[レシピループ開始]
    D --> E[find recipes<br/>-maxdepth 4 -name recipe]
    E --> F[パス出力]
    F --> G{次のレシピ?}
    G -->|Yes| D
    G -->|No| C
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

N/A

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 0 | レシピ未発見 | 指定したレシピが存在しない | レシピ名を確認 |
| 非0 | ディレクトリエラー | recipesディレクトリが存在しない | 正しいディレクトリで実行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 自動リトライなし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

エラー発生時は手動で問題を修正後、再実行する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（シェルスクリプト） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 指定されたレシピ数 |
| 目標処理時間 | 1秒以内 |
| メモリ使用量上限 | 最小限 |

## 排他制御

読み取り専用のため、排他制御は不要。複数同時実行可能。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 結果出力 | 正常終了時 | マッチしたレシピパス |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| N/A | N/A | 手動実行のため監視対象外 |

## 備考

- -maxdepth 4により、recipes配下の4階層までを検索対象とする
- find -nameはディレクトリ名の完全一致で検索する
- 同名のレシピが複数の場所にある場合、全てのパスが出力される
- 引数チェックがないため、引数なしで実行すると何も出力されない
- スクリプトは非常にシンプルで、わずか9行で構成されている
- 類似機能を持つfind_recipe（Rust製ツール）が存在するが、本スクリプトはより単純な実装
- 複数のレシピ名を空白区切りで指定可能（$*を使用）
