# バッチ設計書 21-scripts/print-recipe.sh

## 概要

本ドキュメントは、Redoxビルドシステムにおけるレシピ構成ファイル表示バッチ（`scripts/print-recipe.sh`）の設計仕様を記載するものである。

### 本バッチの処理概要

このバッチは、指定されたレシピ名に対応する構成ファイル（`recipe.toml`または`recipe.sh`）の内容を標準出力に表示する。開発者がレシピの設定内容を迅速に確認するためのユーティリティスクリプトである。

**業務上の目的・背景**：Redox OSのビルドシステムでは、各ソフトウェアパッケージ（レシピ）のビルド方法が`recipe.toml`または`recipe.sh`ファイルで定義されている。これらの構成ファイルは`recipes`ディレクトリ配下の複数階層に分散して配置されているため、特定レシピの設定内容を確認する際に毎回ディレクトリを探索するのは非効率である。本バッチは、レシピ名を指定するだけで構成ファイルの内容を即座に確認できるようにし、開発効率の向上を図る。

**バッチの実行タイミング**：開発者が必要とする任意のタイミング（手動実行）。レシピの設定確認、デバッグ、ビルド問題の調査時に使用される。

**主要な処理内容**：
1. 引数として受け取ったレシピ名を`find_recipe`コマンドに渡し、レシピディレクトリのパスを取得
2. 取得したディレクトリパス配下の`recipe.*`ファイル（recipe.tomlまたはrecipe.sh）を`cat`コマンドで表示

**前後の処理との関連**：本バッチは単独で使用されるユーティリティであり、前提となるバッチは存在しない。ただし、`find_recipe`バイナリが必要であるため、事前に`make fstools`でビルドツールが構築されている必要がある。後続バッチとの直接的な依存関係はないが、レシピ設定の確認後にビルド作業（`make r.レシピ名`）が行われることが多い。

**影響範囲**：読み取り専用の処理であり、システムやデータへの影響はない。標準出力への表示のみを行う。

## バッチ種別

ユーティリティ / 情報表示

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | - |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| find_recipeバイナリの存在 | `target/release/find_recipe`が存在し実行可能であること |
| recipesディレクトリの存在 | プロジェクトルートに`recipes`ディレクトリが存在すること |
| 有効なレシピ名 | 引数として指定されたレシピが`recipes`配下に存在すること |

### 実行可否判定

引数（レシピ名）が指定されており、`find_recipe`コマンドが該当するレシピディレクトリを見つけられた場合に実行される。レシピが見つからない場合、`find_recipe`コマンドがエラーを返し、`cat`コマンドが失敗する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| $1 | 文字列 | Yes | なし | レシピ名（例: kernel, ion, bash） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| recipes/*/recipe.toml | TOML | レシピ構成ファイル（TOML形式） |
| recipes/*/recipe.sh | Shell | レシピ構成ファイル（シェルスクリプト形式） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | レシピ構成ファイルの内容 |

### 出力ファイル仕様

本バッチはファイル出力を行わない。標準出力のみ。

| 項目 | 内容 |
|-----|------|
| ファイル名 | - |
| 出力先 | 標準出力 |
| 文字コード | UTF-8 |
| 区切り文字 | - |

## 処理フロー

### 処理シーケンス

```
1. レシピディレクトリ検索
   └─ find_recipeコマンドにレシピ名を渡し、レシピディレクトリのフルパスを取得
2. 構成ファイル表示
   └─ catコマンドで recipe.* ファイルの内容を標準出力に表示
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[引数$1を取得]
    B --> C[find_recipe $1 実行]
    C --> D{レシピ存在?}
    D -->|あり| E[cat recipe.*]
    D -->|なし| F[エラー終了]
    E --> G[標準出力に表示]
    G --> H[バッチ終了]
    F --> H
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし |

### テーブル別操作詳細

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | find_recipe失敗 | 指定されたレシピが見つからない | 正しいレシピ名を指定する |
| 1 | find_recipe未存在 | find_recipeバイナリが存在しない | `make fstools`を実行する |
| 1 | cat失敗 | recipe.*ファイルが存在しない | レシピディレクトリの構成を確認する |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. `find_recipe`が見つからない場合：`make fstools`を実行してビルドツールを構築する
2. レシピが見つからない場合：`scripts/recipe-path.sh`で正しいレシピ名を確認する
3. ディレクトリが見つかるが`recipe.*`がない場合：レシピディレクトリの構成を確認する

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（読み取り専用） |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1レシピ |
| 目標処理時間 | 1秒以内 |
| メモリ使用量上限 | 最小限（catコマンドのみ） |

## 排他制御

排他制御は不要。読み取り専用の処理であり、同時実行による問題は発生しない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | なし | - |
| 進捗ログ | なし | - |
| 終了ログ | なし | - |
| エラーログ | エラー発生時 | catコマンドのエラーメッセージ（標準エラー出力） |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| - | - | 監視対象外（手動実行ユーティリティ） |

## 備考

- 本スクリプトはわずか1行のシンプルな実装である
- `recipe.*`のワイルドカードにより、`recipe.toml`と`recipe.sh`の両形式に対応
- 類似スクリプトとして`scripts/recipe-path.sh`（パス表示のみ）や`scripts/recipe-match.sh`（パターン検索）がある
- find_recipeはRust製のバイナリツールであり、`cookbook`リポジトリで定義されている
