# バッチ設計書 3-podman_bootstrap.sh

## 概要

本ドキュメントは、Podman環境でのRedoxビルドシステムをセットアップするpodman_bootstrap.shスクリプトの設計仕様を定義するものです。このスクリプトは、コンテナベースのビルド環境構築用の依存パッケージをインストールし、リポジトリをクローンします。

### 本バッチの処理概要

podman_bootstrap.shは、Podmanコンテナを使用したRedox OSのビルド環境を構築するためのブートストラップスクリプトです。native_bootstrap.shと比較して、ホストシステムへの依存パッケージのインストールを最小限に抑え、クロスコンパイルに必要なツールチェーンはコンテナ内で管理します。macOS、Linux各ディストリビューション、FreeBSDに対応しています。

**業務上の目的・背景**：Redox OSのビルドには多数のビルドツールやライブラリが必要ですが、これらをすべてホストシステムにインストールすることは、システムの汚染やバージョン競合の原因となります。Podmanコンテナを使用することで、ビルド環境を完全に分離し、再現性の高いビルドを実現します。特にmacOSでは、ネイティブビルドよりもPodmanビルドが推奨されます。

**バッチの実行タイミング**：初回セットアップ時に1回実行します。環境の再構築が必要な場合にも使用できます。

**主要な処理内容**：
1. 動作環境（OS）の検出とパッケージマネージャの特定
2. Rustup/Rustツールチェーンのインストール（ホスト側で使用）
3. Podman関連パッケージ（podman、fuse、slirp4netns等）のインストール
4. エミュレータ（QEMU/VirtualBox）のインストール
5. Redoxリポジトリのクローンと初期設定ファイルの作成（PODMAN_BUILD=1）
6. ARM64アーキテクチャの場合はARCH=aarch64を設定

**前後の処理との関連**：このバッチは環境構築の最初のステップであり、前提となる処理はありません。完了後は、makeコマンドを使用してPodmanコンテナ内でRedox OSのビルドを開始できます。コンテナ初回起動時にpodman/rustinstall.shが実行されます。

**影響範囲**：システム全体のパッケージ（sudo権限で実行）、ユーザーのホームディレクトリ（~/.cargo）、およびカレントディレクトリ（redoxリポジトリのクローン先）に影響します。

## バッチ種別

セットアップ処理 / コンテナ環境構築

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 初回のみ（随時） |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| インターネット接続 | パッケージダウンロードのため必須 |
| sudo権限 | パッケージインストールにroot権限が必要 |
| サポートOS | macOS、Linux（Arch/Debian/Ubuntu/Fedora/SUSE/Gentoo/Solus）、FreeBSD |
| パッケージマネージャ | brew/port（macOS）、apt-get/dnf/pacman/zypper/emerge/eopkg（Linux）、pkg（FreeBSD） |

### 実行可否判定

- サポートされるパッケージマネージャが存在すること
- インターネット接続が可能であること

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| -h, --help | フラグ | No | - | ヘルプ表示 |
| -u [branch] | 文字列 | No | master | gitリポジトリの更新 |
| -e [emulator] | 文字列 | No | qemu | インストールするエミュレータ（virtualbox/qemu） |
| -p [package manager] | 文字列 | No | apt-get | Ubuntu用パッケージマネージャ（apt-fast/aptitude） |
| -d | フラグ | No | - | 依存関係のみインストール（boot処理をスキップ） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| https://sh.rustup.rs | シェルスクリプト | Rustupインストーラ |
| https://gitlab.redox-os.org/redox-os/redox.git | Git | Redoxリポジトリ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| ~/.cargo | ディレクトリ | Rustツールチェーンとcargoバイナリ |
| ~/.rustup | ディレクトリ | Rustupツールチェーン管理 |
| redox/ | ディレクトリ | クローンされたRedoxリポジトリ |
| redox/.config | テキストファイル | ビルド設定（PODMAN_BUILD=1） |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | .config |
| 出力先 | redox/ |
| 文字コード | UTF-8 |
| 内容 | PODMAN_BUILD=1、ARM64の場合はARCH=aarch64も追加 |

## 処理フロー

### 処理シーケンス

```
1. オプション解析
   └─ -h/-u/-e/-p/-dオプションを解析

2. バナー表示
   └─ Podman用Redox bootstrapの開始メッセージを表示

3. Rust環境セットアップ
   └─ rustInstall()関数でrustupとRustをインストール
   └─ multirustがインストールされている場合はアンインストールを促す

4. OS検出とパッケージインストール
   ├─ macOS: osx()→osx_homebrew()/osx_macports()
   ├─ SUSE: suse()
   ├─ Debian/Ubuntu: ubuntu()
   ├─ Fedora: fedora()
   ├─ Gentoo: gentoo()
   ├─ Solus: solus()
   ├─ Arch Linux: archLinux()
   └─ FreeBSD: freebsd()

5. ブート処理（-dオプションがない場合）
   └─ boot()関数でリポジトリクローンと初期設定
   └─ ARM64の場合はARCH=aarch64を追加設定

6. 完了メッセージ表示
   └─ ビルド手順のガイダンスを表示
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{ヘルプ要求?}
    B -->|Yes| C[usage表示]
    C --> D[終了]
    B -->|No| E[バナー表示]
    E --> F[rustInstall]
    F --> G{更新モード?}
    G -->|Yes| H[git pull実行]
    H --> D
    G -->|No| I{macOS?}
    I -->|Yes| J[osx関数実行]
    I -->|No| K[OS検出・パッケージインストール]
    J --> L{-d指定?}
    K --> L
    L -->|Yes| M[依存関係のみで終了]
    L -->|No| N[boot関数実行]
    N --> O[リポジトリクローン]
    O --> P[.config作成 PODMAN_BUILD=1]
    P --> Q{ARM64?}
    Q -->|Yes| R[ARCH=aarch64追加]
    Q -->|No| S[完了メッセージ]
    R --> S
    S --> T[バッチ終了]
    M --> T
```

## データベース操作仕様

このバッチはデータベース操作を行いません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | サポート外OS | サポートされないプラットフォームで実行 | サポートOSで再実行 |
| 1 | エミュレータ不明 | 未知のエミュレータ名指定 | qemuまたはvirtualboxを指定 |
| 1 | multirust存在 | 非推奨のmultirustがインストール済み | multirustをアンインストール後に再実行 |
| 1 | Rust未インストール | rustupインストールを拒否後Rustが見つからない | 手動でRustをインストール |
| 1 | Podman未インストール | Gentoo/Solusでpodmanが見つからない | 手動でPodmanをインストール |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

- パッケージインストール失敗時：パッケージマネージャのログを確認し、手動でインストール
- ネットワークエラー時：接続を確認後に再実行
- Podman起動エラー時：cgroup/namespaceの設定を確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし（set -eにより途中失敗時は即終了） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回のセットアップ実行 |
| 目標処理時間 | ネットワーク速度とパッケージ数に依存（数分〜数十分） |
| メモリ使用量上限 | パッケージマネージャに依存 |

## 排他制御

同一システムでの同時実行は想定されていません。パッケージマネージャによってはロック機構が働きます。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | "Welcome to the redox bootstrap for building with Podman"バナー |
| 進捗ログ | 各処理ステップ | "Installing required packages..."等のメッセージ |
| 終了ログ | バッチ終了時 | "Well it looks like you are ready to go!"メッセージ |
| エラーログ | エラー発生時 | エラー内容とガイダンス |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 特になし | 標準出力 |

## 備考

- native_bootstrap.shと比較して、インストールするパッケージ数が大幅に少ない
- Podmanビルドはmake実行時に自動的にコンテナを起動します
- REPO_BINARY=1を.configに追加すると、より高速なインストールが可能です
- GentooとSolusではPodmanを手動でインストールする必要があります
- ARM64（Apple Silicon等）ではARCH=aarch64が自動設定されます
- FreeBSDではmakeの代わりにgmakeを使用する必要があります
