# バッチ設計書 4-rustinstall.sh

## 概要

本ドキュメントは、Podmanコンテナ内でRustツールチェーンとビルド依存ツール（sccache、just、cbindgen）をインストールするpodman/rustinstall.shスクリプトの設計仕様を定義するものです。このスクリプトは、Podmanイメージビルド後の初期化処理として実行されます。

### 本バッチの処理概要

rustinstall.shは、Podmanコンテナ内のビルド環境を完成させるための初期化スクリプトです。Rustup経由でRustツールチェーンをインストールし、ビルドを高速化するためのsccache、ビルドタスクランナーのjust、Rust-C FFIバインディング生成ツールのcbindgenをダウンロードします。

**業務上の目的・背景**：Podmanコンテナベースのビルド環境では、コンテナイメージサイズを最小限に抑えるため、初回起動時に必要なツールチェーンをダウンロードします。これにより、コンテナイメージの配布サイズを削減しつつ、常に最新の安定版ツールチェーンを使用できます。sccacheを使用することで、再ビルド時のコンパイル時間を大幅に短縮できます。

**バッチの実行タイミング**：Podmanコンテナの初回起動時に自動実行されます。コンテナイメージのビルド後、初めてmakeコマンドを実行したときに呼び出されます。

**主要な処理内容**：
1. Rustup経由でRustツールチェーン（stable）をインストール
2. GitHubリリースからsccache（v0.10.0）をダウンロードしてインストール
3. GitHubリリースからjust（1.45.0）をダウンロードしてインストール
4. GitHubリリースからcbindgen（0.29.0）をダウンロードしてインストール

**前後の処理との関連**：このバッチはpodman_bootstrap.shでホスト環境が構築され、Podmanコンテナが初めて起動される際に実行されます。完了後は、コンテナ内でビルドコマンドを実行できるようになります。

**影響範囲**：コンテナ内の~/.cargoディレクトリにRustツールチェーンとバイナリツールがインストールされます。

## バッチ種別

セットアップ処理 / ツールチェーンインストール

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | コンテナ初回起動時のみ |
| 実行時刻 | コンテナ起動時 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | Podmanコンテナ初期化 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Podmanコンテナ内 | Podmanコンテナ環境で実行される必要がある |
| インターネット接続 | GitHub/rustup.rsへのアクセスが必要 |
| curl/wget | ダウンロードツールがインストール済み |
| tar | アーカイブ展開ツールがインストール済み |

### 実行可否判定

- インターネット接続が可能であること
- curl、wget、tarコマンドが利用可能であること

## 入力仕様

### 入力パラメータ

このスクリプトは引数を受け取りません。

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| （なし） | - | - | - | - |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| https://sh.rustup.rs | シェルスクリプト | Rustupインストーラ |
| https://github.com/mozilla/sccache/releases | tar.gz | sccacheバイナリ |
| https://github.com/casey/just/releases | tar.gz | justバイナリ |
| https://github.com/mozilla/cbindgen/releases | バイナリ | cbindgenバイナリ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| ~/.cargo/bin/rustc | バイナリ | Rustコンパイラ |
| ~/.cargo/bin/cargo | バイナリ | Cargoパッケージマネージャ |
| ~/.cargo/bin/sccache | バイナリ | 分散コンパイルキャッシュ |
| ~/.cargo/bin/just | バイナリ | ビルドタスクランナー |
| ~/.cargo/bin/cbindgen | バイナリ | CバインディングジェネレータC |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | sccache, just, cbindgen |
| 出力先 | ~/.cargo/bin/ |
| 実行権限 | 755（実行可能） |

## 処理フロー

### 処理シーケンス

```
1. Rustインストール
   └─ curl https://sh.rustup.rs | sh -s -- -y --default-toolchain stable --profile minimal
   └─ 非対話モード、stable版、最小プロファイル

2. sccacheダウンロード
   └─ GitHubリリースv0.10.0からアーキテクチャ固有のtar.gzをダウンロード
   └─ tar展開して~/.cargo/bin/に配置

3. justダウンロード
   └─ GitHubリリース1.45.0からアーキテクチャ固有のtar.gzをダウンロード
   └─ tar展開して~/.cargo/bin/に配置

4. cbindgenダウンロード
   └─ GitHubリリース0.29.0からアーキテクチャ固有のバイナリをダウンロード
   └─ ~/.cargo/bin/に配置して実行権限を付与
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[Rustインストール]
    B --> C[curl rustup.rs実行]
    C --> D[sccacheダウンロード]
    D --> E[アーキテクチャ判定]
    E --> F[sccache tar.gz取得・展開]
    F --> G[justダウンロード]
    G --> H[just tar.gz取得・展開]
    H --> I[cbindgenダウンロード]
    I --> J{アーキテクチャ判定}
    J -->|x86_64| K[ubuntu22.04版取得]
    J -->|aarch64| L[ubuntu22.04-aarch64版取得]
    K --> M[実行権限付与]
    L --> M
    M --> N[バッチ終了]
```

## データベース操作仕様

このバッチはデータベース操作を行いません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ネットワークエラー | GitHub/rustup.rsへの接続失敗 | ネットワーク接続を確認後再実行 |
| - | ダウンロードエラー | 指定されたリリースバージョンが存在しない | バージョン番号を確認 |
| - | 権限エラー | ~/.cargo/binへの書き込み権限がない | ディレクトリ権限を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

- ダウンロード失敗時：ネットワーク接続を確認し、コンテナを再起動
- バージョン不整合時：スクリプト内のバージョン番号を最新に更新

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回のセットアップ実行 |
| 目標処理時間 | ネットワーク速度に依存（通常1〜5分） |
| メモリ使用量上限 | 最小限 |

## 排他制御

同一コンテナ内での同時実行は想定されていません。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | 各ステップ開始時 | "Installing rust...", "Downloading sccache..."等 |
| 進捗ログ | ダウンロード中 | wgetの--show-progressによる進捗表示 |
| 終了ログ | なし | - |
| エラーログ | エラー発生時 | wgetのエラーメッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 特になし | 標準出力 |

## 備考

- sccacheはMozilla製の分散コンパイルキャッシュで、ビルド時間を大幅に短縮します
- justはmakeの代替となるビルドタスクランナーで、Redoxのビルドシステムで使用されます
- cbindgenはRustコードからCヘッダファイルを生成するツールです
- アーキテクチャは`uname -m`で自動検出されます
- cbindgenはx86_64とaarch64で異なるバイナリがダウンロードされます
- rustupは--profile minimalオプションで最小限のコンポーネントのみインストールします
