# バッチ設計書 6-executables.sh

## 概要

本ドキュメントは、レシピの実行ファイル名を一覧表示し重複を検出するscripts/executables.shスクリプトの設計仕様を定義するものです。このスクリプトは、実行ファイル名の競合確認用です。

### 本バッチの処理概要

executables.shは、Redox OSのすべてのレシピについて、ビルドされた実行ファイルの名前を収集し、重複（名前の競合）を検出するユーティリティスクリプトです。複数のレシピが同じ名前の実行ファイルを提供しようとすると、システム上で競合が発生するため、このスクリプトでそのような問題を事前に検出します。

**業務上の目的・背景**：Redox OSには多数のパッケージ（レシピ）が含まれており、それぞれが複数の実行ファイルを提供する可能性があります。異なるパッケージが同じ名前の実行ファイルを提供しようとすると、インストール時や実行時に競合が発生します。このスクリプトを使用することで、パッケージ管理者は名前の重複を早期に発見し、適切な対処（リネーム、依存関係の調整等）を行えます。

**バッチの実行タイミング**：手動実行。新しいレシピを追加したとき、または定期的な整合性チェックとして使用します。

**主要な処理内容**：
1. 対象レシピの一覧を取得（引数で指定、または全レシピ）
2. 各レシピのstageディレクトリから実行ファイルを検索
3. 実行ファイル名をレシピ名とともにリスト化
4. ソート後、重複する名前のみを抽出して表示

**前後の処理との関連**：このバッチはビルドが完了したレシピに対して実行します。stageディレクトリに実行ファイルが存在する必要があります。

**影響範囲**：読み取り専用の操作であり、ファイルシステムやリポジトリに変更を加えません。

## バッチ種別

ユーティリティ / 検証

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| ビルド済みレシピ | target/ARCH/stageディレクトリに実行ファイルが存在すること |
| list_recipes | target/release/list_recipesがビルド済みであること（レシピ指定なしの場合） |
| find_recipe | target/release/find_recipeがビルド済みであること |

### 実行可否判定

- 対象レシピが少なくとも1つ存在すること
- レシピのstageディレクトリが存在すること

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| -h | フラグ | No | - | ヘルプ表示 |
| -a | フラグ | No | - | 重複だけでなく全実行ファイルを表示 |
| -arm64 | フラグ | No | - | aarch64アーキテクチャ対象 |
| -i686 | フラグ | No | - | i686アーキテクチャ対象 |
| recipes | 文字列（複数可） | No | 全レシピ | 対象レシピ名（スペース区切り） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| recipes/**/target/ARCH/stage/ | ディレクトリ | ビルド済み実行ファイル |
| target/release/list_recipes | バイナリ | レシピ一覧ツール |
| target/release/find_recipe | バイナリ | レシピパス検索ツール |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | レシピパスと実行ファイル名の一覧 |

### 出力ファイル仕様

ファイル出力はありません。標準出力に結果が表示されます。

| 項目 | 内容 |
|-----|------|
| 出力形式 | "recipe_path executable_name" |
| 文字コード | UTF-8 |
| 区切り文字 | スペース |

## 処理フロー

### 処理シーケンス

```
1. オプション解析
   └─ -h/-a/-arm64/-i686オプションと対象レシピを解析

2. ターゲットアーキテクチャ決定
   ├─ デフォルト: x86_64-unknown-redox
   ├─ -arm64: aarch64-unknown-redox
   └─ -i686: i686-unknown-redox

3. レシピ一覧取得
   ├─ 引数で指定された場合: 指定されたレシピを使用
   └─ 指定なし: target/release/list_recipesで全レシピ取得

4. 各レシピの実行ファイル検索
   ├─ レシピパス取得（パス形式 or find_recipe使用）
   ├─ stage/usr/binから実行ファイル検索
   └─ stage/binから実行ファイル検索

5. 結果のソートと重複抽出
   ├─ sortでソート
   ├─ デフォルト: uniq -D --skip-fields=1で重複のみ表示
   └─ -a: catで全件表示
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{-h指定?}
    B -->|Yes| C[usage表示]
    C --> D[終了]
    B -->|No| E[オプション解析]
    E --> F{アーキテクチャ指定?}
    F -->|-arm64| G[target=aarch64-unknown-redox]
    F -->|-i686| H[target=i686-unknown-redox]
    F -->|なし| I[target=x86_64-unknown-redox]
    G --> J{レシピ指定?}
    H --> J
    I --> J
    J -->|Yes| K[指定レシピを使用]
    J -->|No| L[list_recipesで全レシピ取得]
    K --> M{次のレシピ?}
    L --> M
    M -->|Yes| N{パス形式?}
    N -->|Yes| O[recipesパスを使用]
    N -->|No| P[find_recipeでパス取得]
    O --> Q[stage/usr/bin検索]
    P --> Q
    Q --> R[stage/bin検索]
    R --> S[結果出力]
    S --> M
    M -->|No| T[sort実行]
    T --> U{-a指定?}
    U -->|Yes| V[全件表示]
    U -->|No| W[重複のみ表示]
    V --> X[バッチ終了]
    W --> X
```

## データベース操作仕様

このバッチはデータベース操作を行いません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ディレクトリなし | stageディレクトリが存在しない場合 | find 2> /dev/nullで無視 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

- stageディレクトリがない場合：対象レシピをビルド
- list_recipes/find_recipeがない場合：make toolsでビルド

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（読み取り専用） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数十〜数百レシピ |
| 目標処理時間 | 数秒〜数十秒 |
| メモリ使用量上限 | 最小限 |

## 排他制御

読み取り専用のため排他制御は不要です。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | なし | - |
| 進捗ログ | なし | - |
| 終了ログ | なし | - |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 特になし | 標準出力 |

## 備考

- デフォルトではx86_64アーキテクチャが対象です
- 重複検出には`uniq -D --skip-fields=1`が使用され、2番目のフィールド（実行ファイル名）で重複を判定します
- レシピ名をパス形式（category/recipe）で指定した場合は、recipes/パスを直接使用します
- レシピ名のみを指定した場合は、find_recipeでパスを検索します
- stage/usr/binとstage/binの両方を検索対象としています
- 出力形式は「レシピパス 実行ファイル名」でソートされます
