# バッチ設計書 7-mount-redoxfs.sh

## 概要

本ドキュメントは、RedoxFSパーティションをマウント/アンマウントするscripts/mount-redoxfs.shスクリプトの設計仕様を定義するものです。このスクリプトは、FUSE経由でRedoxファイルシステムにアクセスするために使用します。

### 本バッチの処理概要

mount-redoxfs.shは、Redox OS専用のファイルシステム（RedoxFS）をLinuxホスト上にマウントするユーティリティスクリプトです。FUSE（Filesystem in Userspace）を使用してRedoxFSパーティションをマウントし、ホストシステムからファイルの読み書きを可能にします。デュアルブート環境でRedoxパーティションにアクセスする場合や、ビルドしたイメージの内容を確認する場合に使用します。

**業務上の目的・背景**：Redox OSをデュアルブート構成でインストールした場合や、RedoxFS形式のディスクイメージを作成した場合、そのファイルシステムにホストLinuxからアクセスする必要が生じることがあります。このスクリプトを使用することで、専用のredoxfsコマンドを適切なパラメータで呼び出し、簡単にマウント/アンマウントができます。

**バッチの実行タイミング**：手動実行。RedoxFSパーティションやイメージにアクセスしたいときに使用します。

**主要な処理内容**：
1. コマンドライン引数の解析（マウント/アンマウントモード、マウントポイント、デバイス指定）
2. アンマウントモードの場合はfusermount/fusermount3でアンマウント
3. マウントモードの場合は依存関係（redoxfs、libfuse3）の確認
4. マウントポイントディレクトリの作成
5. redoxfsコマンドでマウント実行

**前後の処理との関連**：マウント操作の前に、make fstoolsでredoxfsコマンドをビルドしておく必要があります。また、libfuse3がシステムにインストールされている必要があります。

**影響範囲**：指定したマウントポイントにファイルシステムがマウントされます。アンマウントするまでマウントポイントはRedoxFSとして使用されます。

## バッチ種別

ユーティリティ / ファイルシステム操作

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| redoxfsコマンド | build/fstools/bin/redoxfsが存在、またはPATHにredoxfsが存在 |
| libfuse3 | libfuse 3.xがシステムにインストール済み |
| ブロックデバイス | マウント対象のデバイスまたはイメージファイルが存在 |

### 実行可否判定

- redoxfsコマンドが利用可能であること
- libfuse3がインストールされていること
- 指定されたデバイスがブロックデバイスまたはファイルとして存在すること

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| -u, --unmount | フラグ | No | - | アンマウントモード |
| -m, --mount-point | 文字列 | No | /mnt/redoxfs | マウントポイントのパス |
| -h, --help | フラグ | No | - | ヘルプ表示 |
| device | 文字列 | No | /dev/disk/by-partlabel/REDOX_INSTALL | マウント対象デバイス |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| /dev/disk/by-partlabel/REDOX_INSTALL | ブロックデバイス | デフォルトのRedoxパーティション |
| 任意のブロックデバイス | ブロックデバイス | 指定されたデバイス |
| 任意のファイル | ファイル | ディスクイメージファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| マウントポイント | ディレクトリ | RedoxFSがマウントされたディレクトリ |
| 標準出力 | テキスト | 操作結果メッセージ |

### 出力ファイル仕様

ファイルシステムのマウントのため、出力ファイルはありません。

## 処理フロー

### 処理シーケンス

```
1. オプション解析
   └─ -u/-m/-h/deviceオプションを解析

2. アンマウントモード判定
   └─ -u指定時はunmount_fs()を実行して終了

3. デバイス指定確認
   └─ デバイス未指定時は/dev/disk/by-partlabel/REDOX_INSTALLを使用

4. デバイス存在確認
   └─ ブロックデバイスまたはファイルとして存在するか確認

5. 依存関係確認
   ├─ redoxfsコマンドの検索（build/fstools/bin、相対パス、PATH）
   └─ libfuse3の確認（ldconfig -p）

6. マウントポイント作成
   └─ mkdir -pでディレクトリ作成

7. マウント実行
   └─ redoxfs <device> <mount_point>を実行
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[オプション解析]
    B --> C{-u指定?}
    C -->|Yes| D{マウント中?}
    D -->|Yes| E[fusermount -u実行]
    E --> F[終了]
    D -->|No| G["Nothing mounted"出力]
    G --> F
    C -->|No| H{デバイス指定?}
    H -->|No| I[デフォルトデバイス使用]
    H -->|Yes| J[指定デバイス使用]
    I --> K{デバイス存在?}
    J --> K
    K -->|No| L[エラー終了]
    K -->|Yes| M[check_dependencies]
    M --> N{redoxfs存在?}
    N -->|No| O["Error: redoxfs not found"終了]
    N -->|Yes| P{libfuse3存在?}
    P -->|No| Q["Error: libfuse3 not installed"終了]
    P -->|Yes| R[mkdir -p マウントポイント]
    R --> S[redoxfs実行]
    S --> T["Successfully mounted"出力]
    T --> F
```

## データベース操作仕様

このバッチはデータベース操作を行いません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | redoxfsなし | redoxfsコマンドが見つからない | make fstoolsでビルド |
| 1 | libfuse3なし | libfuse3がインストールされていない | パッケージマネージャでインストール |
| 1 | デバイスなし | 指定デバイスが存在しない | 正しいデバイスパスを指定 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

- redoxfsがない場合：`make fstools`を実行
- libfuse3がない場合：パッケージマネージャでfuse3をインストール
- アンマウント失敗時：ファイルシステムが使用中でないか確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回のマウント/アンマウント |
| 目標処理時間 | 1秒未満 |
| メモリ使用量上限 | 最小限 |

## 排他制御

同一マウントポイントへの重複マウントは不可能です（fusermountによる排他制御）。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | マウント開始時 | "Mounting <device> to <mount_point>..." |
| 終了ログ | マウント成功時 | "RedoxFS successfully mounted at <mount_point>" |
| エラーログ | エラー発生時 | エラー内容とインストール手順 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 特になし | 標準出力 |

## 備考

- デフォルトマウントポイントは/mnt/redoxfsです
- デフォルトデバイスは/dev/disk/by-partlabel/REDOX_INSTALL（デュアルブートインストール時のパーティション）です
- fusermount/fusermount3の両方に対応しています
- redoxfsコマンドは複数の場所から検索されます：build/fstools/bin/redoxfs、スクリプト相対パス、PATH
- アンマウント時はmountpointコマンドでマウント状態を確認します
- libfuse3のチェックにはldconfig -pを使用します
- ディスクイメージファイルもマウント可能です（-fオプション不要）
