# バッチ設計書 8-cargo-update.sh

## 概要

本ドキュメントは、指定されたレシピのCargoパッケージを更新するscripts/cargo-update.shスクリプトの設計仕様を定義するものです。このスクリプトは、make f.recipe実行後にcargo updateを実行します。

### 本バッチの処理概要

cargo-update.shは、Rustで書かれたRedoxのレシピについて、Cargo.lockファイルを更新して依存パッケージを最新バージョンに更新するユーティリティスクリプトです。レシピのソースコードをフェッチした後、cargo updateコマンドを実行して依存関係を更新します。

**業務上の目的・背景**：RustプロジェクトではCargo.lockファイルによって依存パッケージのバージョンが固定されていますが、セキュリティ更新や新機能の利用のために定期的に依存パッケージを更新する必要があります。このスクリプトを使用することで、特定のレシピの依存関係を簡単に最新化できます。

**バッチの実行タイミング**：手動実行。レシピの依存パッケージを更新したいときに使用します。

**主要な処理内容**：
1. 引数で指定されたレシピ名を取得
2. recipesディレクトリからレシピパスを検索
3. make f.{recipe_name}でソースコードをフェッチ
4. ソースディレクトリに移動してcargo updateを実行

**前後の処理との関連**：このバッチを実行すると、対象レシピのCargo.lockファイルが更新されます。その後、make {recipe_name}でレシピを再ビルドすると、更新された依存パッケージでビルドされます。

**影響範囲**：指定したレシピのsource/Cargo.lockファイルが更新されます。

## バッチ種別

ユーティリティ / 依存関係更新

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Rustツールチェーン | cargoコマンドが使用可能であること |
| レシピ存在 | 指定されたレシピがrecipes/配下に存在すること |
| Cargoプロジェクト | レシピがRust/Cargoプロジェクトであること |

### 実行可否判定

- 指定されたレシピ名が有効であること
- レシピのsourceディレクトリにCargo.tomlが存在すること

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| recipe_name | 文字列 | Yes | - | 更新対象のレシピ名 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| recipes/**/source/ | ディレクトリ | レシピのソースコード |
| Cargo.toml | TOML | Cargoプロジェクト設定 |
| Cargo.lock | TOML | 依存パッケージバージョンロック |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| Cargo.lock | TOML | 更新された依存パッケージバージョン |
| 標準出力 | テキスト | make/cargo updateの実行結果 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | Cargo.lock |
| 出力先 | recipes/{category}/{recipe}/source/ |
| 文字コード | UTF-8 |

## 処理フロー

### 処理シーケンス

```
1. レシピ名取得
   └─ 第1引数をrecipe_nameとして取得

2. レシピパス検索
   └─ find recipes -name "$recipe_name" -maxdepth 4でパス取得

3. ソースフェッチ
   └─ make f."$recipe_name"を実行

4. ディレクトリ移動
   └─ cd "$recipe_path"/sourceに移動

5. cargo update実行
   └─ cargo updateでCargo.lockを更新
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[recipe_name取得]
    B --> C[find recipes -name recipe_name]
    C --> D[make f.recipe_name]
    D --> E[cd recipe_path/source]
    E --> F[cargo update]
    F --> G[バッチ終了]
```

## データベース操作仕様

このバッチはデータベース操作を行いません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | レシピ未発見 | 指定されたレシピが見つからない | 正しいレシピ名を指定 |
| - | フェッチ失敗 | make f.recipeが失敗 | ネットワーク接続を確認 |
| - | cargo失敗 | Cargo.tomlが存在しないまたは不正 | Rustプロジェクトか確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

- レシピが見つからない場合：scripts/find-recipe.shでレシピを検索
- ネットワークエラー時：接続を確認後に再実行
- Cargoエラー時：Cargo.tomlを確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1レシピ |
| 目標処理時間 | ネットワーク速度と依存パッケージ数に依存（数秒〜数分） |
| メモリ使用量上限 | Cargoに依存 |

## 排他制御

同一レシピへの同時実行は推奨されません。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | make実行時 | makeの出力 |
| 進捗ログ | cargo update時 | パッケージ更新情報 |
| 終了ログ | 完了時 | cargo updateの結果 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 特になし | 標準出力 |

## 備考

- このスクリプトは非常にシンプルで、引数チェックやエラーハンドリングが最小限です
- findコマンドは最大4階層まで検索します
- Rustプロジェクト以外のレシピで実行すると、cargo updateがエラーになります
- カレントディレクトリがレシピのsourceに変更されるため、呼び出し元のディレクトリには戻りません
- Cargo.lockの変更はgitでトラッキングされるため、更新後はコミットが必要です
