# バッチ設計書 9-backtrace.sh

## 概要

本ドキュメントは、Redoxからコピーしたバックトレースのシンボルを解決するscripts/backtrace.shスクリプトの設計仕様を定義するものです。このスクリプトは、addr2lineを使用してデバッグ情報を表示します。

### 本バッチの処理概要

backtrace.shは、Redox OS上で発生したクラッシュやパニックのバックトレースを、人間が読める形式のシンボル情報に変換するデバッグユーティリティです。Redoxからコピーしたアドレスリストやバックトレースファイルを入力として、対応する実行ファイルのデバッグ情報を使用してシンボルを解決します。

**業務上の目的・背景**：Redox OS上でプログラムがクラッシュした際、バックトレースにはメモリアドレスのみが表示されます。開発者がこれらのアドレスから問題箇所を特定するには、デバッグシンボルを使用してソースコードの関数名と行番号に変換する必要があります。このスクリプトは、その変換作業を自動化します。

**バッチの実行タイミング**：手動実行。Redox OSでクラッシュやパニックが発生し、バックトレースを解析する必要があるときに使用します。

**主要な処理内容**：
1. コマンドライン引数の解析（レシピ名、実行ファイル名、アーキテクチャ、入力ファイル/アドレス）
2. レシピディレクトリの特定
3. 対応する実行ファイル（debug/release）の特定
4. addr2lineコマンドでアドレスをシンボル情報に変換

**前後の処理との関連**：このバッチは、デバッグシンボル付きでビルドされた実行ファイルが必要です。Redox OSでクラッシュが発生した後、バックトレースをテキストファイルとして保存するか、アドレスを直接指定して実行します。

**影響範囲**：読み取り専用の操作であり、ファイルシステムやリポジトリに変更を加えません。

## バッチ種別

デバッグ処理 / シンボル解決

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| addr2line | addr2lineコマンドが使用可能であること |
| デバッグシンボル | 対象実行ファイルがデバッグ情報付きでビルドされていること |
| find_recipe | target/release/find_recipeがビルド済みであること |

### 実行可否判定

- 指定されたレシピが存在すること
- 対応する実行ファイルが存在すること

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| -r recipe | 文字列 | Yes | - | レシピ名 |
| -e command_name | 文字列 | No | レシピ名と同じ | 実行ファイル名 |
| -X | フラグ | No | - | x86_64アーキテクチャ |
| -A | フラグ | No | - | aarch64アーキテクチャ |
| -6 | フラグ | No | - | i686アーキテクチャ |
| -b backtracefile | 文字列 | No | - | バックトレースファイル |
| -R | フラグ | No | - | release版実行ファイルを強制使用 |
| addr1 addr2 ... | 文字列（複数可） | 条件付き | - | 解決するアドレス（-bがない場合必須） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| バックトレースファイル | テキスト | アドレスを含むバックトレース |
| 実行ファイル | ELF | デバッグシンボル付き実行ファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 解決されたシンボル情報（関数名、ファイル名、行番号） |

### 出力ファイル仕様

ファイル出力はありません。標準出力にシンボル情報が表示されます。

| 項目 | 内容 |
|-----|------|
| 出力形式 | addr2line --pretty-print形式 |
| 文字コード | UTF-8 |

## 処理フロー

### 処理シーケンス

```
1. オプション解析
   └─ -r/-e/-X/-A/-6/-b/-R/-hオプションとアドレスを解析

2. 入力検証
   └─ -rが必須、-bまたはアドレスが必要

3. レシピディレクトリ取得
   └─ target/release/find_recipeでパス取得

4. 実行ファイル名決定
   └─ -e指定がなければレシピ名を使用

5. 実行ファイルパス構築
   ├─ まずdebugビルドを検索
   └─ -Rまたはdebugがなければreleaseを使用

6. addr2line実行
   ├─ アドレス直接指定: addr2line --exe=EXECUTABLE addr1 addr2 ...
   └─ ファイル指定: sed | addr2line --exe=EXECUTABLE
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[オプション解析]
    B --> C{-r指定?}
    C -->|No| D[usage表示]
    D --> E[終了]
    C -->|Yes| F{-bまたはaddr指定?}
    F -->|No| D
    F -->|Yes| G[find_recipeでレシピパス取得]
    G --> H{-e指定?}
    H -->|No| I[COMMAND=レシピ名]
    H -->|Yes| J[COMMAND=指定値]
    I --> K{debug版存在?}
    J --> K
    K -->|Yes かつ -Rなし| L[debug版使用]
    K -->|No または -R指定| M[release版使用]
    L --> N{ファイル入力?}
    M --> N
    N -->|Yes| O[sed + addr2line]
    N -->|No| P[addr2line直接実行]
    O --> Q[シンボル情報出力]
    P --> Q
    Q --> E
```

## データベース操作仕様

このバッチはデータベース操作を行いません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 引数不足 | -rが指定されていない | -rオプションでレシピ名を指定 |
| - | 入力不足 | -bもアドレスも指定されていない | -bでファイル指定またはアドレスを直接指定 |
| - | 実行ファイルなし | 対応する実行ファイルが見つからない | レシピをビルド |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

- 実行ファイルがない場合：対象レシピをデバッグ情報付きでビルド
- シンボルが解決されない場合：デバッグビルドか確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（読み取り専用） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数十〜数百アドレス |
| 目標処理時間 | 1秒未満（通常） |
| メモリ使用量上限 | 実行ファイルサイズに依存 |

## 排他制御

読み取り専用のため排他制御は不要です。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | なし | - |
| 進捗ログ | なし | - |
| 終了ログ | なし | - |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 特になし | 標準出力 |

## 備考

- デフォルトアーキテクチャはx86_64です
- 実行ファイル名が"recipe_command"形式の場合、"command"部分のみを-eオプションで指定します
- debug版が優先的に使用されますが、-Rオプションでrelease版を強制できます
- バックトレースファイルは、空行を除去し、"0x"に続くアドレスを抽出してaddr2lineに渡されます
- addr2lineのオプション：--demangle=rust（Rustシンボルのデマングル）、--inlines（インライン展開）、--pretty-print（整形出力）、--functions（関数名表示）
- 標準入力からの読み取りには"-b -"を使用します
- 実行ファイルのパス構造：recipes/{category}/{recipe}/target/{ARCH}-unknown-redox/build/target/{ARCH}-unknown-redox/{debug|release}/{command}
