---
generated_at: 2026-01-22 23:50:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：1-build.sh

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠があります

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `build.sh` - ソースコード（1-106行目）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧定義
- E-03: `build.sh` usage関数（11-45行目） - ヘルプメッセージ定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | x86_64、aarch64、i586、riscv64gcのアーキテクチャに対応 | E-01（60-68行目）、E-03 | ○ |
| C-02 | デフォルトアーキテクチャはx86_64 | E-01（52行目：defaultarch="x86_64"） | ○ |
| C-03 | デフォルト設定名はdesktop | E-01（53行目：defaultname="desktop"） | ○ |
| C-04 | -Xオプションでx86_64を指定 | E-01（64行目）、E-03 | ○ |
| C-05 | -Aオプションでaarch64を指定 | E-01（65行目）、E-03 | ○ |
| C-06 | -Rオプションでriscv64gcを指定 | E-01（66行目） | ○ |
| C-07 | -5オプションでi586を指定 | E-01（67行目） | ○ |
| C-08 | -6オプションは非推奨（i586と同等） | E-01（68行目）、E-03（20行目） | ○ |
| C-09 | getoptsを使用してオプション解析 | E-01（58行目：while getopts） | ○ |
| C-10 | FILESYSTEM_CONFIG未指定時はconfig/ARCH/CONFIG_NAME.tomlを設定 | E-01（100-102行目） | ○ |
| C-11 | 環境変数ARCH、CONFIG_NAME、FILESYSTEM_CONFIGをエクスポート | E-01（104行目） | ○ |
| C-12 | makeコマンドを実行 | E-01（105行目：make $@） | ○ |
| C-13 | ディレクトリ名からアーキテクチャを推論 | E-01（76-86行目） | ○ |
| C-14 | ファイル名から設定名を推論 | E-01（88-90行目） | ○ |
| C-15 | 不明オプション時にエラーメッセージ表示 | E-01（70行目） | ○ |
| C-16 | 値が必要なオプションに値がない場合エラー | E-01（71行目） | ○ |
| C-17 | ヘルプオプション時にusage表示 | E-01（47-50行目）、E-03 | ○ |
| C-18 | 出力先はbuild/ARCH/CONFIG/ディレクトリ | E-03（39-40行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- すべての主要な主張に対して根拠が確認できました
- 追加の検証が望ましい項目はありません

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認できています

## 6) レビュアーチェックリスト（最小）
- [ ] usage関数の説明がソースコードの動作と一致しているか確認
- [ ] サポートアーキテクチャの一覧が最新か確認
- [ ] デフォルト値（x86_64、desktop）が正しいか確認
