---
generated_at: 2026-01-23 00:08:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：10-dual-boot.sh

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠があります

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scripts/dual-boot.sh` - ソースコード（全61行）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | デフォルトパーティションは/dev/disk/by-partlabel/REDOX_INSTALL | E-01（12行目） | ○ |
| C-02 | 引数でデバイス指定可能 | E-01（8-11行目） | ○ |
| C-03 | ブロックデバイスでない場合エラー | E-01（15-18行目） | ○ |
| C-04 | ARCH未設定ならuname -m | E-01（20-23行目） | ○ |
| C-05 | CONFIG_NAME未設定ならdesktop | E-01（25-28行目） | ○ |
| C-06 | filesystem.imgをビルド | E-01（30-34行目） | ○ |
| C-07 | popsicleでイメージ書き込み | E-01（35行目） | ○ |
| C-08 | bootctl --print-esp-pathでESP取得 | E-01（38行目） | ○ |
| C-09 | ESPが見つからない場合エラー | E-01（39-42行目） | ○ |
| C-10 | bootloader.efiをESP/EFI/redox.efiにコピー | E-01（45-48行目） | ○ |
| C-11 | redox.confをESP/loader/entries/に作成 | E-01（49-52行目） | ○ |
| C-12 | エントリ内容はtitle/efi | E-01（49-52行目） | ○ |
| C-13 | syncで書き込みフラッシュ | E-01（55行目） | ○ |
| C-14 | 完了メッセージを表示 | E-01（57-58行目） | ○ |
| C-15 | マウント手順を案内 | E-01（59-61行目） | ○ |
| C-16 | set -eでエラー時終了 | E-01（6行目） | ○ |
| C-17 | set -xでコマンドエコー | E-01（32行目、46行目） | ○ |
| C-18 | ブートローダーパスはrecipes/core/bootloader/... | E-01（45行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- すべての主要な主張に対して根拠が確認できました
- 追加の検証が望ましい項目はありません

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認できています
- 注意：パーティションへの書き込み操作のため、データ消失リスクあり

## 6) レビュアーチェックリスト（最小）
- [ ] popsicleツールがインストールされているか確認
- [ ] systemd-boot環境であるか確認
- [ ] ESPパスが正しく取得されるか確認
- [ ] ブートローダーがビルド済みか確認
- [ ] パーティションラベル（REDOX_INSTALL）が正しく設定されているか確認
