---
generated_at: 2026-01-22 23:50:00
metrics:
  claims_total: 12
  claims_with_evidence: 11
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：11-category.sh

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：11 / 12、根拠なし：1
- 優先レビュー（高）
  1. **アクション種別の詳細**：一部推測に基づく
  2. **カテゴリ構造**：実際のディレクトリ構造要確認
  3. **makeターゲット形式**：Makefileの確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scripts/category.sh` - ソースコード（行1-15）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧（行12）
- E-03: スクリプト内コメント「This script run the recipe command options on some Cookbook category」

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | カテゴリに対してレシピコマンドを実行する | E-01, E-03 | ○ |
| C-02 | 引数は2つ必須（アクションとカテゴリ） | E-01（行5-12） | ○ |
| C-03 | 引数不足時はUsageを表示してexit 1 | E-01（行6-12） | ○ |
| C-04 | makeコマンドを"action.--category-category"形式で実行 | E-01（行14） | ○ |
| C-05 | アクションから先頭ハイフンを除去 | E-01（行14の${1#-}） | ○ |
| C-06 | 対応アクション：f, r, c, u, p | E-01（行9） | ○ |
| C-07 | カテゴリ例：core, wip, wip/dev | E-01（行10） | ○ |
| C-08 | redoxディレクトリでの実行が前提 | E-01（Makefile依存） | ○ |
| C-09 | バッチ種別はユーティリティ | E-02 | ○ |
| C-10 | 実行トリガーは手動 | E-01（対話的使用パターン） | ○ |
| C-11 | ビルド成果物はtargetディレクトリに出力 | **根拠なし** | △ |
| C-12 | 複数同時実行は非推奨 | E-01（ロック機構なし） | ○ |

## 4) 不足情報（Unknown / Missing）
- ビルド成果物の出力先ディレクトリ構造
  - 候補：Makefile / レシピ構造ドキュメント / 他スクリプトの参照

## 5) リスクフラグ（レビュー観点）
- 0: makeターゲット形式の解釈は正確
- 0: 引数処理のロジックは単純で明確
- 1: アクション種別の全リストは推測を含む

## 6) レビュアーチェックリスト（最小）
- [ ] Makefileで--category-プレフィックスのターゲットが定義されているか確認
- [ ] アクション種別（f, r, c, u, p）が実際に利用可能か確認
- [ ] カテゴリディレクトリの実際の構造を確認
