---
generated_at: 2026-01-22 23:51:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：12-check-ci-config.sh

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **fstoolsの内部構成**：list_recipesとredox_installerの詳細
  2. **連想配列の要件**：bash 4.0以上の要件確認
  3. **CI構成ファイルのパス**：実際のディレクトリ構造確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scripts/check-ci-config.sh` - ソースコード（行1-37）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧（行13）
- E-03: スクリプト内の構成ファイルパス `config/${ARCH}/ci.toml`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CI構成ファイル内の不足パッケージをチェック | E-01, E-02 | ○ |
| C-02 | デフォルトアーキテクチャはx86_64 | E-01（行5-10） | ○ |
| C-03 | make build/fstoolsでツールをビルド | E-01（行12） | ○ |
| C-04 | list_recipesで全レシピを取得 | E-01（行15） | ○ |
| C-05 | wip/ディレクトリを除外 | E-01（行15、grep -v） | ○ |
| C-06 | 連想配列packagesにレシピ情報を格納 | E-01（行14-19） | ○ |
| C-07 | redox_installer --list-packagesでCI登録パッケージ取得 | E-01（行22） | ○ |
| C-08 | config/{ARCH}/ci.tomlを参照 | E-01（行21） | ○ |
| C-09 | set -eでエラー時に即終了 | E-01（行3） | ○ |
| C-10 | 32文字幅でフォーマット出力 | E-01（行28, 34） | ○ |
| C-11 | 結果はソートして出力 | E-01（行36） | ○ |
| C-12 | bash 4.0以上が必要 | E-01（declare -A使用） | ○ |
| C-13 | 読み取り専用で状態変更なし | E-01（全体構造） | ○ |
| C-14 | list_recipesとredox_installerはRust製ツール | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- fstoolsの内部構造とビルド成果物の詳細
  - 候補：build/fstoolsのMakefile / fstoolsのソースコード

## 5) リスクフラグ（レビュー観点）
- 0: 処理フローは明確でソースコードから確認可能
- 0: 入出力仕様はスクリプトから直接読み取れる
- 1: fstoolsの詳細な構成は未確認

## 6) レビュアーチェックリスト（最小）
- [ ] config/{ARCH}/ci.tomlが実際に存在するか確認
- [ ] build/fstools/bin/list_recipesの動作を確認
- [ ] build/fstools/bin/redox_installerの--list-packagesオプションを確認
- [ ] bashバージョン要件がドキュメント化されているか確認
