---
generated_at: 2026-01-22 23:53:00
metrics:
  claims_total: 13
  claims_with_evidence: 11
  claims_without_evidence: 2
confidence_derived: 0.85
---

# 根拠レポート：14-find-recipe.sh

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.85**
  - 根拠あり：11 / 13、根拠なし：2
- 優先レビュー（高）
  1. **スクリプトの目的とバッチ一覧の不一致**：要確認
  2. **想定処理時間**：実測データなし
  3. **stageディレクトリのパス構造**：実際のディレクトリ確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scripts/find-recipe.sh` - ソースコード（行1-45）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧（行15）
- E-03: スクリプト内コメント「This script show all files installed by a recipe」

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | イメージ内ファイルの提供元パッケージを特定 | E-01, E-03 | ○ |
| C-02 | ARCH=$(uname -m)でアーキテクチャ取得 | E-01（行6） | ○ |
| C-03 | CONFIG_NAME=desktopがデフォルト | E-01（行7） | ○ |
| C-04 | make unmountを最初に実行（エラー無視） | E-01（行10） | ○ |
| C-05 | make mountでイメージをマウント | E-01（行13） | ○ |
| C-06 | findでbuildディレクトリ内のファイルを列挙 | E-01（行16） | ○ |
| C-07 | cut -d / -f5-でパスの先頭部分を除去 | E-01（行16） | ○ |
| C-08 | recipes配下のstageディレクトリでパッケージ検索 | E-01（行28-34） | ○ |
| C-09 | パッケージ未発見時は設定ファイル参照を案内 | E-01（行39） | ○ |
| C-10 | 処理終了時にmake unmountを実行 | E-01（行44） | ○ |
| C-11 | バッチ一覧の説明とソースコードの機能が異なる | E-01, E-02 | ○ |
| C-12 | 想定処理時間は数分〜数十分 | **根拠なし** | △ |
| C-13 | イメージ内のファイル数は数千〜数万 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 実際のイメージファイル数と処理時間の実測データ
  - 候補：テスト実行結果 / ベンチマークデータ
- バッチ一覧.csvの説明「レシピ名からレシピディレクトリを検索」との不整合
  - 候補：バッチ一覧の更新 / 別スクリプトの確認

## 5) リスクフラグ（レビュー観点）
- 2: バッチ一覧の説明とソースコードの機能が不一致（高リスク）
- 1: パフォーマンス要件は推測に基づく
- 0: 処理ロジック自体は明確

## 6) レビュアーチェックリスト（最小）
- [ ] バッチ一覧.csvの説明を確認し、必要に応じて修正
- [ ] 実際にスクリプトを実行して動作確認
- [ ] stageディレクトリのパス構造を確認
- [ ] 処理時間の実測値を確認
