---
generated_at: 2026-01-22 23:54:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：15-include-recipes.sh

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  1. なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scripts/include-recipes.sh` - ソースコード（行1-27）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧（行16）
- E-03: スクリプト内コメント「This script create a list with... For quick testing of WIP recipes」

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 指定パターンにマッチするレシピをファイルシステム構成形式で出力 | E-01, E-02, E-03 | ○ |
| C-02 | 引数が空の場合はUsageを表示してexit 1 | E-01（行10-17） | ○ |
| C-03 | cookbook_recipes変数に"recipes"を設定 | E-01（行19） | ○ |
| C-04 | grep -rlでrecipe.tomlファイルを検索 | E-01（行20） | ○ |
| C-05 | dirnameでレシピディレクトリを取得 | E-01（行24） | ○ |
| C-06 | basenameでレシピ名を抽出 | E-01（行25） | ○ |
| C-07 | 出力形式は「レシピ名 = {}    # マッチ行」 | E-01（行26） | ○ |
| C-08 | WIPレシピの迅速なテスト用途 | E-03 | ○ |
| C-09 | redoxディレクトリからの実行が必要 | E-01（行14） | ○ |
| C-10 | 使用例：TODO.*errorパターン | E-01（行15） | ○ |
| C-11 | recipe.tomlのみが検索対象 | E-01（行20、--include recipe.toml） | ○ |
| C-12 | 読み取り専用で状態変更なし | E-01（全体構造） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 全ての主張がソースコードから直接確認可能
- 0: 処理ロジックは単純で明確
- 0: 出力形式も明示されている

## 6) レビュアーチェックリスト（最小）
- [ ] 実際にパターンを指定して出力形式を確認
- [ ] 生成された出力がtomlファイルとして有効か確認
- [ ] recipe.toml以外のファイル（recipe.shなど）が検索対象外であることを確認
