---
generated_at: 2026-01-22 23:55:00
metrics:
  claims_total: 13
  claims_with_evidence: 12
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：16-pkg-size.sh

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：12 / 13、根拠なし：1
- 優先レビュー（高）
  1. **ライブラリリンクサイズポリシーの詳細**：具体的なポリシー内容要確認
  2. **pkgar形式の詳細仕様**：Redox固有形式の詳細

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scripts/pkg-size.sh` - ソースコード（行1-30）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧（行17）
- E-03: スクリプト内コメント「This script show the package size of the recipes... It must be used by package maintainers to enforce the library linking size policy」

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | レシピのパッケージサイズを表示 | E-01, E-02, E-03 | ○ |
| C-02 | 対象はstage.pkgarとstage.tar.gz | E-01（行8, 27） | ○ |
| C-03 | 引数なしで全レシピのパッケージを表示 | E-01（行6-9） | ○ |
| C-04 | -h/--helpでヘルプ表示 | E-01（行14-19） | ○ |
| C-05 | 指定レシピモードでループ処理 | E-01（行12-29） | ○ |
| C-06 | find recipes -name $recipeでパス検索 | E-01（行22） | ○ |
| C-07 | recipe.tomlまたはrecipe.shの存在確認 | E-01（行25） | ○ |
| C-08 | ls -hsでサイズを表示 | E-01（行8, 27） | ○ |
| C-09 | ライブラリリンクサイズポリシーの確認用途 | E-03 | ○ |
| C-10 | 読み取り専用で状態変更なし | E-01（全体構造） | ○ |
| C-11 | パッケージなし時はスキップ | E-01（findが見つからなければ出力なし） | ○ |
| C-12 | ヘルプ表示時はexit 0 | E-01（行19） | ○ |
| C-13 | ライブラリリンクサイズポリシーの具体的内容 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- ライブラリリンクサイズポリシーの具体的な内容と閾値
  - 候補：Redoxドキュメント / CONTRIBUTING.md / パッケージングガイド

## 5) リスクフラグ（レビュー観点）
- 0: 処理ロジックは明確でソースコードから確認可能
- 0: 入出力仕様は単純
- 1: サイズポリシーの具体的基準は未確認

## 6) レビュアーチェックリスト（最小）
- [ ] stage.pkgar形式の仕様を確認
- [ ] ライブラリリンクサイズポリシーのドキュメントを確認
- [ ] 引数なしモードと指定レシピモードの両方で動作確認
