---
generated_at: 2026-01-22 23:56:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：17-show-package.sh

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **sysrootディレクトリの役割**：詳細仕様の確認推奨
  2. **find_recipeツールの出力形式**：実際の動作確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scripts/show-package.sh` - ソースコード（行1-27）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧（行18）
- E-03: スクリプト内コメント「This script show the contents of the stage and sysroot folders in some recipe」

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | stageとsysrootフォルダの内容を表示 | E-01, E-02, E-03 | ○ |
| C-02 | 引数なしでUsageを表示してexit 1 | E-01（行5-12） | ○ |
| C-03 | find_recipe変数にtarget/release/find_recipeを設定 | E-01（行14） | ○ |
| C-04 | find_recipeが実行可能でない場合エラー表示 | E-01（行15-19） | ○ |
| C-05 | make fstoolsの案内を表示 | E-01（行18） | ○ |
| C-06 | レシピごとにループ処理 | E-01（行22-26） | ○ |
| C-07 | find_recipeでレシピディレクトリを取得 | E-01（行24） | ○ |
| C-08 | ls -1でstage/sysroot内容を表示 | E-01（行25） | ○ |
| C-09 | redoxディレクトリからの実行が必要 | E-01（行9） | ○ |
| C-10 | 使用例：kernel | E-01（行10） | ○ |
| C-11 | ワイルドカードで複数ターゲット対応 | E-01（行25、`*`使用） | ○ |
| C-12 | 読み取り専用で状態変更なし | E-01（全体構造） | ○ |
| C-13 | 複数レシピ指定可能（$*使用） | E-01（行22、$*） | ○ |
| C-14 | sysrootにはビルド時依存ファイル格納 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- stageとsysrootディレクトリの詳細な役割と内容
  - 候補：Cookbookドキュメント / ビルドシステム設計書

## 5) リスクフラグ（レビュー観点）
- 0: 処理ロジックは明確でソースコードから確認可能
- 0: エラー処理が適切に実装されている
- 1: ディレクトリ構造の詳細は推測を含む

## 6) レビュアーチェックリスト（最小）
- [ ] target/release/find_recipeの存在を確認
- [ ] 任意のレシピでstage/sysrootディレクトリ構造を確認
- [ ] make fstoolsでfind_recipeがビルドされることを確認
