---
generated_at: 2026-01-22 23:58:00
metrics:
  claims_total: 12
  claims_with_evidence: 11
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：19-recipe-match.sh

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：11 / 12、根拠なし：1
- 優先レビュー（高）
  1. **引数チェックの不在**：引数なし実行時の挙動確認
  2. **依存ツールの要件**：rg、batのバージョン要件

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scripts/recipe-match.sh` - ソースコード（行1-6）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧（行20）
- E-03: スクリプト内コメント「This script print the recipe configuration files with determined text」

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 指定テキストを含むレシピ構成ファイルを表示 | E-01, E-02, E-03 | ○ |
| C-02 | ripgrep（rg）で検索を実行 | E-01（行5） | ○ |
| C-03 | -liオプションでファイル名のみ・大文字小文字無視 | E-01（行5） | ○ |
| C-04 | --sort=pathでパスソート | E-01（行5） | ○ |
| C-05 | 検索対象はrecipesディレクトリ | E-01（行5） | ○ |
| C-06 | batで構文ハイライト表示 | E-01（行5） | ○ |
| C-07 | --decorations=alwaysで装飾表示 | E-01（行5） | ○ |
| C-08 | 読み取り専用で状態変更なし | E-01（全体構造） | ○ |
| C-09 | 1行のコマンドパイプラインで構成 | E-01（行5） | ○ |
| C-10 | 引数チェックがない | E-01（全体構造） | ○ |
| C-11 | ripgrepとbatのインストールが前提 | E-01（コマンド使用） | ○ |
| C-12 | 処理時間は数秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 処理時間の実測データ
  - 候補：実行ベンチマーク / レシピ数に応じた性能測定
- 引数なし実行時の具体的なエラーメッセージ
  - 候補：実際の実行テスト

## 5) リスクフラグ（レビュー観点）
- 0: 処理ロジックは非常にシンプルで明確
- 1: 引数チェックがないため、引数なし実行時の挙動が不明確
- 0: 依存ツールの使用方法は標準的

## 6) レビュアーチェックリスト（最小）
- [ ] rgとbatがシステムにインストールされているか確認
- [ ] 引数なしで実行した場合の挙動を確認
- [ ] 実際のパターンで検索結果を確認
