---
generated_at: 2026-01-22 23:52:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：2-native_bootstrap.sh

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠があります

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `native_bootstrap.sh` - ソースコード（全1135行）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧定義
- E-03: `native_bootstrap.sh` usage関数（878-902行目）
- E-04: `native_bootstrap.sh` osx_homebrew関数（164-229行目）
- E-05: `native_bootstrap.sh` osx_macports関数（90-157行目）
- E-06: `native_bootstrap.sh` ubuntu関数（390-520行目）
- E-07: `native_bootstrap.sh` archLinux関数（308-381行目）
- E-08: `native_bootstrap.sh` fedora関数（528-630行目）
- E-09: `native_bootstrap.sh` suse関数（636-762行目）
- E-10: `native_bootstrap.sh` gentoo関数（769-814行目）
- E-11: `native_bootstrap.sh` solus関数（821-873行目）
- E-12: `native_bootstrap.sh` freebsd関数（236-300行目）
- E-13: `native_bootstrap.sh` rustInstall関数（922-975行目）
- E-14: `native_bootstrap.sh` cargoInstall関数（907-914行目）
- E-15: `native_bootstrap.sh` boot関数（1014-1044行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | macOS、Linux各ディストリビューション、FreeBSDに対応 | E-01（1079-1124行目のOS判定ロジック） | ○ |
| C-02 | Rustupをインストール | E-13（rustInstall関数） | ○ |
| C-03 | curl | sh方式でrustupをインストール | E-01（956行目） | ○ |
| C-04 | 依存パッケージをインストール | E-04〜E-12（各OS用関数） | ○ |
| C-05 | エミュレータとしてQEMU/VirtualBoxをサポート | E-04（173-180行目）、E-03 | ○ |
| C-06 | just 1.42.4をインストール | E-14、E-01（1127行目） | ○ |
| C-07 | cbindgen 0.29.0をインストール | E-14、E-01（1128行目） | ○ |
| C-08 | Redoxリポジトリをクローン | E-15（1017行目） | ○ |
| C-09 | .configファイルにPODMAN_BUILD=0を設定 | E-15（1018-1019行目） | ○ |
| C-10 | -hオプションでヘルプ表示 | E-01（1046-1047行目）、E-03 | ○ |
| C-11 | -uオプションでgit pull実行 | E-01（1048-1050行目） | ○ |
| C-12 | -sオプションでTravisビルドステータス確認 | E-01（1051-1053行目） | ○ |
| C-13 | -eオプションでエミュレータ指定 | E-01（1066行目） | ○ |
| C-14 | -pオプションでパッケージマネージャ指定 | E-01（1067行目） | ○ |
| C-15 | -dオプションで依存関係のみインストール | E-01（1068行目、1130-1132行目） | ○ |
| C-16 | -yオプションで非対話モード | E-01（1071行目） | ○ |
| C-17 | multirustのアンインストールを促す | E-13（927-938行目） | ○ |
| C-18 | set -eでエラー時に即終了 | E-01（7行目） | ○ |
| C-19 | Homebrewを検出してosx_homebrew実行 | E-01（73-74行目） | ○ |
| C-20 | MacPortsを検出してosx_macports実行 | E-01（75-76行目） | ○ |
| C-21 | macOSでのネイティブビルドは非推奨 | E-01（1082-1084行目） | ○ |
| C-22 | FreeBSDではgmakeを使用 | E-15（1034-1036行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- すべての主要な主張に対して根拠が確認できました
- 追加の検証が望ましい項目はありません

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認できています

## 6) レビュアーチェックリスト（最小）
- [ ] 各OS用のパッケージリストが最新か確認
- [ ] just/cbindgenのバージョンが最新か確認
- [ ] Travis CI APIがまだ有効か確認
- [ ] Rustupインストールの安全性確認
