---
generated_at: 2026-01-22 23:59:00
metrics:
  claims_total: 11
  claims_with_evidence: 11
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：20-recipe-path.sh

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：11 / 11、根拠なし：0
- 優先レビュー（高）
  1. なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scripts/recipe-path.sh` - ソースコード（行1-9）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧（行21）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | レシピ名からレシピパスを出力 | E-01, E-02 | ○ |
| C-02 | FIND_RECIPE変数にfindコマンドを設定 | E-01（行3） | ○ |
| C-03 | -maxdepth 4で4階層まで検索 | E-01（行3） | ○ |
| C-04 | -nameでディレクトリ名検索 | E-01（行3） | ○ |
| C-05 | $*で複数レシピ指定可能 | E-01（行5） | ○ |
| C-06 | forループで各レシピを処理 | E-01（行5-8） | ○ |
| C-07 | findコマンドによる簡易検索 | E-02 | ○ |
| C-08 | 引数チェックがない | E-01（全体構造） | ○ |
| C-09 | スクリプトは9行で構成 | E-01（全体行数） | ○ |
| C-10 | 読み取り専用で状態変更なし | E-01（全体構造） | ○ |
| C-11 | 検索対象はrecipesディレクトリ | E-01（行3） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 処理ロジックは非常にシンプルで明確
- 0: 全ての主張がソースコードから直接確認可能
- 0: 外部依存は標準のfindコマンドのみ

## 6) レビュアーチェックリスト（最小）
- [ ] recipesディレクトリの実際の階層構造を確認（4階層で十分か）
- [ ] 同名レシピが複数存在する場合の挙動を確認
- [ ] 引数なし実行時の挙動を確認
