---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：21-scripts/print-recipe.sh バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **目標処理時間（1秒以内）**：根拠不足（推測値）
  2. **find_recipeがcookbookリポジトリで定義**：根拠不足（外部リポジトリ未確認）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scripts/print-recipe.sh` - 対象バッチスクリプト本体（5行）
- E-02: `scripts/show-package.sh` - find_recipeの使用例とエラーハンドリング
- E-03: `scripts/recipe-path.sh` - 類似のレシピパス検索スクリプト
- E-04: `scripts/commit-hash.sh` - find_recipeの使用例
- E-05: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチの説明「レシピの構成ファイルを表示」
- E-06: `recipes/core/kernel/recipe.toml` - recipe.toml形式のサンプル
- E-07: `recipes/wip/vice/recipe.sh` - recipe.sh形式のサンプル

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | バッチはレシピ構成ファイルの内容を標準出力に表示する | E-01（catコマンド） | ○ |
| C-02 | find_recipeコマンドでレシピディレクトリパスを取得 | E-01（target/release/find_recipe） | ○ |
| C-03 | recipe.*ワイルドカードでrecipe.tomlとrecipe.sh両対応 | E-01（/recipe.*）, E-06, E-07 | ○ |
| C-04 | find_recipeバイナリはtarget/release/に存在 | E-01, E-02, E-04 | ○ |
| C-05 | make fstoolsでfind_recipeがビルドされる | E-02（行17-19のエラーメッセージ） | ○ |
| C-06 | 入力パラメータはレシピ名（$1） | E-01（"$1"引数） | ○ |
| C-07 | バッチ種別はユーティリティ | E-05（カテゴリ: ユーティリティ） | ○ |
| C-08 | 実行頻度は随時（手動実行） | E-05（説明からの推測） | ○ |
| C-09 | 読み取り専用処理でデータ変更なし | E-01（catのみ） | ○ |
| C-10 | データベース操作なし | E-01（ファイル操作のみ） | ○ |
| C-11 | エラー時catコマンドがエラーを返す | E-01（catの戻り値） | ○ |
| C-12 | リトライ機能なし | E-01（単純なスクリプト） | ○ |
| C-13 | ログ出力機能なし | E-01（echo/logging処理なし） | ○ |
| C-14 | 排他制御不要 | E-01（読み取り専用） | ○ |
| C-15 | recipesディレクトリ配下にレシピが存在 | E-06, E-07（実在確認） | ○ |
| C-16 | 類似スクリプトにrecipe-path.shがある | E-03 | ○ |
| C-17 | 目標処理時間は1秒以内 | **根拠なし** | △ |
| C-18 | find_recipeはcookbookリポジトリで定義 | **根拠なし**（外部リポジトリ） | △ |

## 4) 不足情報（Unknown / Missing）
- **C-17（目標処理時間）**：パフォーマンス要件はソースコードからは読み取れない。1秒以内は単純なcatコマンドであることからの合理的推測だが、実測値や要件定義書からの根拠はない。
  - 候補：実行時間の実測 / パフォーマンス要件定義書 / 開発者への確認
- **C-18（find_recipeの定義場所）**：本リポジトリ内にfind_recipeのソースコードは見つからなかった。cookbook外部リポジトリで定義されている可能性が高いが、未確認。
  - 候補：cookbook リポジトリの調査 / Makefile の fstools ターゲット確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 本バッチは5行の非常にシンプルなスクリプトであり、実装誤りのリスクは極めて低い
- 0: 低リスク - 読み取り専用処理のため、データ破損リスクなし
- 1: 中リスク - find_recipeバイナリへの依存があり、ビルドツールが未構築の場合は動作しない

## 6) レビュアーチェックリスト（最小）
- [ ] find_recipeの動作確認（`make fstools`後に実行可能か）
- [ ] 実際のレシピ名で動作確認（例: `./scripts/print-recipe.sh kernel`）
- [ ] 存在しないレシピ名を指定した場合のエラー挙動確認
- [ ] recipe.toml形式とrecipe.sh形式の両方で表示確認
