---
generated_at: 2026-01-22 23:54:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：3-podman_bootstrap.sh

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠があります

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `podman_bootstrap.sh` - ソースコード（全664行）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧定義
- E-03: `podman_bootstrap.sh` usage関数（475-494行目）
- E-04: `podman_bootstrap.sh` osx_homebrew関数（121-142行目）
- E-05: `podman_bootstrap.sh` osx_macports関数（93-114行目）
- E-06: `podman_bootstrap.sh` ubuntu関数（206-243行目）
- E-07: `podman_bootstrap.sh` archLinux関数（178-199行目）
- E-08: `podman_bootstrap.sh` fedora関数（250-287行目）
- E-09: `podman_bootstrap.sh` suse関数（294-383行目）
- E-10: `podman_bootstrap.sh` gentoo関数（390-432行目）
- E-11: `podman_bootstrap.sh` solus関数（439-470行目）
- E-12: `podman_bootstrap.sh` freebsd関数（149-171行目）
- E-13: `podman_bootstrap.sh` rustInstall関数（502-554行目）
- E-14: `podman_bootstrap.sh` boot関数（560-593行目）
- E-15: `podman_bootstrap.sh` banner関数（12-18行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | macOS、Linux各ディストリビューション、FreeBSDに対応 | E-01（627-657行目のOS判定ロジック） | ○ |
| C-02 | Podman関連パッケージをインストール | E-04〜E-12（各OS用関数でpodmanをインストール） | ○ |
| C-03 | PODMAN_BUILD=1を.configに設定 | E-14（564-565行目） | ○ |
| C-04 | ARM64でARCH=aarch64を追加設定 | E-14（566-569行目） | ○ |
| C-05 | エミュレータとしてQEMU/VirtualBoxをサポート | E-04（134-141行目）、E-03 | ○ |
| C-06 | Redoxリポジトリをクローン | E-14（562-563行目） | ○ |
| C-07 | -hオプションでヘルプ表示 | E-01（595-596行目）、E-03 | ○ |
| C-08 | -uオプションでgit pull実行 | E-01（597-599行目、622-625行目） | ○ |
| C-09 | -eオプションでエミュレータ指定 | E-01（609行目） | ○ |
| C-10 | -pオプションでパッケージマネージャ指定 | E-01（610行目） | ○ |
| C-11 | -dオプションで依存関係のみインストール | E-01（611行目、659-661行目） | ○ |
| C-12 | set -eでエラー時に即終了 | E-01（7行目） | ○ |
| C-13 | fuse3/fuse-overlayfs/slirp4netnsをインストール | E-07（181行目）、E-06（213-214行目） | ○ |
| C-14 | Gentooでpodmanが見つからない場合エラー | E-10（428-431行目） | ○ |
| C-15 | Solusでpodmanが見つからない場合エラー | E-11（466-469行目） | ○ |
| C-16 | GDBをインストール | E-04（132行目）、E-05（104行目） | ○ |
| C-17 | REPO_BINARY=1オプションの案内 | E-14（577-578行目） | ○ |
| C-18 | FreeBSDでgmakeを使用 | E-14（583-586行目） | ○ |
| C-19 | native_bootstrap.shより少ないパッケージ | E-04〜E-12（各関数のパッケージリスト比較） | ○ |
| C-20 | curl | sh方式でrustupをインストール | E-13（536行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- すべての主要な主張に対して根拠が確認できました
- 追加の検証が望ましい項目はありません

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認できています

## 6) レビュアーチェックリスト（最小）
- [ ] 各OS用のパッケージリストにpodman関連パッケージが含まれているか確認
- [ ] ARM64環境でARCH=aarch64が正しく設定されるか確認
- [ ] GentooとSolusでPodmanインストールのガイダンスが適切か確認
- [ ] REPO_BINARY=1オプションの効果が明記されているか確認
