---
generated_at: 2026-01-22 23:56:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：4-rustinstall.sh

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠があります

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `podman/rustinstall.sh` - ソースコード（全22行）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Rustupでstable版Rustをインストール | E-01（7行目：--default-toolchain stable） | ○ |
| C-02 | 非対話モード（-y）でインストール | E-01（7行目：-y） | ○ |
| C-03 | 最小プロファイル（--profile minimal）を使用 | E-01（7行目：--profile minimal） | ○ |
| C-04 | sccache v0.10.0をインストール | E-01（10行目：v0.10.0） | ○ |
| C-05 | just 1.45.0をインストール | E-01（14行目：1.45.0） | ○ |
| C-06 | cbindgen 0.29.0をインストール | E-01（18-19行目：0.29.0） | ○ |
| C-07 | sccacheはGitHubリリースからダウンロード | E-01（10行目：github.com/mozilla/sccache/releases） | ○ |
| C-08 | justはGitHubリリースからダウンロード | E-01（14行目：github.com/casey/just/releases） | ○ |
| C-09 | cbindgenはGitHubリリースからダウンロード | E-01（19行目：github.com/mozilla/cbindgen/releases） | ○ |
| C-10 | uname -mでアーキテクチャを判定 | E-01（10行目、14行目、18行目：$(uname -m)） | ○ |
| C-11 | sccacheはtar.gz形式でダウンロード | E-01（11行目：tar -xz） | ○ |
| C-12 | justはtar.gz形式でダウンロード | E-01（15行目：tar -xz） | ○ |
| C-13 | cbindgenはx86_64とaarch64で異なるバイナリ | E-01（18行目：ubuntu22.04 / ubuntu22.04-aarch64） | ○ |
| C-14 | cbindgenに実行権限を付与 | E-01（21行目：chmod +x） | ○ |
| C-15 | ~/.cargo/binにインストール | E-01（11行目、15行目、20行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- すべての主要な主張に対して根拠が確認できました
- 追加の検証が望ましい項目はありません

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認できています

## 6) レビュアーチェックリスト（最小）
- [ ] sccache/just/cbindgenのバージョンが最新か確認
- [ ] GitHubリリースURLが有効か確認
- [ ] アーキテクチャ判定ロジックが正しいか確認
- [ ] tar展開のパス指定が正しいか確認
