---
generated_at: 2026-01-23 00:00:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：6-executables.sh

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠があります

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scripts/executables.sh` - ソースコード（全61行）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | デフォルトアーキテクチャはx86_64-unknown-redox | E-01（16行目） | ○ |
| C-02 | -arm64でaarch64-unknown-redox | E-01（21-23行目） | ○ |
| C-03 | -i686でi686-unknown-redox | E-01（24-26行目） | ○ |
| C-04 | -aで全件表示（uniq=cat） | E-01（27-29行目） | ○ |
| C-05 | -hでusage表示 | E-01（30-32行目）、E-01（5-12行目） | ○ |
| C-06 | デフォルトはuniq -D --skip-fields=1で重複のみ表示 | E-01（17行目） | ○ |
| C-07 | レシピ未指定時はlist_recipesで全レシピ取得 | E-01（38-41行目） | ○ |
| C-08 | レシピがパス形式（/含む）の場合recipes/パスを使用 | E-01（45-48行目） | ○ |
| C-09 | レシピ名のみの場合find_recipeでパス取得 | E-01（49-52行目） | ○ |
| C-10 | stage/usr/binを検索 | E-01（54行目） | ○ |
| C-11 | stage/binを検索 | E-01（55行目） | ○ |
| C-12 | 出力形式は"recipe_path shortname" | E-01（58行目） | ○ |
| C-13 | sortでソート | E-01（60行目） | ○ |
| C-14 | find 2> /dev/nullでエラー無視 | E-01（54-55行目） | ○ |
| C-15 | basenameで実行ファイル名抽出 | E-01（57行目） | ○ |
| C-16 | target/ARCH/stageディレクトリを検索 | E-01（54-55行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- すべての主要な主張に対して根拠が確認できました
- 追加の検証が望ましい項目はありません

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認できています

## 6) レビュアーチェックリスト（最小）
- [ ] uniq -D --skip-fields=1の動作が想定通りか確認
- [ ] list_recipesとfind_recipeがビルドされているか確認
- [ ] stageディレクトリの構造が正しいか確認
- [ ] アーキテクチャ指定オプションが正しく動作するか確認
