---
generated_at: 2026-01-23 00:06:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：9-backtrace.sh

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠があります

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scripts/backtrace.sh` - ソースコード（全79行）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | デフォルトアーキテクチャはx86_64 | E-01（26行目：ARCH="x86_64"） | ○ |
| C-02 | -rオプションでレシピ名指定 | E-01（37行目） | ○ |
| C-03 | -eオプションで実行ファイル名指定 | E-01（35行目） | ○ |
| C-04 | -Xでx86_64アーキテクチャ | E-01（31行目） | ○ |
| C-05 | -Aでaarch64アーキテクチャ | E-01（32行目） | ○ |
| C-06 | -6でi686アーキテクチャ | E-01（33行目） | ○ |
| C-07 | -bでバックトレースファイル指定 | E-01（34行目） | ○ |
| C-08 | -Rでrelease版強制 | E-01（38行目） | ○ |
| C-09 | -rが必須 | E-01（46-49行目） | ○ |
| C-10 | -bまたはアドレスが必要 | E-01（51-54行目） | ○ |
| C-11 | find_recipeでレシピパス取得 | E-01（57行目） | ○ |
| C-12 | -e指定なければレシピ名を実行ファイル名に | E-01（58-61行目） | ○ |
| C-13 | debug版を優先使用 | E-01（64行目） | ○ |
| C-14 | debug版がないか-R指定でrelease版使用 | E-01（67-70行目） | ○ |
| C-15 | addr2line --demangle=rust | E-01（74行目、76行目） | ○ |
| C-16 | addr2line --inlines --pretty-print --functions | E-01（74行目、76行目） | ○ |
| C-17 | sedでアドレス抽出 | E-01（76行目） | ○ |
| C-18 | 実行ファイルパス構造 | E-01（64行目、69行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- すべての主要な主張に対して根拠が確認できました
- 追加の検証が望ましい項目はありません

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認できています

## 6) レビュアーチェックリスト（最小）
- [ ] addr2lineコマンドがシステムに存在するか確認
- [ ] デバッグビルドの実行ファイルパスが正しいか確認
- [ ] sedのアドレス抽出パターンが正しいか確認
- [ ] Rustシンボルのデマングルが正しく動作するか確認
