---
generated_at: 2026-01-23 10:30:00
metrics:
  claims_total: 80
  claims_with_evidence: 76
  claims_without_evidence: 4
confidence_derived: 0.95
---

# 根拠レポート：src-bin 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：76 / 80、根拠なし：4
- 優先レビュー（高）
  1. **C-74 (repo.toml生成)**: 外部ライブラリ依存のため実際の出力形式要確認
  2. **C-76 (AppStream生成)**: appstreamcli外部コマンドの動作検証が必要
  3. **C-39 (TuiApp初期化)**: 依存関係の初期化順序について追加検証推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/bin/repo.rs` - repoコマンドのメインバイナリ（1785行）
- E-02: `src/bin/repo_builder.rs` - リポジトリビルダーバイナリ（277行）
- E-03: `src/bin/cookbook_redoxer.rs` - cookbook_redoxerラッパーバイナリ（19行）
- E-04: `docs/code-to-docs/単体テストケース一覧/plan.md` - テスト計画書

## 3) Claims と根拠の対応（レビューの主戦場）

### CliCommand関連（repo.rs）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | fetchコマンドが正しくパースされること | E-01 (119-121行) | ○ |
| C-02 | cookコマンドが正しくパースされること | E-01 (122行) | ○ |
| C-03 | unfetchコマンドが正しくパースされること | E-01 (123行) | ○ |
| C-04 | cleanコマンドが正しくパースされること | E-01 (124行) | ○ |
| C-05 | pushコマンドが正しくパースされること | E-01 (125行) | ○ |
| C-06 | treeコマンドが正しくパースされること | E-01 (126行) | ○ |
| C-07 | findコマンドが正しくパースされること | E-01 (127行) | ○ |
| C-08 | 不明なコマンドでエラーが返却されること | E-01 (128行) | ○ |
| C-09 | 空文字列でエラーが返却されること | E-01 (128行) | ○ |
| C-10 | Treeコマンドでis_informational=true | E-01 (102-104行) | ○ |
| C-11 | Findコマンドでis_informational=true | E-01 (103行) | ○ |
| C-12 | Cookコマンドでis_informational=false | E-01 (102-104行) | ○ |
| C-13 | Fetchコマンドでis_building=true | E-01 (105-107行) | ○ |
| C-14 | Cookコマンドでis_building=true | E-01 (106行) | ○ |
| C-15 | Cleanコマンドでis_building=false | E-01 (105-107行) | ○ |
| C-16 | Pushコマンドでis_pushing=true | E-01 (108-110行) | ○ |
| C-17 | Treeコマンドでis_pushing=true | E-01 (109行) | ○ |
| C-18 | Fetchコマンドでis_pushing=false | E-01 (108-110行) | ○ |
| C-19 | Cleanコマンドでis_cleaning=true | E-01 (111-113行) | ○ |
| C-20 | Unfetchコマンドでis_cleaning=true | E-01 (112行) | ○ |
| C-21 | Cookコマンドでis_cleaning=false | E-01 (111-113行) | ○ |
| C-22 | 各コマンドが正しい文字列に変換される | E-01 (134-144行) | ○ |

### CliConfig関連（repo.rs）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-23 | デフォルト設定が正しく初期化される | E-01 (148-172行) | ○ |
| C-24 | Redox OSでsysroot_dir="/" | E-01 (161-165行) | ○ |
| C-25 | 非Redox OSでsysroot_dir=current_dir/sysroot | E-01 (164行) | ○ |

### parse_args関連（repo.rs）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-26 | --cookbook=でcookbook_dirが設定される | E-01 (382行) | ○ |
| C-27 | --repo=でrepo_dirが設定される | E-01 (383行) | ○ |
| C-28 | --sysroot=でsysroot_dirが設定される | E-01 (384行) | ○ |
| C-29 | --allフラグでallがtrueになる | E-01 (404行) | ○ |
| C-30 | --with-package-depsフラグが正しく設定される | E-01 (403行) | ○ |
| C-31 | 不明なフラグでプロセス終了する | E-01 (405-408行, 415-417行) | ○ |
| C-32 | コマンドなしでエラーが返却される | E-01 (441行) | ○ |
| C-33 | --allと--categoryの同時指定でエラー | E-01 (447-449行) | ○ |
| C-34 | --allとレシピ名の同時指定でエラー | E-01 (444-446行) | ○ |

### handle_clean関連（repo.rs）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-35 | targetディレクトリが削除される | E-01 (619-628行) | ○ |
| C-36 | sourceディレクトリが削除される | E-01 (629-633行) | ○ |
| C-37 | 存在しないディレクトリでもエラーにならない | E-01 (626行: if dir.exists()) | ○ |
| C-38 | handle_nonstop_failでstageディレクトリが削除される | E-01 (609-617行) | ○ |

### TuiApp関連（repo.rs）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-39 | TuiApp::newで正しく初期化される | E-01 (839-869行) | ○ |
| C-40 | 空のレシピリストで初期化される | E-01 (839-869行) | ○ |
| C-41 | Cook時にactive_cookが返却される | E-01 (871-877行) | ○ |
| C-42 | Fetch時にactive_fetchが返却される | E-01 (875-876行) | ○ |
| C-43 | get_recipe_logでログが取得できる | E-01 (897-907行) | ○ |
| C-44 | 存在しないレシピでNoneが返却される | E-01 (900-901行) | ○ |
| C-45 | write_logでログファイルが書き込まれる | E-01 (909-918行) | ○ |
| C-46 | 空のログは書き込まれない | E-01 (914-916行) | ○ |
| C-47 | StartFetchでステータスがFetchingに変わる | E-01 (923-930行) | ○ |
| C-48 | FetchedでステータスがFetchedに変わる | E-01 (931行) | ○ |
| C-49 | StartCookでステータスがCookingに変わる | E-01 (936-940行) | ○ |
| C-50 | CookedでステータスがDoneに変わる | E-01 (964-970行) | ○ |
| C-51 | FailFetchでステータスがFailedに変わる | E-01 (932-935行) | ○ |
| C-52 | FailCookでステータスがFailedに変わる | E-01 (971-974行) | ○ |
| C-53 | PushLogでログが追加される | E-01 (941-956行) | ○ |
| C-54 | FetchThreadFinishedでfetch_complete=true | E-01 (975-978行) | ○ |
| C-55 | CookThreadFinishedでcook_complete=true | E-01 (979-982行) | ○ |

### FailurePrompt関連（repo.rs）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-56 | FailurePrompt::newで正しく初期化される | E-01 (1760-1767行) | ○ |
| C-57 | nextでRetry->Skip->Exit->Retry順に遷移 | E-01 (1769-1775行) | ○ |
| C-58 | prevでRetry->Exit->Skip->Retry順に遷移 | E-01 (1777-1784行) | ○ |

### ユーティリティ関数（repo.rs）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-59 | handle_crで末尾\rから最後の文字列が返る | E-01 (1512-1515行) | ○ |
| C-60 | \rがない場合は元の文字列が返る | E-01 (1514行) | ○ |
| C-61 | join_logsでログが改行で結合される | E-01 (1503-1510行) | ○ |
| C-62 | join_logsで現在行が追加される | E-01 (1505-1508行) | ○ |

### repo_builder.rs関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-63 | is_newerでsrcが新しい場合true | E-02 (16-26行) | ○ |
| C-64 | is_newerでdstが新しい場合false | E-02 (19行) | ○ |
| C-65 | srcのみ存在する場合true | E-02 (23行) | ○ |
| C-66 | 両方存在しない場合false | E-02 (24行) | ○ |
| C-67 | CliConfig::parse_argsでrepo_dirがパースされる | E-02 (36-47行) | ○ |
| C-68 | recipe_listが正しくパースされる | E-02 (44行) | ○ |
| C-69 | COOKBOOK_APPSTREAMでappstream=true | E-02 (43行) | ○ |
| C-70 | COOKBOOK_APPSTREAM未設定でappstream=false | E-02 (43行) | ○ |
| C-71 | パッケージがrepoに公開される | E-02 (120-126行) | ○ |
| C-72 | 空のレシピリストで何もしない | E-02 (70-72行) | ○ |
| C-73 | ホストパッケージがスキップされる | E-02 (63-68行) | ○ |
| C-74 | repo.tomlが生成される | E-02 (217-274行) | △ |
| C-75 | outdated_packagesが記録される | E-02 (176-215行) | ○ |
| C-76 | appstreamデータが生成される | E-02 (135-174行) | △ |

### cookbook_redoxer.rs関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-77 | 引数が正しく処理される | E-03 (6-7行) | ○ |
| C-78 | write-execでCOOKBOOK_STAGEが挿入される | E-03 (8-15行) | ○ |
| C-79 | 引数が1つ以下の場合何もしない | E-03 (6行: if args.len() >= 2) | △ |
| C-80 | COOKBOOK_STAGE未設定時は通常処理される | E-03 (9行: if let Ok) | △ |

## 4) 不足情報（Unknown / Missing）
- **C-74**: tomlシリアライズの出力形式がRepositoryの実装に依存。pkg::package::Repositoryの定義を確認推奨
- **C-76**: appstreamcliの外部コマンド実行結果は実行環境に依存
- **C-79, C-80**: cookbook_redoxer.rsは非常に小さいファイルで、redoxerライブラリへの委譲が主。redoxer::mainの内部動作は外部依存

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: C-01〜C-22, C-35〜C-38, C-56〜C-62（シンプルなロジック、明確な根拠あり）
- **1 (中リスク)**: C-23〜C-34, C-39〜C-55, C-63〜C-73, C-77〜C-78（複雑なロジックだが根拠あり）
- **2 (高リスク)**: C-74, C-76, C-79, C-80（外部依存または根拠不足）

## 6) レビュアーチェックリスト（最小）
- [ ] CliCommandのfrom_str/to_stringの整合性を確認（C-01〜C-22）
- [ ] CliConfigの初期化値がREPO_HELP_STRの説明と一致しているか確認（C-23〜C-25）
- [ ] parse_argsのエラーハンドリングが適切か確認（C-31〜C-34）
- [ ] TuiAppの状態遷移が期待通りか確認（C-47〜C-55）
- [ ] repo_builder::publish_packagesの外部依存処理を実環境でテスト（C-74, C-76）
- [ ] cookbook_redoxerのredoxer::main委譲が正しいか確認（C-77〜C-80）
