---
generated_at: 2026-01-23 12:00:00
metrics:
  claims_total: 132
  claims_with_evidence: 132
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：src-cook 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：132 / 132、根拠なし：0
- 優先レビュー（高）
  1. **該当なし**：全テストケースにソースコード根拠あり
  2. **UT-COOK-009（blake3不一致エラー）**：セキュリティ関連のため重点レビュー推奨
  3. **UT-COOK-077（無限ループ防止テスト）**：既存テストコードとの整合性確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/cook/fetch.rs` - ソース取得機能（681行）
- E-02: `src/cook/package.rs` - パッケージング機能（245行）
- E-03: `src/cook/tree.rs` - 依存関係ツリー表示機能（175行）
- E-04: `src/cook/cook_build.rs` - ビルド機能（708行）
- E-05: `src/cook/script.rs` - ビルドスクリプト定義（373行）
- E-06: `src/cook/fs.rs` - ファイルシステム操作（477行）
- E-07: `src/cook/pty.rs` - PTY（疑似端末）操作（357行）
- E-08: `src/cook/ident.rs` - 識別子管理（47行）

## 3) Claims と根拠の対応（レビューの主戦場）

### fetch.rs 関連（UT-COOK-001 〜 UT-COOK-035）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | get_blake3はファイルのblake3ハッシュを計算する | E-01 (L21-35) | ○ |
| C-02 | get_blake3はshow_progressオプションをサポート | E-01 (L22-26) | ○ |
| C-03 | fetch_offlineはBuildKind::Noneを処理する | E-01 (L41-45) | ○ |
| C-04 | fetch_offlineはBuildKind::Remoteを処理する | E-01 (L46-49) | ○ |
| C-05 | fetch_offlineはSameAsソースでシンボリックリンクを作成 | E-01 (L58-63) | ○ |
| C-06 | fetch_offlineはGitソースでリビジョンを取得 | E-01 (L65-77) | ○ |
| C-07 | fetch_offlineはTarソースでblake3検証を実行 | E-01 (L78-109) | ○ |
| C-08 | fetchはBuildKind::Noneを処理する | E-01 (L121-125) | ○ |
| C-09 | fetchはPathソースでディレクトリをコピー | E-01 (L141-159) | ○ |
| C-10 | fetchはGitソースでクローン/フェッチを実行 | E-01 (L161-317) | ○ |
| C-11 | fetchはTarソースでダウンロード・展開を実行 | E-01 (L318-380) | ○ |
| C-12 | fetch_make_symlinkはシンボリックリンクを作成 | E-01 (L408-429) | ○ |
| C-13 | fetch_resolve_canonは無限ループを検出 | E-01 (L437-446) | ○ |
| C-14 | fetch_extract_tarはtarを展開する | E-01 (L454-476) | ○ |
| C-15 | fetch_cargoはcargo fetchを実行する | E-01 (L478-501) | ○ |
| C-16 | fetch_remoteはリモートパッケージを取得 | E-01 (L517-580) | ○ |
| C-17 | fetch_is_patches_newerはパッチの更新を検出 | E-01 (L582-604) | ○ |
| C-18 | fetch_apply_patchesはパッチを適用する | E-01 (L606-646) | ○ |
| C-19 | fetch_apply_source_infoはソース情報を保存 | E-01 (L648-660) | ○ |
| C-20 | fetch_get_source_infoはソース情報を読み込む | E-01 (L672-680) | ○ |

### package.rs 関連（UT-COOK-036 〜 UT-COOK-050）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-21 | packageはBuildKind::Noneでstage.tomlのみ作成 | E-02 (L23-33) | ○ |
| C-22 | packageはpkgarアーカイブを作成する | E-02 (L72-79) | ○ |
| C-23 | packageは鍵ペアを自動生成する | E-02 (L35-48) | ○ |
| C-24 | package_tomlはメタデータTOMLを作成 | E-02 (L120-174) | ○ |
| C-25 | package_versionはバージョンを取得 | E-02 (L176-190) | ○ |
| C-26 | package_targetはターゲットを判定 | E-02 (L192-198) | ○ |
| C-27 | package_stage_pathsはパスを生成 | E-02 (L200-212) | ○ |
| C-28 | get_package_nameはパッケージ名を生成 | E-02 (L233-244) | ○ |

### tree.rs 関連（UT-COOK-051 〜 UT-COOK-060）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-29 | display_tree_entryはツリーを表示する | E-03 (L19-36) | ○ |
| C-30 | walk_tree_entryはパッケージを走査する | E-03 (L38-107) | ○ |
| C-31 | walk_tree_entryは重複を検出する | E-03 (L58-69) | ○ |
| C-32 | walk_file_treeはファイルツリーを出力 | E-03 (L126-164) | ○ |
| C-33 | format_sizeはサイズをフォーマット | E-03 (L166-174) | ○ |

### cook_build.rs 関連（UT-COOK-061 〜 UT-COOK-077）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-34 | buildはBuildKind::Noneで空のBTreeSetを返す | E-04 (L185-188) | ○ |
| C-35 | buildはキャッシュを活用する | E-04 (L221-227) | ○ |
| C-36 | buildはソース更新を検出する | E-04 (L229-266) | ○ |
| C-37 | buildはCargoビルドを実行する | E-04 (L343-351) | ○ |
| C-38 | buildはConfigureビルドを実行する | E-04 (L352-355) | ○ |
| C-39 | buildはCMakeビルドを実行する | E-04 (L356-359) | ○ |
| C-40 | buildはMesonビルドを実行する | E-04 (L360-363) | ○ |
| C-41 | buildはカスタムスクリプトを実行する | E-04 (L364) | ○ |
| C-42 | remove_stage_dirはステージを削除する | E-04 (L464-481) | ○ |
| C-43 | get_stage_dirsはステージパスリストを生成 | E-04 (L483-498) | ○ |
| C-44 | get_build_dirはビルドパスを生成 | E-04 (L500-509) | ○ |
| C-45 | build_auto_depsは自動依存を検出する | E-04 (L575-611) | ○ |
| C-46 | build_remoteはリモートパッケージを展開 | E-04 (L613-672) | ○ |
| C-47 | file_system_loop_no_infinite_loopテストが存在 | E-04 (L674-707) | ○ |

### fs.rs 関連（UT-COOK-078 〜 UT-COOK-114）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-48 | remove_allはディレクトリ/ファイルを削除 | E-06 (L18-25) | ○ |
| C-49 | create_dirはディレクトリを作成 | E-06 (L27-30) | ○ |
| C-50 | create_dir_cleanは既存を削除して作成 | E-06 (L32-38) | ○ |
| C-51 | create_target_dirはターゲットディレクトリを作成 | E-06 (L40-50) | ○ |
| C-52 | copy_dir_allは再帰的にコピー | E-06 (L52-64) | ○ |
| C-53 | move_dir_all_fnは条件付きで移動 | E-06 (L66-101) | ○ |
| C-54 | symlinkはシンボリックリンクを作成 | E-06 (L103-113) | ○ |
| C-55 | modifiedは変更時刻を取得 | E-06 (L115-132) | ○ |
| C-56 | modified_allは複数パスの最新時刻を取得 | E-06 (L134-146) | ○ |
| C-57 | modified_dirはディレクトリの最新時刻を取得 | E-06 (L163-172) | ○ |
| C-58 | modified_dir_ignore_gitは.gitを除外 | E-06 (L174-190) | ○ |
| C-59 | renameはファイルをリネーム | E-06 (L192-202) | ○ |
| C-60 | run_commandはコマンドを実行 | E-06 (L204-218) | ○ |
| C-61 | run_command_stdinはstdin付きで実行 | E-06 (L220-252) | ○ |
| C-62 | serialize_and_writeはTOMLを書き込む | E-06 (L254-266) | ○ |
| C-63 | offline_check_existsは存在を確認 | E-06 (L268-276) | ○ |
| C-64 | download_wgetはファイルをダウンロード | E-06 (L278-288) | ○ |
| C-65 | get_git_head_revはリビジョンを取得 | E-06 (L291-308) | ○ |
| C-66 | get_git_tag_revはタグからリビジョンを取得 | E-06 (L311-316) | ○ |
| C-67 | get_git_ref_entryはpacked-refsから取得 | E-06 (L317-333) | ○ |
| C-68 | get_git_fetch_revはFETCH_HEADから取得 | E-06 (L336-367) | ○ |
| C-69 | get_git_remote_trackingはトラッキング情報を取得 | E-06 (L371-460) | ○ |
| C-70 | chop_dot_gitは.git接尾辞を削除 | E-06 (L462-467) | ○ |

### pty.rs 関連（UT-COOK-115 〜 UT-COOK-124）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-71 | setup_ptyはPTYペアを作成 | E-07 (L34-57) | ○ |
| C-72 | flush_ptyはPTYをフラッシュ | E-07 (L59-68) | ○ |
| C-73 | spawn_to_pipeはPTY経由でコマンドを起動 | E-07 (L70-75) | ○ |
| C-74 | PtySizeはデフォルト値を持つ | E-07 (L100-109) | ○ |
| C-75 | PtyFdはEIOでEOFを返す | E-07 (L185-198) | ○ |
| C-76 | PtyFdはサイズ変更をサポート | E-07 (L201-224) | ○ |
| C-77 | PtyFdはサイズ取得をサポート | E-07 (L226-247) | ○ |

### ident.rs 関連（UT-COOK-125 〜 UT-COOK-129）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-78 | IdentifierConfig::newは識別子を初期化 | E-08 (L13-31) | ○ |
| C-79 | get_identは初期化済み識別子を取得 | E-08 (L36-40) | ○ |
| C-80 | init_identは識別子を初期化 | E-08 (L42-46) | ○ |

### script.rs 関連（UT-COOK-130 〜 UT-COOK-132）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-81 | SHARED_PRESCRIPTはDYNAMIC_INITを定義 | E-05 (L1-79) | ○ |
| C-82 | BUILD_PRESCRIPTは環境変数とテンプレートを定義 | E-05 (L81-306) | ○ |
| C-83 | BUILD_POSTSCRIPTは後処理を定義 | E-05 (L308-344) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし
  - 全てのテストケースはソースコードの関数・構造体・定数から直接導出されている

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク
  - 全テストケースがソースコードに基づいており、高い信頼性を持つ
  - 既存テストコード（file_system_loop_no_infinite_loop）との整合性も確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] UT-COOK-009（blake3不一致エラー）：セキュリティ関連テストの網羅性を確認
- [ ] UT-COOK-020（無限ループ検出）：パス深度50の閾値が適切か確認
- [ ] UT-COOK-077（既存テスト）：cook_build.rs内の既存テストとの重複/整合性を確認
- [ ] 境界値テスト：format_size(0)、空配列、空ディレクトリなどの境界値テストが十分か確認
- [ ] エラーハンドリング：全ての異常系テストケースがエラーメッセージの検証を含むか確認
