---
generated_at: 2026-01-23 15:30:00
metrics:
  claims_total: 70
  claims_with_evidence: 70
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：src-root単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：70 / 70、根拠なし：0
- 優先レビュー（高）
  1. **config::init_config関連テスト（UT-SRT-007〜013）**：設定初期化の重要なロジック
  2. **config::translate_mirror関連テスト（UT-SRT-019〜023）**：ミラーURL変換の重要機能
  3. **recipe::Recipe/CookRecipe関連テスト（UT-SRT-031〜055）**：パッケージビルドの中核ロジック

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/lib.rs` - ライブラリルート、定数定義とis_redox関数
- E-02: `src/config.rs` - 設定管理、CookConfigOpt/CookConfig/CookbookConfig構造体、init_config/get_config/translate_mirror関数
- E-03: `src/recipe.rs` - レシピ定義、SourceRecipe/BuildKind/BuildRecipe/PackageRecipe/Recipe/CookRecipe構造体
- E-04: `src/blake3.rs` - BLAKE3ハッシュ計算、blake3_progress/blake3_silent/hash_to_hex関数
- E-05: `src/progress_bar.rs` - プログレスバーラッパー、ProgressBarRead構造体
- E-06: `src/cook.rs` - cookサブモジュールのre-export（本モジュールでは構造体/関数なし）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | lib::is_redox正常系テスト（UT-SRT-001,002） | E-01 (line 14-16) | ○ |
| C-02 | lib::定数テスト（UT-SRT-003,004） | E-01 (line 8-13) | ○ |
| C-03 | config::CookConfigOpt変換テスト（UT-SRT-005,006） | E-02 (line 41-54) | ○ |
| C-04 | config::init_config正常系テスト（UT-SRT-007〜012） | E-02 (line 68-121) | ○ |
| C-05 | config::init_config異常系テスト（UT-SRT-009,013） | E-02 (line 72-75, 120) | ○ |
| C-06 | config::extract_envテスト（UT-SRT-014〜016） | E-02 (line 123-129) | ○ |
| C-07 | config::get_configテスト（UT-SRT-017,018） | E-02 (line 131-133) | ○ |
| C-08 | config::translate_mirrorテスト（UT-SRT-019〜023） | E-02 (line 135-167, 196-236) | ○ |
| C-09 | recipe::SourceRecipe::guess_versionテスト（UT-SRT-024〜026） | E-03 (line 70-87) | ○ |
| C-10 | recipe::BuildKind::defaultテスト（UT-SRT-027） | E-03 (line 130-134) | ○ |
| C-11 | recipe::BuildRecipeメソッドテスト（UT-SRT-028〜030） | E-03 (line 176-193) | ○ |
| C-12 | recipe::Recipe::newテスト（UT-SRT-031〜033） | E-03 (line 207-216) | ○ |
| C-13 | recipe::Recipe::get_packages_listテスト（UT-SRT-034,035） | E-03 (line 218-225) | ○ |
| C-14 | recipe::CookRecipe::newテスト（UT-SRT-036〜038） | E-03 (line 228-260) | ○ |
| C-15 | recipe::CookRecipe::from_nameテスト（UT-SRT-039,040） | E-03 (line 262-268) | ○ |
| C-16 | recipe::CookRecipe::from_pathテスト（UT-SRT-041,042） | E-03 (line 270-283) | ○ |
| C-17 | recipe::CookRecipe::new_recursiveテスト（UT-SRT-043〜045） | E-03 (line 285-383) | ○ |
| C-18 | recipe::CookRecipe公開APIテスト（UT-SRT-046〜048） | E-03 (line 385-426) | ○ |
| C-19 | recipe::CookRecipeパス系テスト（UT-SRT-049,050） | E-03 (line 429-439) | ○ |
| C-20 | recipe::CookRecipe::apply_filesystem_configテスト（UT-SRT-051〜055） | E-03 (line 441-471) | ○ |
| C-21 | recipe::ヘルパー関数テスト（UT-SRT-056〜058） | E-03 (line 476-498) | ○ |
| C-22 | blake3::blake3_progressテスト（UT-SRT-059〜061） | E-04 (line 6-23) | ○ |
| C-23 | blake3::blake3_silentテスト（UT-SRT-062〜064） | E-04 (line 25-31) | ○ |
| C-24 | blake3::hash_to_hexテスト（UT-SRT-065,066） | E-04 (line 33-35) | ○ |
| C-25 | progress_bar::ProgressBarReadテスト（UT-SRT-067〜070） | E-05 (line 5-22) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし
  - 全てのテストケースはソースコード内の構造体、関数、トレイト実装に基づいて生成
  - 既存のユニットテスト（src/config.rs内のmod tests、src/recipe.rs内のmod tests）も参考にしている

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースに根拠あり
- 注意点：
  - `config::init_config`はグローバル状態（OnceLock）を変更するため、テスト間の独立性に注意
  - `recipe::CookRecipe::new_recursive`は再帰関数のため、スタックオーバーフローに注意（WALK_DEPTH=16で制限）
  - blake3関連はファイルI/Oを伴うため、テスト環境の準備が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 各テストケースが対応するソースコードの行番号・関数と一致しているか確認
- [ ] 正常系・異常系・境界値のテストケースが網羅されているか確認
- [ ] 優先度「高」のテストケースが適切に設定されているか確認（金額計算相当のロジック：ハッシュ計算、設定初期化、依存関係解決）
- [ ] 既存テスト（src/config.rs::tests、src/recipe.rs::tests）との重複・整合性を確認
- [ ] パニックを起こす可能性のあるunwrap()使用箇所が異常系テストでカバーされているか確認
