---
generated_at: 2026-01-23 10:30:00
metrics:
  claims_total: 50
  claims_with_evidence: 47
  claims_without_evidence: 3
confidence_derived: 0.94
---

# 根拠レポート：受入テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：47 / 50、根拠なし：3
- 優先レビュー（高）
  1. **UAT-024 TUIモードの並列ビルド**：TUI実装の全ユーザーシナリオの網羅性確認が必要
  2. **UAT-033 tarball URLからのバージョン自動推測**：正規表現パターンの限定的なケースへの対応確認
  3. **UAT-046 リポジトリ公開**：repo_builderの詳細動作の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/bin/repo.rs` - メインCLIアプリケーション、コマンド定義（fetch, cook, unfetch, clean, push, tree, find）
- E-02: `src/recipe.rs` - Recipe構造体、SourceRecipe enum（Git, Tar, Path, SameAs）、BuildKind enum
- E-03: `src/cook/fetch.rs` - ソースフェッチ処理（git clone, tar extract, パッチ適用）
- E-04: `src/cook/cook_build.rs` - ビルド処理、依存関係解決、自動依存検出
- E-05: `src/cook/package.rs` - pkgarパッケージ生成、メタデータ作成
- E-06: `src/config.rs` - CookConfig構造体、設定管理、ミラーURL変換
- E-07: `src/cook/script.rs` - ビルドスクリプト定義（推定：BUILD_PRESCRIPT等の定数）
- E-08: `Cargo.toml` - 依存クレート定義（pkgar, redoxer, ratatui等）
- E-09: `README.md` - プロジェクト概要、Redox OSビルドシステムの説明
- E-10: `CONTRIBUTING.md` - 開発ガイドライン、ビルド手順
- E-11: `src/lib.rs` - モジュール定義、定数（WALK_DEPTH, REMOTE_PKG_SOURCE）
- E-12: `src/cook/pty.rs` - PTYログ出力処理（TUI用）
- E-13: `src/cook/tree.rs` - 依存関係ツリー表示

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Gitリポジトリからソースをフェッチできる | E-02, E-03 | ○ |
| C-02 | tarballからソースをフェッチできる | E-02, E-03 | ○ |
| C-03 | パスソースからソースをコピーできる | E-02, E-03 | ○ |
| C-04 | same_asで他のレシピのソースを共有できる | E-02, E-03 | ○ |
| C-05 | Cargoテンプレートでビルドできる | E-02, E-04 | ○ |
| C-06 | Configureテンプレートでビルドできる | E-02, E-04 | ○ |
| C-07 | CMakeテンプレートでビルドできる | E-02, E-04 | ○ |
| C-08 | Mesonテンプレートでビルドできる | E-02, E-04 | ○ |
| C-09 | カスタムスクリプトでビルドできる | E-02, E-04 | ○ |
| C-10 | pkgarパッケージが正常に生成される | E-05, E-08 | ○ |
| C-11 | ビルド依存関係が自動的に解決される | E-02, E-04 | ○ |
| C-12 | dev-dependenciesが開発ビルド時に解決される | E-02, E-04 | ○ |
| C-13 | パッケージ依存関係が自動検出される | E-04 | ○ |
| C-14 | ビルド成果物をクリーンできる | E-01 | ○ |
| C-15 | ソースディレクトリをクリーンできる | E-01 | ○ |
| C-16 | パッケージをsysrootに展開できる | E-01 | ○ |
| C-17 | パッケージ依存関係付きでインストールできる | E-01 | ○ |
| C-18 | 依存関係ツリーを表示できる | E-01, E-13 | ○ |
| C-19 | レシピのパスを検索できる | E-01 | ○ |
| C-20 | cookbook.tomlで設定をカスタマイズできる | E-06 | ○ |
| C-21 | ミラーURLを設定できる | E-06 | ○ |
| C-22 | オフラインでビルドできる | E-03, E-06 | ○ |
| C-23 | リモートからプリビルドパッケージを取得できる | E-02, E-03 | ○ |
| C-24 | TUIモードで並列ビルドできる | E-01, E-12 | △ |
| C-25 | ビルド失敗時にリトライできる | E-01 | ○ |
| C-26 | ビルド失敗時にスキップできる | E-01 | ○ |
| C-27 | ビルドログがファイルに保存される | E-01, E-06 | ○ |
| C-28 | ソースにパッチを適用できる | E-02, E-03 | ○ |
| C-29 | フェッチ後スクリプトを実行できる | E-02, E-03 | ○ |
| C-30 | ホストツールチェーン用パッケージをビルドできる | E-02, E-05 | ○ |
| C-31 | オプショナルパッケージを生成できる | E-02, E-04 | ○ |
| C-32 | パッケージバージョンが正しく設定される | E-02, E-05 | ○ |
| C-33 | tarball URLからバージョンが自動推測される | E-02 | △ |
| C-34 | filesystemファイルでレシピ設定を上書きできる | E-01 | ○ |
| C-35 | カテゴリ単位でビルドできる | E-01 | ○ |
| C-36 | ジョブ数を指定してビルドできる | E-06 | ○ |
| C-37 | ビルドキャッシュが有効に機能する | E-04 | ○ |
| C-38 | 依存関係更新時に再ビルドされる | E-04 | ○ |
| C-39 | blake3ハッシュ不一致時にエラーとなる | E-03 | ○ |
| C-40 | ビルドエラー時にログが保存される | E-01 | ○ |
| C-41 | エラー発生後も継続してビルドできる | E-01, E-06 | ○ |
| C-42 | Gitサブモジュールが正しく初期化される | E-03 | ○ |
| C-43 | シャロークローンでソースを取得できる | E-02, E-03 | ○ |
| C-44 | ブランチ指定でソースを取得できる | E-02, E-03 | ○ |
| C-45 | リビジョン指定でソースを取得できる | E-02, E-03 | ○ |
| C-46 | リポジトリにパッケージを公開できる | E-01 | △ |
| C-47 | クリーンビルドを強制できる | E-04, E-06 | ○ |
| C-48 | ビルド後にターゲットをクリーンできる | E-04, E-06 | ○ |
| C-49 | 詳細ログを表示できる | E-01, E-06 | ○ |
| C-50 | ビルドスクリプトに環境変数が渡される | E-04, E-07 | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-24 TUIモードの詳細シナリオ**：TUI操作（キーボードショートカット、マウス操作）の詳細なユーザーシナリオテストが不足。実装コードは確認できるが、全操作パターンの網羅的なテストケース設計には追加調査が必要
  - 候補：E2Eテスト仕様書 / UIテストガイドライン / ユーザーマニュアル
- **C-33 バージョン自動推測の制限**：guess_version()関数は `\d+\.\d+\.\d+` パターンのみ対応。他のバージョン形式（v1.2.3, 1.2等）への対応は未確認
  - 候補：バージョニング仕様書 / 追加の正規表現パターン定義
- **C-46 repo_builder詳細**：publish_packages関数でrepo_builderバイナリを呼び出すが、repo_builder.rsの詳細実装の確認が不十分
  - 候補：src/bin/repo_builder.rs の詳細解析

## 5) リスクフラグ（レビュー観点）
- **リスク1（中）**：TUIモードのエラーハンドリング - ビルド失敗時のリトライ/スキップ処理がatomic操作で保護されているが、競合状態の可能性を検証する必要あり
- **リスク0（低）**：パッチ適用順序 - patches配列の順序でパッチが適用されることを明確にドキュメント化推奨
- **リスク1（中）**：シャロークローン時のサブモジュール - --filter=tree:0 と --also-filter-submodules の組み合わせが全てのリポジトリで動作するか検証が必要
- **リスク0（低）**：ミラーURL変換 - 最長一致アルゴリズムが実装されているが、エッジケース（末尾スラッシュの有無等）のテストを推奨

## 6) レビュアーチェックリスト（最小）
- [ ] UAT-001〜UAT-004（フェッチシナリオ）：Git, Tar, Path, SameAsの各ソースタイプでフェッチが正常に動作するか実機確認
- [ ] UAT-005〜UAT-009（ビルドテンプレート）：各ビルドテンプレート（Cargo, Configure, CMake, Meson, Custom）で実際のレシピがビルドできるか確認
- [ ] UAT-011〜UAT-013（依存関係）：複雑な依存関係を持つパッケージで依存解決が正しく動作するか確認
- [ ] UAT-024〜UAT-026（TUI操作）：TUIモードでの操作（ログスクロール、リトライ、スキップ）が期待通りに動作するか確認
- [ ] UAT-037〜UAT-038（キャッシュ）：ビルドキャッシュが適切に機能し、不要な再ビルドが発生しないことを確認
- [ ] UAT-039〜UAT-040（エラー処理）：不正な入力や失敗時に適切なエラーメッセージが表示されることを確認
- [ ] 全テストケース：テスト手順が再現可能で、期待結果が明確に検証可能であることを確認
