---
generated_at: 2026-01-23 15:30:00
metrics:
  claims_total: 35
  claims_with_evidence: 33
  claims_without_evidence: 2
confidence_derived: 0.94
---

# 根拠レポート：業務要件一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：33 / 35、根拠なし：2
- 優先レビュー（高）
  1. **BR-016 並列ビルド対応（TUI）**：TUI実装の詳細仕様が外部ドキュメントに依存
  2. **BR-032 ビルドエラーリトライ**：TUI操作の詳細フローがコードのみで把握

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/recipe.rs` - SourceRecipe enum定義（Git, Tar, Path, SameAs）
- E-02: `src/recipe.rs` - BuildKind enum定義（Cargo, Configure, Cmake, Meson, Custom, Remote, None）
- E-03: `src/cook/fetch.rs` - fetch(), fetch_offline()関数
- E-04: `src/cook/fetch.rs` - fetch_apply_patches()関数
- E-05: `src/cook/fetch.rs` - fetch_remote()関数
- E-06: `src/cook/cook_build.rs` - build()関数
- E-07: `src/cook/cook_build.rs` - auto_deps_from_dynamic_linking()関数
- E-08: `src/cook/cook_build.rs` - build_deps_dir()関数
- E-09: `src/cook/package.rs` - package()関数
- E-10: `src/cook/package.rs` - package_toml()関数
- E-11: `src/bin/repo.rs` - CliCommand enum定義
- E-12: `src/bin/repo.rs` - parse_args()関数
- E-13: `src/bin/repo.rs` - handle_fetch(), handle_cook()関数
- E-14: `src/bin/repo.rs` - handle_push(), handle_tree()関数
- E-15: `src/bin/repo.rs` - run_tui_cook()関数
- E-16: `src/config.rs` - CookConfig構造体
- E-17: `src/config.rs` - translate_mirror()関数
- E-18: `src/lib.rs` - WALK_DEPTH定数（16）
- E-19: `src/lib.rs` - REMOTE_PKG_SOURCE定数
- E-20: `src/recipe.rs` - CookRecipe::get_build_deps_recursive()関数
- E-21: `src/recipe.rs` - CookRecipe::apply_filesystem_config()関数
- E-22: `README.md` - プロジェクト概要

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BR-001 Gitリポジトリからのソース取得 | E-01, E-03 | ○ |
| C-02 | BR-002 Tarアーカイブからのソース取得 | E-01, E-03 | ○ |
| C-03 | BR-003 パッチ適用機能 | E-04 | ○ |
| C-04 | BR-004 ソース共有機能（same_as） | E-01, E-03 | ○ |
| C-05 | BR-005 ローカルソース対応 | E-01, E-03 | ○ |
| C-06 | BR-006 リモートパッケージ取得 | E-02, E-05, E-19 | ○ |
| C-07 | BR-007 Cargoビルド対応 | E-02, E-06 | ○ |
| C-08 | BR-008 Configureビルド対応 | E-02, E-06 | ○ |
| C-09 | BR-009 CMakeビルド対応 | E-02, E-06 | ○ |
| C-10 | BR-010 Mesonビルド対応 | E-02, E-06 | ○ |
| C-11 | BR-011 カスタムスクリプトビルド対応 | E-02, E-06 | ○ |
| C-12 | BR-012 依存関係解決 | E-18, E-20 | ○ |
| C-13 | BR-013 sysroot構築 | E-08 | ○ |
| C-14 | BR-014 ホストツールチェーン構築 | E-06, E-08 | ○ |
| C-15 | BR-015 インクリメンタルビルド対応 | E-06 | ○ |
| C-16 | BR-016 並列ビルド対応（TUI） | E-15 | △ |
| C-17 | BR-017 pkgarパッケージ生成 | E-09 | ○ |
| C-18 | BR-018 パッケージメタデータ生成 | E-10 | ○ |
| C-19 | BR-019 自動依存関係検出 | E-07 | ○ |
| C-20 | BR-020 オプショナルパッケージ対応 | E-09 | ○ |
| C-21 | BR-021 リポジトリ公開 | E-11, E-13 | ○ |
| C-22 | BR-022 sysroot展開（push） | E-14 | ○ |
| C-23 | BR-023 依存関係ツリー表示 | E-14 | ○ |
| C-24 | BR-024 レシピ設定管理 | E-01, E-02 | ○ |
| C-25 | BR-025 グローバル設定管理 | E-16 | ○ |
| C-26 | BR-026 ファイルシステム設定対応 | E-12, E-21 | ○ |
| C-27 | BR-027 ミラーURL変換 | E-17 | ○ |
| C-28 | BR-028 ソースディレクトリ削除 | E-11, E-13 | ○ |
| C-29 | BR-029 ビルド成果物削除 | E-11, E-13 | ○ |
| C-30 | BR-030 ビルド後自動クリーンアップ | E-06, E-16 | ○ |
| C-31 | BR-031 ビルドエラー継続処理 | E-12, E-16 | ○ |
| C-32 | BR-032 ビルドエラーリトライ | E-15 | △ |
| C-33 | BR-033 ビルドログ保存 | E-12, E-15 | ○ |
| C-34 | BR-034 ソース識別子記録 | E-03 | ○ |
| C-35 | BR-035 ビルド識別子記録 | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- **BR-016, BR-032**: TUIの詳細な操作仕様・状態遷移がコード内のみで定義されており、外部仕様書が存在しない
  - 候補：TUI操作マニュアル / ユーザーガイド / UXフロー図

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ほとんどの業務要件はソースコードから明確に読み取れる
- 1: 中リスク - TUI関連機能（BR-016, BR-032）は実装詳細がコードに依存しており、仕様変更時の影響範囲把握が困難
- 0: 低リスク - パッケージ署名・検証はpkgar外部ライブラリに委譲されており、セキュリティ実装は堅牢

## 6) レビュアーチェックリスト（最小）
- [ ] 各業務要件がプロジェクトの目的（Redox OS ビルドシステム）と整合しているか確認
- [ ] 依存関係解決の最大深度（16階層）が実運用で十分か確認
- [ ] TUI機能（BR-016, BR-032）の操作性・エラーハンドリングが十分か確認
- [ ] リモートパッケージ取得時の署名検証が適切に行われているか確認
- [ ] ビルドログの保存先・ローテーションポリシーが運用要件を満たすか確認
