---
generated_at: 2026-01-22 22:50:00
metrics:
  claims_total: 59
  claims_with_evidence: 59
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：機能一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：59 / 59、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全ての機能に対してソースコードによる根拠が確認できました

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/lib.rs` - ライブラリモジュール定義
- E-02: `src/recipe.rs` - レシピ解析機能（SourceRecipe, BuildKind, Recipe構造体）
- E-03: `src/cook/fetch.rs` - ソース取得機能（Git/Tar/Path/SameAs/Remote）
- E-04: `src/cook/cook_build.rs` - ビルド実行機能（build関数、auto_deps）
- E-05: `src/cook/package.rs` - パッケージング機能（pkgar作成、メタデータ生成）
- E-06: `src/cook/fs.rs` - ファイルシステム操作ユーティリティ
- E-07: `src/cook/script.rs` - ビルドスクリプト定義（SHARED_PRESCRIPT, BUILD_PRESCRIPT, BUILD_POSTSCRIPT）
- E-08: `src/cook/ident.rs` - ソース識別子管理
- E-09: `src/cook/tree.rs` - 依存関係ツリー表示
- E-10: `src/cook/pty.rs` - 擬似端末管理
- E-11: `src/blake3.rs` - blake3ハッシュ計算
- E-12: `src/progress_bar.rs` - プログレスバー表示
- E-13: `src/config.rs` - 設定管理（CookConfig, translate_mirror）
- E-14: `src/bin/repo.rs` - CLIメインエントリポイント（fetchコマンド等）
- E-15: `src/bin/repo_builder.rs` - リポジトリ公開機能
- E-16: `src/bin/cookbook_redoxer.rs` - クロスコンパイルラッパー
- E-17: `Cargo.toml` - プロジェクト定義・依存関係
- E-18: `README.md` - プロジェクト概要

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | レシピ解析機能 | E-02 | ○ |
| C-02 | ソース取得（Git） | E-03 | ○ |
| C-03 | ソース取得（Tar） | E-03 | ○ |
| C-04 | ソース取得（パス参照） | E-03 | ○ |
| C-05 | ソース取得（同一ソース参照） | E-02, E-03 | ○ |
| C-06 | リモートパッケージ取得 | E-03 | ○ |
| C-07 | パッチ適用 | E-03 | ○ |
| C-08 | ビルド前スクリプト実行 | E-02, E-03 | ○ |
| C-09 | Cargoビルド | E-02, E-04, E-07 | ○ |
| C-10 | Configureビルド | E-02, E-04, E-07 | ○ |
| C-11 | CMakeビルド | E-02, E-04, E-07 | ○ |
| C-12 | Mesonビルド | E-02, E-04, E-07 | ○ |
| C-13 | カスタムビルド | E-02, E-04 | ○ |
| C-14 | 依存関係解決 | E-02, E-04 | ○ |
| C-15 | 自動依存関係検出 | E-04 | ○ |
| C-16 | sysroot構築 | E-04 | ○ |
| C-17 | toolchain構築 | E-04 | ○ |
| C-18 | ステージディレクトリ管理 | E-04, E-05 | ○ |
| C-19 | pkgarアーカイブ作成 | E-05 | ○ |
| C-20 | パッケージメタデータ生成 | E-05 | ○ |
| C-21 | パッケージ署名 | E-05 | ○ |
| C-22 | オプショナルパッケージ分離 | E-02, E-04 | ○ |
| C-23 | リポジトリ公開 | E-15 | ○ |
| C-24 | repo.toml生成 | E-15 | ○ |
| C-25 | 古いパッケージ追跡 | E-15 | ○ |
| C-26 | AppStream生成 | E-15 | ○ |
| C-27 | fetchコマンド | E-14 | ○ |
| C-28 | cookコマンド | E-14 | ○ |
| C-29 | unfetchコマンド | E-14 | ○ |
| C-30 | cleanコマンド | E-14 | ○ |
| C-31 | pushコマンド | E-14 | ○ |
| C-32 | treeコマンド | E-14 | ○ |
| C-33 | findコマンド | E-14 | ○ |
| C-34 | filesystem設定オーバーライド | E-02, E-14 | ○ |
| C-35 | 並列ビルドTUI | E-14 | ○ |
| C-36 | ビルドログ出力 | E-14 | ○ |
| C-37 | オフラインモード | E-03, E-13, E-14 | ○ |
| C-38 | ノンストップモード | E-13, E-14 | ○ |
| C-39 | cookbook.toml読み込み | E-13 | ○ |
| C-40 | ミラーURL変換 | E-13 | ○ |
| C-41 | 環境変数オーバーライド | E-13 | ○ |
| C-42 | blake3ハッシュ計算 | E-11 | ○ |
| C-43 | Git HEAD取得 | E-06 | ○ |
| C-44 | Git FETCH_HEAD取得 | E-06 | ○ |
| C-45 | Gitリモートトラッキング取得 | E-06 | ○ |
| C-46 | PTY管理 | E-10 | ○ |
| C-47 | プログレスバー | E-12 | ○ |
| C-48 | 依存関係ツリー表示 | E-09 | ○ |
| C-49 | ファイルサイズフォーマット | E-09 | ○ |
| C-50 | ソース識別子管理 | E-08 | ○ |
| C-51 | ターゲット判定 | E-05 | ○ |
| C-52 | cookbook_redoxer | E-16 | ○ |
| C-53 | 動的/静的リンク切替 | E-07 | ○ |
| C-54 | CMakeクロスファイル生成 | E-07 | ○ |
| C-55 | Mesonクロスファイル生成 | E-07 | ○ |
| C-56 | バイナリストリップ | E-07 | ○ |
| C-57 | libtoolファイル削除 | E-07 | ○ |
| C-58 | cargoインストールファイル削除 | E-07 | ○ |
| C-59 | AppStreamメタデータ更新 | E-07 | ○ |

## 4) 不足情報（Unknown / Missing）
- 不足情報はありません。全ての機能がソースコードから直接確認できました。

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：全ての機能がソースコードで直接確認できる

**補足事項:**
- 本プロジェクトはRedox OS向けのビルドシステム（Cookbook）です
- 機能一覧はRustソースコード（src/ディレクトリ）から抽出しました
- 外部依存関係（pkgar, redoxer, redox_installer等）の内部実装は本一覧には含まれていません

## 6) レビュアーチェックリスト（最小）
- [ ] 各機能のカテゴリ分類が適切か確認する
- [ ] 機能の説明がソースコードの実装と一致しているか確認する
- [ ] 備考欄に記載されたファイルパスが正しいか確認する
- [ ] 重要な機能の漏れがないか確認する（特にセキュリティ関連）
- [ ] 機能名が一意で理解しやすいか確認する
