# 機能設計書 1-レシピ解析

## 概要

本ドキュメントは、Redox OSビルドシステムにおけるレシピ解析機能の設計を記載する。recipe.tomlファイルを解析し、パッケージのビルド設定を取得する機能について詳述する。

### 本機能の処理概要

レシピ解析機能は、Redox OSのパッケージビルドシステムにおける中核的な機能であり、各パッケージのビルド方法を定義するrecipe.tomlファイルを解析して、必要な設定情報を構造化されたデータとして取得する。

**業務上の目的・背景**：Redox OSは多数のパッケージで構成されており、各パッケージは独自のビルド方法（ソース取得方法、ビルドテンプレート、依存関係）を持つ。これらの設定を統一的なフォーマット（TOML形式）で管理し、ビルドシステムが自動的に解釈・実行できるようにすることで、大規模なOSビルドの自動化と保守性を実現する。

**機能の利用シーン**：
- パッケージのfetch（ソース取得）処理前にソース取得方法を決定する際
- パッケージのcook（ビルド）処理前にビルドテンプレートと依存関係を決定する際
- 依存関係ツリーの解析時に各パッケージの依存関係情報を取得する際
- filesystem設定オーバーライドを適用してビルドルールを変更する際

**主要な処理内容**：
1. recipe.tomlファイルの存在確認とファイル読み込み
2. TOMLパーサーによるファイル内容のデシリアライズ
3. SourceRecipe（ソース取得設定）の解析（Git/Tar/Path/SameAs）
4. BuildRecipe（ビルド設定）の解析（テンプレート種別、依存関係）
5. PackageRecipe（パッケージ設定）の解析（実行時依存関係、バージョン）
6. OptionalPackageRecipe（オプショナルパッケージ）の解析
7. CookRecipeオブジェクトの構築とターゲット判定

**関連システム・外部連携**：
- pkgクレート：パッケージ名の検証とレシピディレクトリの検索
- tomlクレート：TOML形式のパース処理
- serdeクレート：シリアライズ/デシリアライズ処理

**権限による制御**：特になし（ファイルシステムの読み取り権限のみ必要）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | TUIメイン画面 | API連携 | ビルド対象レシピのrecipe.toml解析 |
| 3 | repo fetchコマンド画面 | API連携 | recipe.tomlの解析とソース取得設定の取得 |
| 4 | repo cookコマンド画面 | API連携 | recipe.tomlの解析とビルド設定取得 |
| 5 | repo unfetchコマンド画面 | API連携 | 削除対象レシピの特定 |
| 6 | repo cleanコマンド画面 | API連携 | 削除対象レシピの特定 |
| 7 | repo pushコマンド画面 | API連携 | 展開対象パッケージの特定 |
| 9 | repo findコマンド画面 | API連携 | レシピディレクトリパスの取得 |
| 10 | repo_builderコマンド画面 | API連携 | 公開対象レシピの解析 |

## 機能種別

データ連携 / バリデーション / 設定解析

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| file | PathBuf | Yes | recipe.tomlファイルのパス | ファイルが存在すること |
| name | PackageName | Yes（from_name使用時） | パッケージ名 | 有効なパッケージ名形式 |
| dir | &Path | Yes（from_path使用時） | レシピディレクトリパス | ディレクトリが存在すること |
| read_recipe | bool | Yes（from_path使用時） | レシピを実際に読み込むか | - |
| is_host | bool | Yes（from_path使用時） | ホストパッケージかどうか | - |

### 入力データソース

- ファイルシステム：`{レシピディレクトリ}/recipe.toml`

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| source | Option<SourceRecipe> | ソース取得設定（Git/Tar/Path/SameAs） |
| build | BuildRecipe | ビルド設定（テンプレート、依存関係） |
| package | PackageRecipe | パッケージ設定（実行時依存関係） |
| optional_packages | Vec<OptionalPackageRecipe> | オプショナルパッケージ設定 |

### 出力先

- メモリ上のRecipe/CookRecipe構造体として呼び出し元に返却

## 処理フロー

### 処理シーケンス

```
1. ファイル存在確認
   └─ recipe.tomlファイルが存在しない場合はPackageError::FileMissingを返却
2. ファイル読み込み
   └─ fs::read_to_stringでファイル内容を文字列として読み込み
3. TOMLパース
   └─ toml::from_strでRecipe構造体にデシリアライズ
4. SourceRecipe解析（存在する場合）
   └─ Git/Tar/Path/SameAsのいずれかの形式を識別
5. BuildRecipe解析
   └─ テンプレート種別（cargo/configure/cmake/meson/custom/none/remote）を識別
   └─ ビルド依存関係と開発依存関係を取得
6. PackageRecipe解析
   └─ 実行時依存関係とバージョン情報を取得
7. OptionalPackageRecipe解析
   └─ オプショナルパッケージの名前、依存関係、ファイルパターンを取得
8. CookRecipe構築（必要な場合）
   └─ ターゲット判定とホストパッケージ用の依存関係変換
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{recipe.tomlが存在するか}
    B -->|No| C[FileMissingエラー]
    B -->|Yes| D[ファイル読み込み]
    D --> E{読み込み成功か}
    E -->|No| F[Parseエラー]
    E -->|Yes| G[TOMLパース]
    G --> H{パース成功か}
    H -->|No| F
    H -->|Yes| I[Recipe構造体生成]
    I --> J{CookRecipe構築が必要か}
    J -->|No| K[Recipeを返却]
    J -->|Yes| L[ターゲット判定]
    L --> M{ホストパッケージか}
    M -->|Yes| N[依存関係をホスト用に変換]
    M -->|No| O[依存関係をそのまま使用]
    N --> P[CookRecipeを返却]
    O --> P
    K --> Q[終了]
    P --> Q
    C --> Q
    F --> Q
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | ソースタイプ判定 | sourceセクションの内容からGit/Tar/Path/SameAsを自動判定 | sourceセクションが存在する場合 |
| BR-02 | ビルドテンプレート判定 | buildセクションのtemplate値からビルド方法を決定 | buildセクションが存在する場合 |
| BR-03 | デフォルトビルドタイプ | templateが指定されない場合はBuildKind::Noneとする | buildセクションでtemplate未指定時 |
| BR-04 | ホストパッケージ依存関係変換 | ホストパッケージの場合、依存関係をホスト用に変換 | パッケージ名がhost-で始まる場合 |
| BR-05 | バージョン推測 | Tarソースの場合、URLからバージョン番号を正規表現で抽出 | Tar形式のソース指定時 |

### 計算ロジック

**バージョン推測ロジック（guess_version）**：
```
正規表現パターン: \d+\.\d+\.\d+
TarソースのURLからセマンティックバージョン形式（X.Y.Z）を抽出
例: "http://example.com/package-1.2.3.tar.gz" → "1.2.3"
```

## データベース操作仕様

本機能ではデータベース操作は行わない（ファイルシステムのみ）。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| FileMissing | ファイル不在 | recipe.tomlが存在しない | レシピディレクトリの確認 |
| Parse | パースエラー | TOMLファイルの文法エラー | recipe.tomlの文法修正 |
| PackageNotFound | パッケージ不在 | 指定されたパッケージ名のレシピが見つからない | パッケージ名の確認 |
| Recursion | 再帰制限超過 | 依存関係の解析が16階層を超えた | 循環依存の確認 |

### リトライ仕様

リトライは行わない（ファイル読み込みエラーは即時返却）

## トランザクション仕様

トランザクション管理は不要（読み取り専用操作）

## パフォーマンス要件

- 単一レシピの解析：10ms以内
- 依存関係の再帰的解析：深さ16階層まで対応

## セキュリティ考慮事項

- ファイルパスのバリデーション：パストラバーサル攻撃の防止
- same_asによる無限ループ検出：50階層を超えるパス深度で検出

## 備考

- recipe.tomlの形式はRedox OS独自の仕様
- shallow_cloneオプションはGitソースでのみ有効

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、レシピを表現するデータ構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | recipe.rs | `src/recipe.rs` | Recipe, SourceRecipe, BuildRecipe等の構造体定義 |

**読解のコツ**:
- `#[serde(untagged)]`はTOMLのキー名からvariantを自動判定する
- `#[serde(tag = "template")]`はtemplate値でビルドタイプを識別する
- `#[serde(default)]`はオプショナルフィールドにデフォルト値を使用する

**主要処理フロー**:
- **18-67行目**: SourceRecipe enum定義（SameAs/Path/Git/Tar）
- **90-128行目**: BuildKind enum定義（None/Remote/Cargo/Configure/Cmake/Meson/Custom）
- **136-144行目**: BuildRecipe構造体（kind, dependencies, dev_dependencies）
- **146-151行目**: PackageRecipe構造体（dependencies, version）
- **162-174行目**: Recipe構造体（source, build, package, optional_packages）
- **195-204行目**: CookRecipe構造体（name, dir, recipe, target, is_deps, rule）

#### Step 2: エントリーポイントを理解する

レシピ読み込みの起点となる関数を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | recipe.rs | `src/recipe.rs` | Recipe::new(), CookRecipe::from_name(), CookRecipe::from_path() |

**主要処理フロー**:
- **207-216行目**: Recipe::new() - TOMLファイルの読み込みとパース
- **262-268行目**: CookRecipe::from_name() - パッケージ名からレシピを検索して読み込み
- **270-283行目**: CookRecipe::from_path() - パスからレシピを読み込み
- **227-260行目**: CookRecipe::new() - ターゲット判定とホストパッケージ用依存関係変換

#### Step 3: 依存関係解析を理解する

依存関係の再帰的解析ロジックを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | recipe.rs | `src/recipe.rs` | new_recursive(), get_build_deps_recursive(), get_package_deps_recursive() |

**主要処理フロー**:
- **285-383行目**: new_recursive() - 依存関係の再帰的解析
- **385-401行目**: get_build_deps_recursive() - ビルド依存関係の取得
- **403-420行目**: get_package_deps_recursive() - パッケージ依存関係の取得

#### Step 4: 設定オーバーライドを理解する

filesystem設定によるレシピ設定の上書き処理を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | recipe.rs | `src/recipe.rs` | apply_filesystem_config() |

**主要処理フロー**:
- **441-471行目**: apply_filesystem_config() - source/local/binary/ignoreルールの適用

### プログラム呼び出し階層図

```
CookRecipe::from_name(name)
    │
    ├─ recipes::find(name)           # pkgクレート：レシピディレクトリ検索
    │
    └─ Recipe::new(&file)
           │
           ├─ fs::read_to_string()   # ファイル読み込み
           │
           └─ toml::from_str()       # TOMLパース
                  │
                  └─ serde Deserialize # 構造体へのデシリアライズ

CookRecipe::new(name, dir, recipe)
    │
    ├─ cook_package::package_target() # ターゲット判定
    │
    └─ 依存関係変換（ホストパッケージの場合）

CookRecipe::get_build_deps_recursive(names)
    │
    └─ new_recursive()
           │
           ├─ from_name()            # 各依存パッケージのレシピ読み込み
           │
           └─ 再帰呼び出し           # 依存関係の深掘り
```

### データフロー図

```
[入力]                    [処理]                         [出力]

recipe.toml ───────▶ fs::read_to_string() ───▶ TOML文字列
                            │
                            ▼
                     toml::from_str() ───────▶ Recipe構造体
                            │                      │
                            │                      ├─ source: Option<SourceRecipe>
                            │                      ├─ build: BuildRecipe
                            │                      ├─ package: PackageRecipe
                            │                      └─ optional_packages: Vec<...>
                            ▼
                     CookRecipe::new() ──────▶ CookRecipe構造体
                                                   │
                                                   ├─ name: PackageName
                                                   ├─ dir: PathBuf
                                                   ├─ recipe: Recipe
                                                   ├─ target: &'static str
                                                   ├─ is_deps: bool
                                                   └─ rule: String
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| recipe.rs | `src/recipe.rs` | ソース | レシピ解析のメインロジック、データ構造定義 |
| lib.rs | `src/lib.rs` | ソース | WALK_DEPTH定数の定義（依存関係解析の最大深度） |
| config.rs | `src/config.rs` | ソース | cookbook.toml設定の読み込み（ミラー設定等） |
| package.rs | `src/cook/package.rs` | ソース | package_target()関数によるターゲット判定 |
| recipe.toml | 各レシピディレクトリ | 設定 | パッケージごとのビルド設定ファイル |
