# 機能設計書 10-Configureビルド

## 概要

本ドキュメントは、Redox OSビルドシステムにおけるautotoolsプロジェクトをconfigure/makeでビルドする機能の設計を記載する。template=configureによるGNU系ソフトウェアのクロスコンパイルについて詳述する。

### 本機能の処理概要

Configureビルド機能は、autotoolsで構築されたプロジェクト（configure/make/make installの三段階ビルド）をビルドし、ステージディレクトリにインストールする機能である。クロスコンパイル用の適切なフラグを設定し、Redox OS向けにビルドする。

**業務上の目的・背景**：多くのGNU系ソフトウェア（bash, coreutils, glib等）やその他のオープンソースプロジェクトはautotoolsを使用している。これらをRedox OS向けにクロスコンパイルするために、適切な--host、--prefix、その他のconfigureフラグを設定する必要がある。この機能により、autotoolsプロジェクトのビルドが自動化される。

**機能の利用シーン**：
- GNU系ユーティリティ（bash, coreutils, findutils等）のビルド
- autotoolsベースのライブラリ（glib, libpng等）のビルド
- 動的/静的リンクの切り替え

**主要な処理内容**：
1. 依存パッケージのsysroot構築
2. ビルドスクリプトの構築
3. cookbook_configure関数によるビルド
   - configure実行
   - make実行
   - make install実行
4. ビルド後処理

**関連システム・外部連携**：
- autotools：configure/make/make install
- cookbook_redoxer：クロスコンパイル環境

**権限による制御**：特になし（ファイルシステムの書き込み権限が必要）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 4 | repo cookコマンド画面 | API連携 | template=configureでのautotoolsプロジェクトビルド |

## 機能種別

ビルド処理 / 外部コマンド実行

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| template | "configure" | Yes | ビルドテンプレート指定 | - |
| configureflags | Vec<String> | No | 追加のconfigureフラグ | - |

### 入力データソース

- recipe.toml: buildセクションのtemplate="configure"と関連フラグ
- source/configure: autotoolsで生成されたconfigureスクリプト

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| ビルド成果物 | Files | コンパイルされたバイナリ・ライブラリ |
| インストール先 | Directory | stage/usr/等 |

### 出力先

- ファイルシステム：`{レシピディレクトリ}/target/{target}/stage/`

## 処理フロー

### 処理シーケンス

```
1. 依存パッケージのsysroot構築
   └─ 依存pkgarをsysrootディレクトリに展開
2. ビルドスクリプトの構築
   ├─ BUILD_PRESCRIPT（環境変数設定）
   ├─ SHARED_PRESCRIPT（共有関数）
   ├─ DYNAMIC_INIT実行
   ├─ configureflagsの追加
   └─ cookbook_configure関数呼び出し
3. cookbook_redoxerによるビルド環境設定
   └─ クロスコンパイル用の環境変数とターゲット設定
4. cookbook_configureの実行
   ├─ ${COOKBOOK_CONFIGURE} ${COOKBOOK_CONFIGURE_FLAGS[@]}
   ├─ ${COOKBOOK_MAKE} -j ${COOKBOOK_MAKE_JOBS}
   └─ ${COOKBOOK_MAKE} install DESTDIR=${COOKBOOK_STAGE}
5. ビルド後処理
   ├─ バイナリのstrip
   └─ .laファイルの削除
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[sysroot構築]
    B --> C[toolchain構築（非ホストの場合）]
    C --> D[stage.tmp作成]
    D --> E[build dir作成]
    E --> F[ビルドスクリプト構築]
    F --> G[cookbook_redoxer env bash -e 実行]
    G --> H[DYNAMIC_INIT]
    H --> I[COOKBOOK_CONFIGURE_FLAGS設定]
    I --> J[configure実行]
    J --> K{configure成功か}
    K -->|No| L[エラー返却]
    K -->|Yes| M[make -j N 実行]
    M --> N{make成功か}
    N -->|No| L
    N -->|Yes| O[make install DESTDIR 実行]
    O --> P{install成功か}
    P -->|No| L
    P -->|Yes| Q[BUILD_POSTSCRIPT実行]
    Q --> R[オプショナルパッケージ分離]
    R --> S[stage.tmpをstageにリネーム]
    S --> T[終了]
    L --> T
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | DYNAMIC_INIT | 動的リンク設定を適用（--enable-shared等） | 常時 |
| BR-02 | クロスコンパイルフラグ | --host=${GNU_TARGET}を自動設定 | 常時 |
| BR-03 | prefix設定 | --prefix=/usrを自動設定 | 常時 |
| BR-04 | 静的リンクデフォルト | DYNAMIC_INIT前は--disable-shared --enable-static | 常時 |
| BR-05 | 並列make | -j ${COOKBOOK_MAKE_JOBS}で並列実行 | 常時 |
| BR-06 | DESTDIR | make installはDESTDIR指定でステージにインストール | 常時 |

### 計算ロジック

**COOKBOOK_CONFIGURE_FLAGS（デフォルト）**（script.rs）:
```bash
COOKBOOK_CONFIGURE_FLAGS=(
    --host="${GNU_TARGET}"
    --prefix="/usr"
    --disable-shared
    --enable-static
)
```

**DYNAMIC_INIT後**:
```bash
COOKBOOK_CONFIGURE_FLAGS=(
    --host="${GNU_TARGET}"
    --prefix="/usr"
    --enable-shared
    --disable-static
)
```

**cookbook_configure関数**:
```bash
function cookbook_configure {
    "${COOKBOOK_CONFIGURE}" "${COOKBOOK_CONFIGURE_FLAGS[@]}" "$@"
    "${COOKBOOK_MAKE}" -j "${COOKBOOK_MAKE_JOBS}"
    "${COOKBOOK_MAKE}" install DESTDIR="${COOKBOOK_STAGE}"
}
```

## データベース操作仕様

本機能ではデータベース操作は行わない（ファイルシステムとシェルコマンドのみ）。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | configureエラー | configureスクリプトがエラー終了 | フラグやsysrootを確認 |
| - | makeエラー | コンパイルエラー | ソースコードやパッチを確認 |
| - | installエラー | インストール先の問題 | 権限やパスを確認 |

### リトライ仕様

- TUIモードではユーザーにリトライ/スキップ/終了を選択させる

## トランザクション仕様

- stage.tmpへの一時ビルド後にstageへアトミックリネーム
- 失敗時はstage.tmpを削除

## パフォーマンス要件

- 並列makeによる高速化（COOKBOOK_MAKE_JOBS）
- 増分ビルド対応（build dirの再利用）

## セキュリティ考慮事項

- configureスクリプトの信頼性確認
- 環境変数の漏洩防止

## 備考

- COOKBOOK_CONFIGUREは${COOKBOOK_SOURCE}/configureがデフォルト
- pkg-config関連環境変数も自動設定
- autoreconfが必要な場合はsource.scriptで事前実行

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、Configureビルド設定を表現するデータ構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | recipe.rs | `src/recipe.rs` | BuildKind::Configure variantの定義 |

**読解のコツ**:
- `#[serde(tag = "template")]`によりtemplate値でビルドタイプが判定される
- template="configure"でBuildKind::Configureとしてデシリアライズされる

**主要処理フロー**:
- **107-112行目**: BuildKind::Configure variant定義
  - configureflags: Vec<String> - 追加フラグのリスト

#### Step 2: ビルド処理を理解する

ビルド処理のメインロジックを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | cook_build.rs | `src/cook/cook_build.rs` | build()関数のConfigure処理部分 |

**主要処理フロー**:
- **352-355行目**: Configureビルドスクリプトの生成
  - DYNAMIC_INITの呼び出し
  - configureflagsの追加
  - cookbook_configure関数の呼び出し

#### Step 3: スクリプト関数を理解する

cookbook_configure等のヘルパー関数を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | script.rs | `src/cook/script.rs` | BUILD_PRESCRIPT, cookbook_configure関数 |

**主要処理フロー**:
- **178-186行目**: COOKBOOK_CONFIGURE_FLAGS定義
- **188-193行目**: cookbook_configure関数
- **1-46行目** (SHARED_PRESCRIPT): DYNAMIC_INIT関数

### プログラム呼び出し階層図

```
build(recipe_dir, source_dir, target_dir, name, recipe, ...)
    │
    ├─ sysroot構築 (build_deps_dir)
    │   └─ pkgar::extract()
    │
    ├─ スクリプト生成
    │   ├─ BuildKind::Configure処理
    │   │   ├─ "DYNAMIC_INIT\n"
    │   │   ├─ flags_fn("COOKBOOK_CONFIGURE_FLAGS", configureflags)
    │   │   └─ "cookbook_configure"
    │   │
    │   └─ 環境変数設定
    │       ├─ TARGET / GNU_TARGET
    │       ├─ COOKBOOK_SOURCE
    │       ├─ COOKBOOK_SYSROOT
    │       ├─ PKG_CONFIG_*
    │       └─ CFLAGS / LDFLAGS
    │
    └─ スクリプト実行
        │
        ├─ BUILD_PRESCRIPT（環境設定）
        │   └─ COOKBOOK_CONFIGURE="${COOKBOOK_SOURCE}/configure"
        │   └─ COOKBOOK_CONFIGURE_FLAGS=(--host, --prefix, ...)
        │
        ├─ SHARED_PRESCRIPT（共有関数）
        │   └─ DYNAMIC_INIT()
        │       └─ COOKBOOK_CONFIGURE_FLAGS更新
        │
        ├─ configureflags追加
        │   └─ COOKBOOK_CONFIGURE_FLAGS+=("flag1" "flag2" ...)
        │
        ├─ cookbook_configure()
        │   ├─ ${COOKBOOK_CONFIGURE} ${COOKBOOK_CONFIGURE_FLAGS[@]}
        │   ├─ make -j N
        │   └─ make install DESTDIR=...
        │
        └─ BUILD_POSTSCRIPT（後処理）
            ├─ strip
            └─ .la削除
```

### データフロー図

```
[入力]                       [処理]                              [出力]

recipe.toml
  └─ build.template=configure ▶ BuildKind::Configure判定 ──▶ スクリプト生成
  └─ build.configureflags

source/
  └─ configure ─────────────▶ configure実行 ───────────────▶ Makefile
  └─ Makefile.in                   │
                                   │
sysroot/                           │
  └─ include/*.h ───────────▶ make実行 ─────────────────────▶ *.o, *.a, バイナリ
  └─ lib/*.so                      │
                                   │
                                   ▼
                            make install DESTDIR ──────────▶ stage/
                                   │
                                   ▼
                            BUILD_POSTSCRIPT ──────────────▶ strip済み成果物
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| cook_build.rs | `src/cook/cook_build.rs` | ソース | ビルドのメインロジック |
| recipe.rs | `src/recipe.rs` | ソース | BuildKind::Configure定義 |
| script.rs | `src/cook/script.rs` | ソース | BUILD_PRESCRIPT, cookbook_configure関数 |
| cookbook_redoxer.rs | `src/bin/cookbook_redoxer.rs` | ソース | クロスコンパイル環境設定 |
| recipe.toml | 各レシピディレクトリ | 設定 | build.template="configure"設定 |
| configure | source/ | スクリプト | autotoolsが生成したconfigureスクリプト |
