# 機能設計書 11-CMakeビルド

## 概要

本ドキュメントは、Cookbook（Redox OSパッケージビルドシステム）におけるCMakeビルド機能の設計を記述する。CMakeプロジェクトをNinjaビルドシステムと組み合わせてクロスコンパイルする機能を提供する。

### 本機能の処理概要

CMakeビルド機能は、CMakeを使用するプロジェクト（C/C++ライブラリやアプリケーション）をRedox OS向けにクロスコンパイルするための機能である。

**業務上の目的・背景**：多くのオープンソースプロジェクトはCMakeをビルドシステムとして採用している。Redox OSエコシステムでこれらのプロジェクトを利用するためには、CMakeベースのビルドをサポートする必要がある。本機能により、既存のCMakeプロジェクトを最小限の変更でRedox OS向けにポーティングできる。

**機能の利用シーン**：recipe.tomlで`template = "cmake"`を指定したパッケージのビルド時に自動的に呼び出される。開発者はcmakeflagsでカスタムオプションを追加でき、動的リンクビルドや静的リンクビルドの切り替えも可能。

**主要な処理内容**：
1. CMakeツールチェインファイル（cross_file.cmake）の自動生成
2. クロスコンパイル用の環境変数設定（AR、CC、CXX等）
3. CMakeの設定実行（Ninjaジェネレータ使用）
4. Ninjaによるパラレルビルド実行
5. ビルド成果物のステージディレクトリへのインストール

**関連システム・外部連携**：CMakeコマンド、Ninjaビルドシステム、GCCクロスコンパイラツールチェイン（x86_64-unknown-redox-gcc等）と連携する。

**権限による制御**：特別な権限制御はなし。ビルドはユーザー権限で実行される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 4 | repo cookコマンド画面 | API連携 | template=cmakeでのCMakeプロジェクトビルド |

## 機能種別

ビルド処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| template | String | Yes | "cmake"を指定 | "cmake"のみ許可 |
| cmakeflags | Vec<String> | No | CMakeに渡す追加フラグ | - |
| COOKBOOK_SOURCE | 環境変数 | Yes | ソースディレクトリのパス | 存在するディレクトリ |
| COOKBOOK_STAGE | 環境変数 | Yes | ステージディレクトリのパス | 書き込み可能 |
| COOKBOOK_SYSROOT | 環境変数 | Yes | sysrootディレクトリのパス | 存在するディレクトリ |
| COOKBOOK_MAKE_JOBS | 環境変数 | No | 並列ビルド数 | 正の整数 |
| TARGET | 環境変数 | Yes | ターゲットトリプル | 有効なターゲット文字列 |
| GNU_TARGET | 環境変数 | Yes | GNUスタイルのターゲット | 有効なターゲット文字列 |

### 入力データソース

- recipe.toml: ビルドテンプレートとフラグの指定
- ソースディレクトリ: CMakeLists.txtを含むプロジェクト
- sysroot: 依存ライブラリのヘッダとライブラリファイル

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| cross_file.cmake | File | CMakeツールチェインファイル |
| ビルド成果物 | Files | コンパイルされたバイナリ・ライブラリ |
| インストール済みファイル | Files | DESTDIR配下に配置されたファイル |

### 出力先

- ビルドディレクトリ: `{recipe_dir}/target/{target}/build/`
- ステージディレクトリ: `{recipe_dir}/target/{target}/stage/`

## 処理フロー

### 処理シーケンス

```
1. ツールチェインファイル生成
   └─ cross_file.cmakeにクロスコンパイル設定を書き出す
2. システム名判定
   └─ TARGETからLinux/UnixPathsを判定
3. CMake設定実行
   └─ cmake -DCMAKE_TOOLCHAIN_FILE=cross_file.cmake -GNinja ...
4. Ninjaビルド実行
   └─ ninja -j{COOKBOOK_MAKE_JOBS}
5. インストール実行
   └─ DESTDIR={COOKBOOK_STAGE} ninja install
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[cross_file.cmake生成]
    B --> C{TARGETにlinux含む?}
    C -->|Yes| D[SYSTEM_NAME=Linux]
    C -->|No| E[SYSTEM_NAME=UnixPaths]
    D --> F[CMake設定実行]
    E --> F
    F --> G[Ninjaビルド実行]
    G --> H[ninja install実行]
    H --> I[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-11-01 | デフォルト静的リンク | COOKBOOK_CMAKE_FLAGSのデフォルトは静的リンク設定 | DYNAMIC_INIT未呼び出し時 |
| BR-11-02 | 動的リンク切替 | DYNAMIC_INIT呼び出し時は共有ライブラリビルド | DYNAMIC_INIT関数呼び出し時 |
| BR-11-03 | Ninjaジェネレータ固定 | CMakeは常にNinjaジェネレータを使用 | 全ビルド |
| BR-11-04 | インストールプレフィックス | インストール先は常に/usr | 全ビルド |

### 計算ロジック

CMakeフラグのマージ:
```
最終フラグ = COOKBOOK_CMAKE_FLAGS + cmakeflags(recipe.toml)
```

## データベース操作仕様

該当なし（ファイルシステム操作のみ）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-CMAKE-01 | CMake設定失敗 | CMakeLists.txtの構文エラー | ソースコードの修正 |
| E-CMAKE-02 | 依存ライブラリ不足 | find_packageで依存が見つからない | sysrootに依存を追加 |
| E-CMAKE-03 | ビルド失敗 | コンパイルエラー | ソースコードの修正 |
| E-CMAKE-04 | インストール失敗 | 権限エラー等 | ステージディレクトリの確認 |

### リトライ仕様

自動リトライなし。エラー時はTUIモードでリトライ/スキップ/終了を選択可能。

## トランザクション仕様

ファイルシステムレベルでのアトミック性:
- ビルド成果物は一時ディレクトリで生成後、stage.tmpからstageにアトミックにリネーム

## パフォーマンス要件

- COOKBOOK_MAKE_JOBSで指定された並列数でビルド
- デフォルトはシステムのCPUコア数

## セキュリティ考慮事項

- クロスコンパイル時、ホストシステムのライブラリとの混在を防ぐためCMAKE_FIND_ROOT_PATH_MODE設定
- PKG_CONFIG_SYSROOT_DIRでpkg-configの参照先を制限

## 備考

- CC_WRAPPER環境変数設定時はCMake_C_COMPILER_LAUNCHERも設定される（ccache等のサポート）
- CMakeの警告は-Wno-devで抑制される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、CMakeビルドの設定がどのように定義されるかを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | recipe.rs | `src/recipe.rs` | BuildKind::Cmakeの定義（113-118行目）を確認 |

**読解のコツ**: `#[serde(tag = "template")]`アトリビュートにより、TOMLの`template = "cmake"`がBuildKind::Cmakeにマッピングされる。

#### Step 2: エントリーポイントを理解する

ビルド処理のエントリーポイントを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | cook_build.rs | `src/cook/cook_build.rs` | build関数（170行目〜）でBuildKind::Cmakeの処理分岐を確認 |

**主要処理フロー**:
1. **342-367行目**: BuildKindに応じたスクリプト生成。Cmake用は356-359行目
2. **418-422行目**: BUILD_PRESCRIPT + SHARED_PRESCRIPT + script + BUILD_POSTSCRIPTの結合
3. **422行目**: run_command_stdinでbashにスクリプトを渡して実行

#### Step 3: CMakeビルドスクリプトを理解する

シェルスクリプトとしてのCMakeビルド処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | script.rs | `src/cook/script.rs` | cookbook_cmake関数の定義（194-245行目） |

**主要処理フロー**:
- **202-206行目**: TARGETからシステム名（Linux/UnixPaths）を判定
- **207-221行目**: cross_file.cmakeのツールチェインファイル生成
- **223-227行目**: CC_WRAPPER（ccache等）のサポート
- **229-244行目**: cmake設定、ninja実行、ninja install実行

#### Step 4: 動的リンク設定を理解する

DYNAMIC_INIT関数による動的リンクビルドの設定を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | script.rs | `src/cook/script.rs` | DYNAMIC_INIT関数内のCOOKBOOK_CMAKE_FLAGS設定（27-32行目） |

**主要処理フロー**:
- **27-32行目**: 動的リンクビルド用のCMakeフラグ設定
- **196-200行目**: デフォルト（静的リンク）のCMAKE_FLAGS設定

### プログラム呼び出し階層図

```
repo cook (CLI)
    │
    ├─ CookRecipe::from_name()
    │      └─ Recipe::new() [recipe.rs:207]
    │
    └─ cook_build::build() [cook_build.rs:170]
           │
           ├─ get_stage_dirs() [cook_build.rs:483]
           │
           ├─ build_deps_dir() (sysroot構築) [cook_build.rs:511]
           │
           └─ run_command_stdin() [fs.rs:220]
                  └─ bash -e スクリプト実行
                         │
                         ├─ DYNAMIC_INIT() [script.rs:3-46]
                         │
                         └─ cookbook_cmake() [script.rs:201-245]
                                │
                                ├─ cross_file.cmake生成
                                ├─ cmake実行
                                ├─ ninja実行
                                └─ ninja install実行
```

### データフロー図

```
[入力]                    [処理]                         [出力]

recipe.toml ──────────▶ BuildKind::Cmake解析 ──────────▶ スクリプト生成
  template=cmake
  cmakeflags=...

                              │
                              ▼

COOKBOOK_SOURCE ─────▶ cookbook_cmake() ───────────────▶ cross_file.cmake
CMakeLists.txt                │
                              ▼

COOKBOOK_SYSROOT ────▶ cmake -DCMAKE_TOOLCHAIN_FILE ──▶ Makefiles/build.ninja
依存ライブラリ                │
                              ▼

                         ninja -j{N} ─────────────────▶ バイナリ/ライブラリ
                              │
                              ▼

                         ninja install ────────────────▶ COOKBOOK_STAGE/usr/
                                                         ├─ bin/
                                                         ├─ lib/
                                                         └─ include/
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| recipe.rs | `src/recipe.rs` | ソース | BuildKind::Cmakeの型定義 |
| cook_build.rs | `src/cook/cook_build.rs` | ソース | ビルド処理のメインロジック |
| script.rs | `src/cook/script.rs` | ソース | CMakeビルドスクリプト定義 |
| fs.rs | `src/cook/fs.rs` | ソース | ファイル操作、コマンド実行ユーティリティ |
| package.rs | `src/cook/package.rs` | ソース | パッケージターゲット判定 |
