# 機能設計書 12-Mesonビルド

## 概要

本ドキュメントは、Cookbook（Redox OSパッケージビルドシステム）におけるMesonビルド機能の設計を記述する。MesonプロジェクトをNinjaビルドシステムと組み合わせてクロスコンパイルする機能を提供する。

### 本機能の処理概要

Mesonビルド機能は、Mesonを使用するプロジェクト（主にGNOME関連のC/C++ライブラリやアプリケーション）をRedox OS向けにクロスコンパイルするための機能である。

**業務上の目的・背景**：MesonはCMakeやAutotoolsに代わる現代的なビルドシステムとして普及が進んでおり、特にGNOMEエコシステムのプロジェクトで広く採用されている。Redox OSでこれらのプロジェクトをビルドするためには、Mesonのクロスコンパイルをサポートする必要がある。

**機能の利用シーン**：recipe.tomlで`template = "meson"`を指定したパッケージのビルド時に自動的に呼び出される。開発者はmesonflagsでカスタムオプションを追加でき、動的リンクビルドや静的リンクビルドの切り替えも可能。

**主要な処理内容**：
1. Mesonクロスファイル（cross_file.txt）の自動生成
2. 環境変数のクリア（Mesonがクロスファイルの設定を優先するため）
3. Mesonの設定実行（meson setup）
4. Ninjaによるパラレルビルド実行
5. ビルド成果物のステージディレクトリへのインストール

**関連システム・外部連携**：Mesonコマンド、Ninjaビルドシステム、GCCクロスコンパイラツールチェイン、pkg-configと連携する。

**権限による制御**：特別な権限制御はなし。ビルドはユーザー権限で実行される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 4 | repo cookコマンド画面 | API連携 | template=mesonでのMesonプロジェクトビルド |

## 機能種別

ビルド処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| template | String | Yes | "meson"を指定 | "meson"のみ許可 |
| mesonflags | Vec<String> | No | Mesonに渡す追加フラグ | - |
| COOKBOOK_SOURCE | 環境変数 | Yes | ソースディレクトリのパス | 存在するディレクトリ |
| COOKBOOK_STAGE | 環境変数 | Yes | ステージディレクトリのパス | 書き込み可能 |
| COOKBOOK_SYSROOT | 環境変数 | Yes | sysrootディレクトリのパス | 存在するディレクトリ |
| COOKBOOK_MAKE_JOBS | 環境変数 | No | 並列ビルド数 | 正の整数 |
| TARGET | 環境変数 | Yes | ターゲットトリプル | 有効なターゲット文字列 |
| CC, CXX, AR等 | 環境変数 | Yes | コンパイラ・ツール設定 | 実行可能コマンド |

### 入力データソース

- recipe.toml: ビルドテンプレートとフラグの指定
- ソースディレクトリ: meson.buildを含むプロジェクト
- sysroot: 依存ライブラリのヘッダとライブラリファイル

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| cross_file.txt | File | Mesonクロスコンパイルファイル |
| ビルド成果物 | Files | コンパイルされたバイナリ・ライブラリ |
| インストール済みファイル | Files | DESTDIR配下に配置されたファイル |

### 出力先

- ビルドディレクトリ: `{recipe_dir}/target/{target}/build/`
- ステージディレクトリ: `{recipe_dir}/target/{target}/stage/`

## 処理フロー

### 処理シーケンス

```
1. クロスファイル生成
   └─ cross_file.txtに[binaries], [host_machine], [paths], [properties]セクション生成
2. 環境変数クリア
   └─ AR, CC, CXX等をunsetしてMesonにクロスファイルを優先させる
3. Meson設定実行
   └─ meson setup --cross-file cross_file.txt ...
4. Ninjaビルド実行
   └─ ninja -j{COOKBOOK_MAKE_JOBS}
5. インストール実行
   └─ DESTDIR={COOKBOOK_STAGE} ninja install
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[cross_file.txt生成]
    B --> C[[binaries]セクション生成]
    C --> D[[host_machine]セクション生成]
    D --> E[[paths]セクション生成]
    E --> F[[properties]セクション生成]
    F --> G[環境変数クリア]
    G --> H[meson setup実行]
    H --> I[ninja実行]
    I --> J[ninja install実行]
    J --> K[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-12-01 | デフォルト静的リンク | COOKBOOK_MESON_FLAGSのデフォルトは静的ライブラリ設定 | DYNAMIC_INIT未呼び出し時 |
| BR-12-02 | 動的リンク切替 | DYNAMIC_INIT呼び出し時は共有ライブラリビルド | DYNAMIC_INIT関数呼び出し時 |
| BR-12-03 | 環境変数優先解除 | クロスファイル使用のため環境変数をunset | 全ビルド |
| BR-12-04 | リリースビルド | buildtypeは常にrelease | 全ビルド |
| BR-12-05 | ストリップ有効 | --stripオプションでシンボル削除 | 全ビルド |

### 計算ロジック

Mesonフラグのマージ:
```
最終フラグ = COOKBOOK_MESON_FLAGS + mesonflags(recipe.toml)
```

## データベース操作仕様

該当なし（ファイルシステム操作のみ）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-MESON-01 | Meson設定失敗 | meson.buildの構文エラー | ソースコードの修正 |
| E-MESON-02 | 依存ライブラリ不足 | dependency()で依存が見つからない | sysrootに依存を追加 |
| E-MESON-03 | ビルド失敗 | コンパイルエラー | ソースコードの修正 |
| E-MESON-04 | インストール失敗 | 権限エラー等 | ステージディレクトリの確認 |

### リトライ仕様

自動リトライなし。エラー時はTUIモードでリトライ/スキップ/終了を選択可能。

## トランザクション仕様

ファイルシステムレベルでのアトミック性:
- ビルド成果物は一時ディレクトリで生成後、stage.tmpからstageにアトミックにリネーム

## パフォーマンス要件

- COOKBOOK_MAKE_JOBSで指定された並列数でビルド
- --wrap-mode nofallbackで外部依存のダウンロードを防止

## セキュリティ考慮事項

- sys_rootプロパティでsysrootを明示的に指定
- needs_exe_wrapper = trueでクロスコンパイル時のテスト実行を制御

## 備考

- GLib関連ツール（glib-compile-resources, glib-compile-schemas）はホストシステムのものを使用
- llvm-configはターゲット用のものを指定

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、Mesonビルドの設定がどのように定義されるかを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | recipe.rs | `src/recipe.rs` | BuildKind::Mesonの定義（119-124行目）を確認 |

**読解のコツ**: `#[serde(tag = "template")]`アトリビュートにより、TOMLの`template = "meson"`がBuildKind::Mesonにマッピングされる。mesonflagsはVec<String>として格納される。

#### Step 2: エントリーポイントを理解する

ビルド処理のエントリーポイントを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | cook_build.rs | `src/cook/cook_build.rs` | build関数（170行目〜）でBuildKind::Mesonの処理分岐を確認 |

**主要処理フロー**:
1. **342-367行目**: BuildKindに応じたスクリプト生成。Meson用は360-363行目
2. **418-422行目**: BUILD_PRESCRIPT + SHARED_PRESCRIPT + script + BUILD_POSTSCRIPTの結合
3. **422行目**: run_command_stdinでbashにスクリプトを渡して実行

#### Step 3: Mesonビルドスクリプトを理解する

シェルスクリプトとしてのMesonビルド処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | script.rs | `src/cook/script.rs` | cookbook_meson関数の定義（247-305行目） |

**主要処理フロー**:
- **256-264行目**: [binaries]セクション生成（c, cpp, ar, strip, pkg-config, llvm-config, glib-*）
- **266-270行目**: [host_machine]セクション生成（system, cpu_family, cpu, endian）
- **272-275行目**: [paths]セクション生成（prefix, libdir, bindir）
- **277-282行目**: [properties]セクション生成（needs_exe_wrapper, sys_root, *_args）
- **284-295行目**: 環境変数のunset処理
- **297-304行目**: meson setup, ninja, ninja install実行

#### Step 4: 動的リンク設定を理解する

DYNAMIC_INIT関数による動的リンクビルドの設定を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | script.rs | `src/cook/script.rs` | DYNAMIC_INIT関数内のCOOKBOOK_MESON_FLAGS設定（34-40行目） |

**主要処理フロー**:
- **34-40行目**: 動的リンクビルド用のMesonフラグ設定（-Ddefault_library=shared）
- **247-253行目**: デフォルト（静的リンク）のMESON_FLAGS設定（-Ddefault_library=static）

### プログラム呼び出し階層図

```
repo cook (CLI)
    │
    ├─ CookRecipe::from_name()
    │      └─ Recipe::new() [recipe.rs:207]
    │
    └─ cook_build::build() [cook_build.rs:170]
           │
           ├─ get_stage_dirs() [cook_build.rs:483]
           │
           ├─ build_deps_dir() (sysroot構築) [cook_build.rs:511]
           │
           └─ run_command_stdin() [fs.rs:220]
                  └─ bash -e スクリプト実行
                         │
                         ├─ DYNAMIC_INIT() [script.rs:3-46]
                         │
                         └─ cookbook_meson() [script.rs:255-305]
                                │
                                ├─ cross_file.txt生成
                                ├─ 環境変数unset
                                ├─ meson setup実行
                                ├─ ninja実行
                                └─ ninja install実行
```

### データフロー図

```
[入力]                    [処理]                         [出力]

recipe.toml ──────────▶ BuildKind::Meson解析 ─────────▶ スクリプト生成
  template=meson
  mesonflags=...

                              │
                              ▼

CC, CXX, AR, ... ────▶ cookbook_meson() ──────────────▶ cross_file.txt
環境変数                      │                          [binaries]
                              │                          [host_machine]
                              │                          [paths]
                              │                          [properties]
                              ▼

COOKBOOK_SOURCE ─────▶ meson setup --cross-file ─────▶ build.ninja
meson.build                   │
                              ▼

                         ninja -j{N} ─────────────────▶ バイナリ/ライブラリ
                              │
                              ▼

                         ninja install ────────────────▶ COOKBOOK_STAGE/usr/
                                                         ├─ bin/
                                                         ├─ lib/
                                                         └─ share/
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| recipe.rs | `src/recipe.rs` | ソース | BuildKind::Mesonの型定義 |
| cook_build.rs | `src/cook/cook_build.rs` | ソース | ビルド処理のメインロジック |
| script.rs | `src/cook/script.rs` | ソース | Mesonビルドスクリプト定義 |
| fs.rs | `src/cook/fs.rs` | ソース | ファイル操作、コマンド実行ユーティリティ |
| package.rs | `src/cook/package.rs` | ソース | パッケージターゲット判定 |
