# 機能設計書 13-カスタムビルド

## 概要

本ドキュメントは、Cookbook（Redox OSパッケージビルドシステム）におけるカスタムビルド機能の設計を記述する。定型テンプレート（Cargo、Configure、CMake、Meson）に当てはまらないプロジェクトを任意のシェルスクリプトでビルドする機能を提供する。

### 本機能の処理概要

カスタムビルド機能は、標準的なビルドシステムに対応しないプロジェクトや、特殊なビルド手順が必要なプロジェクトを柔軟にビルドするための機能である。

**業務上の目的・背景**：すべてのオープンソースプロジェクトが標準的なビルドシステムを使用しているわけではない。独自のMakefile、シェルスクリプト、または複数のビルドステップを組み合わせる必要があるプロジェクトも多く存在する。本機能により、開発者はrecipe.toml内に任意のビルドスクリプトを記述でき、あらゆるプロジェクトをRedox OSにポーティング可能となる。

**機能の利用シーン**：recipe.tomlで`template = "custom"`を指定し、`script`フィールドにビルドコマンドを記述する。既存のテンプレート関数（cookbook_configure、cookbook_cmake等）を組み合わせることも、完全に独自のビルドコマンドを使用することも可能。

**主要な処理内容**：
1. recipe.tomlからカスタムスクリプトを読み込み
2. 共通プレスクリプト（BUILD_PRESCRIPT、SHARED_PRESCRIPT）の付加
3. クロスコンパイル環境変数の設定
4. カスタムスクリプトの実行
5. 共通ポストスクリプト（BUILD_POSTSCRIPT）の実行

**関連システム・外部連携**：スクリプト内で使用される任意のビルドツール（make、gcc、シェルコマンド等）と連携する。

**権限による制御**：特別な権限制御はなし。ビルドはユーザー権限で実行される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 4 | repo cookコマンド画面 | API連携 | template=customでのカスタムスクリプトビルド |

## 機能種別

ビルド処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| template | String | Yes | "custom"を指定 | "custom"のみ許可 |
| script | String | Yes | 実行するシェルスクリプト | 空でないこと |
| COOKBOOK_SOURCE | 環境変数 | Yes | ソースディレクトリのパス | 存在するディレクトリ |
| COOKBOOK_STAGE | 環境変数 | Yes | ステージディレクトリのパス | 書き込み可能 |
| COOKBOOK_SYSROOT | 環境変数 | Yes | sysrootディレクトリのパス | 存在するディレクトリ |
| COOKBOOK_BUILD | 環境変数 | Yes | ビルドディレクトリのパス | 書き込み可能 |
| TARGET | 環境変数 | Yes | ターゲットトリプル | 有効なターゲット文字列 |
| GNU_TARGET | 環境変数 | Yes | GNUスタイルのターゲット | 有効なターゲット文字列 |

### 入力データソース

- recipe.toml: テンプレート指定とカスタムスクリプト
- ソースディレクトリ: ビルド対象のプロジェクト
- sysroot: 依存ライブラリのヘッダとライブラリファイル

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| ビルド成果物 | Files | スクリプトが生成するバイナリ・ライブラリ等 |
| インストール済みファイル | Files | COOKBOOK_STAGE配下に配置されたファイル |

### 出力先

- ビルドディレクトリ: `{recipe_dir}/target/{target}/build/`
- ステージディレクトリ: `{recipe_dir}/target/{target}/stage/`

## 処理フロー

### 処理シーケンス

```
1. スクリプト準備
   └─ BUILD_PRESCRIPT + SHARED_PRESCRIPT + customスクリプト + BUILD_POSTSCRIPTを結合
2. 環境変数設定
   └─ クロスコンパイル用の環境変数（CC、CFLAGS、LDFLAGS等）を設定
3. cookbook_redoxer実行
   └─ クロスコンパイル環境でbashを起動
4. スクリプト実行
   └─ 結合されたスクリプトをbashに渡して実行
5. ポスト処理
   └─ バイナリストリップ、不要ファイル削除等
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[スクリプト結合]
    B --> C[環境変数設定]
    C --> D{Redox上で実行?}
    D -->|Yes| E[bash -e スクリプト]
    D -->|No| F[cookbook_redoxer env bash -e]
    E --> G[カスタムスクリプト実行]
    F --> G
    G --> H[BUILD_POSTSCRIPT実行]
    H --> I[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-13-01 | スクリプト必須 | customテンプレートではscriptフィールドが必須 | template=custom時 |
| BR-13-02 | 共通関数利用可 | BUILD_PRESCRIPT内の関数（cookbook_*）が利用可能 | 全カスタムビルド |
| BR-13-03 | 環境変数継承 | COOKBOOK_*環境変数がスクリプト内で使用可能 | 全カスタムビルド |
| BR-13-04 | エラー即座終了 | bash -eにより、コマンドエラー時は即座に終了 | 全カスタムビルド |
| BR-13-05 | verboseモード | COOKBOOK_VERBOSE設定時は-exオプション使用 | verbose設定時 |

### 計算ロジック

スクリプト結合順序:
```
実行スクリプト = BUILD_PRESCRIPT + "\n" + SHARED_PRESCRIPT + "\n" + script + "\n" + BUILD_POSTSCRIPT
```

## データベース操作仕様

該当なし（ファイルシステム操作のみ）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-CUSTOM-01 | スクリプト構文エラー | bash構文エラー | スクリプトの修正 |
| E-CUSTOM-02 | コマンド不存在 | スクリプト内のコマンドが見つからない | 必要なツールをインストール |
| E-CUSTOM-03 | ビルド失敗 | makeやコンパイルエラー | ソースコードの修正 |
| E-CUSTOM-04 | 権限エラー | ファイル操作権限不足 | 権限の確認・修正 |

### リトライ仕様

自動リトライなし。エラー時はTUIモードでリトライ/スキップ/終了を選択可能。

## トランザクション仕様

ファイルシステムレベルでのアトミック性:
- ビルド成果物は一時ディレクトリで生成後、stage.tmpからstageにアトミックにリネーム

## パフォーマンス要件

- COOKBOOK_MAKE_JOBS変数でスクリプト内からmake等の並列数を制御可能
- スクリプトの実行時間はプロジェクトと記述内容に依存

## セキュリティ考慮事項

- スクリプトはユーザー権限で実行される
- cookbook_redoxer経由でクロスコンパイル環境が分離される
- ホストシステムへの影響を最小限にするため、作業は指定ディレクトリ内に限定

## 備考

- BUILD_PRESCRIPT内でDYNAMIC_INIT、DYNAMIC_STATIC_INIT関数が利用可能
- cookbook_configure、cookbook_cmake、cookbook_meson関数も呼び出し可能
- 環境変数COOKBOOK_OFFLINEでオフラインビルドの判定が可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、カスタムビルドの設定がどのように定義されるかを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | recipe.rs | `src/recipe.rs` | BuildKind::Customの定義（125-127行目）を確認 |

**読解のコツ**: `#[serde(tag = "template")]`アトリビュートにより、TOMLの`template = "custom"`がBuildKind::Customにマッピングされる。scriptフィールドは必須のString型。

#### Step 2: エントリーポイントを理解する

ビルド処理のエントリーポイントを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | cook_build.rs | `src/cook/cook_build.rs` | build関数（170行目〜）でBuildKind::Customの処理分岐を確認 |

**主要処理フロー**:
1. **342-367行目**: BuildKindに応じたスクリプト生成。Custom用は364行目でscript.clone()
2. **369-416行目**: コマンド構築（cookbook_redoxer経由またはbash直接）
3. **418-422行目**: スクリプト結合と実行

#### Step 3: プレスクリプトを理解する

BUILD_PRESCRIPTで提供される環境と関数を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | script.rs | `src/cook/script.rs` | BUILD_PRESCRIPTの定義（81-306行目） |

**主要処理フロー**:
- **82-90行目**: PATH、LD_LIBRARY_PATHの設定
- **92-126行目**: ビルドフラグ（CFLAGS、LDFLAGS、RUSTFLAGS等）の設定
- **134-144行目**: cookbook_cargo関数
- **178-192行目**: cookbook_configure関数
- **194-245行目**: cookbook_cmake関数
- **247-305行目**: cookbook_meson関数

#### Step 4: ポストスクリプトを理解する

BUILD_POSTSCRIPTで行われる後処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | script.rs | `src/cook/script.rs` | BUILD_POSTSCRIPTの定義（308-344行目） |

**主要処理フロー**:
- **309-316行目**: バイナリのストリップ処理
- **318-325行目**: libtool .laファイルの削除
- **327-334行目**: cargoインストールファイルの削除
- **336-343行目**: AppStreamメタデータへのpkgname追加

### プログラム呼び出し階層図

```
repo cook (CLI)
    │
    ├─ CookRecipe::from_name()
    │      └─ Recipe::new() [recipe.rs:207]
    │
    └─ cook_build::build() [cook_build.rs:170]
           │
           ├─ get_stage_dirs() [cook_build.rs:483]
           │
           ├─ build_deps_dir() (sysroot構築) [cook_build.rs:511]
           │
           └─ run_command_stdin() [fs.rs:220]
                  └─ cookbook_redoxer env bash -e OR bash -e
                         │
                         ├─ BUILD_PRESCRIPT [script.rs:81]
                         │      └─ 環境変数設定、ヘルパー関数定義
                         │
                         ├─ SHARED_PRESCRIPT [script.rs:1]
                         │      └─ DYNAMIC_INIT等の共通関数
                         │
                         ├─ custom script (recipe.toml)
                         │      └─ ユーザー定義ビルドコマンド
                         │
                         └─ BUILD_POSTSCRIPT [script.rs:308]
                                └─ ストリップ、ファイル削除等
```

### データフロー図

```
[入力]                    [処理]                         [出力]

recipe.toml ──────────▶ BuildKind::Custom解析 ────────▶ script取得
  template=custom
  script=...

                              │
                              ▼

BUILD_PRESCRIPT ─────▶ スクリプト結合 ─────────────────▶ 実行スクリプト
SHARED_PRESCRIPT            │
custom script               │
BUILD_POSTSCRIPT            │
                              ▼

COOKBOOK_SOURCE ─────▶ bash -e スクリプト実行 ─────────▶ ビルド成果物
COOKBOOK_SYSROOT            │
COOKBOOK_BUILD              │
                              ▼

                         BUILD_POSTSCRIPT ─────────────▶ COOKBOOK_STAGE/
                         (ストリップ、クリーンアップ)      ├─ bin/
                                                         ├─ lib/
                                                         └─ usr/
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| recipe.rs | `src/recipe.rs` | ソース | BuildKind::Customの型定義 |
| cook_build.rs | `src/cook/cook_build.rs` | ソース | ビルド処理のメインロジック |
| script.rs | `src/cook/script.rs` | ソース | プレ/ポストスクリプト定義 |
| fs.rs | `src/cook/fs.rs` | ソース | コマンド実行ユーティリティ |
| cookbook_redoxer.rs | `src/bin/cookbook_redoxer.rs` | ソース | クロスコンパイル環境設定 |
