# 機能設計書 15-自動依存関係検出

## 概要

本ドキュメントは、Cookbook（Redox OSパッケージビルドシステム）における自動依存関係検出機能の設計を記述する。ELFバイナリの動的リンク情報を解析し、必要なライブラリパッケージを自動的に検出する機能を提供する。

### 本機能の処理概要

自動依存関係検出機能（auto_deps）は、ビルド完了後のELFバイナリを解析し、DT_NEEDED（動的リンク必須ライブラリ）エントリから実行時に必要なライブラリを特定し、それらを提供するパッケージを依存関係として自動登録する機能である。

**業務上の目的・背景**：動的リンクされたバイナリは、実行時に必要なライブラリが存在しなければ動作しない。手動で依存関係を管理すると漏れが生じやすく、また依存バージョンの変更時に追従が難しい。本機能により、ビルド成果物から自動的に依存関係を検出することで、正確かつ最新の依存情報を維持できる。

**機能の利用シーン**：`repo cook`コマンドでパッケージをビルドした後、パッケージング前に自動的に呼び出される。検出された依存関係はstage.tomlに記録され、パッケージのメタデータとして配布される。

**主要な処理内容**：
1. ステージディレクトリ内のELFファイルを走査
2. 各ELFファイルのDT_NEEDEDエントリを抽出
3. 依存パッケージのpkgarアーカイブからライブラリファイルを検索
4. ライブラリを提供するパッケージを依存関係として登録
5. 静的リンクパッケージの依存関係も考慮

**関連システム・外部連携**：objectクレート（ELF解析）、pkgarライブラリ（パッケージアーカイブ読み取り）と連携する。

**権限による制御**：特別な権限制御はなし。ファイル読み取り権限のみ必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 4 | repo cookコマンド画面 | API連携 | ELFバイナリからの動的リンク依存関係検出 |

## 機能種別

データ解析処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| stage_dirs | &[PathBuf] | Yes | ステージディレクトリのパスリスト | 存在するディレクトリ |
| target_dir | &Path | Yes | ターゲットディレクトリのパス | 存在するディレクトリ |
| dep_pkgars | &BTreeSet<(PackageName, PathBuf)> | Yes | 依存パッケージとpkgarパス | 空でも可 |
| logger | &PtyOut | Yes | ログ出力先 | - |

### 入力データソース

- ステージディレクトリ: ビルド成果物（ELFバイナリ、共有ライブラリ）
- 依存パッケージのpkgar: ライブラリ提供元の検索用
- build/id_ed25519.pub.toml: pkgar検証用公開鍵

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| auto_deps | BTreeSet<PackageName> | 検出された依存パッケージ名 |
| auto_deps.toml | File | キャッシュ用依存関係ファイル |

### 出力先

- メモリ: BTreeSet<PackageName>
- ファイル: `{target_dir}/auto_deps.toml`

## 処理フロー

### 処理シーケンス

```
1. 検索対象ディレクトリの初期化
   └─ usr/bin, usr/games, usr/lib, usr/libexecを検索キューに追加
2. ディレクトリ再帰走査
   └─ 各ディレクトリ内のファイルを収集（訪問済みチェックで無限ループ防止）
3. ELFファイル解析
   └─ objectクレートでELFを解析し、DT_NEEDEDを抽出
4. プリインストール除外
   └─ libc.so.6, libgcc_s.so.1, libstdc++.so.6は除外
5. 依存パッケージ検索
   └─ dep_pkgarsの各pkgarを展開し、ライブラリ提供元を特定
6. 静的パッケージ依存解析
   └─ 動的依存以外のビルド依存からも実行時依存を収集
7. 結果キャッシュ
   └─ auto_deps.tomlに保存
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[キャッシュチェック]
    B -->|キャッシュあり| C[キャッシュから読み込み]
    B -->|キャッシュなし| D[検索ディレクトリ初期化]
    C --> Z[終了]
    D --> E[ディレクトリ再帰走査]
    E --> F[ELFファイル収集]
    F --> G{次のファイルあり?}
    G -->|Yes| H[ELF解析/DT_NEEDED抽出]
    H --> I[プリインストール除外]
    I --> G
    G -->|No| J[pkgarからライブラリ検索]
    J --> K[依存パッケージ特定]
    K --> L[静的パッケージ依存解析]
    L --> M[auto_deps.toml保存]
    M --> Z
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-15-01 | プリインストール除外 | libc.so.6, libgcc_s.so.1, libstdc++.so.6は自動依存から除外 | 常時 |
| BR-15-02 | キャッシュ利用 | auto_deps.tomlが存在し、stageより新しい場合は再解析しない | キャッシュ有効時 |
| BR-15-03 | 無限ループ防止 | シンボリックリンクによるループを訪問済みセットで検出 | ディレクトリ走査時 |
| BR-15-04 | 静的依存包含 | 動的依存で検出されなかったビルド依存のpackage.depsも含める | 全ビルド |
| BR-15-05 | ライブラリパス検索 | lib/とusr/lib/の両方を検索 | pkgar解析時 |

### 計算ロジック

依存関係マージ:
```
最終auto_deps = 動的リンク依存 ∪ 静的パッケージ依存
```

## データベース操作仕様

該当なし（ファイルシステム操作のみ）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-AUTODEP-01 | ELF解析失敗 | 破損したELFファイル | ビルド結果の確認 |
| E-AUTODEP-02 | pkgar読み取り失敗 | 依存パッケージの破損 | 依存パッケージの再ビルド |
| E-AUTODEP-03 | 公開鍵不存在 | id_ed25519.pub.tomlがない | ビルド初期化の確認 |

### リトライ仕様

自動リトライなし。ELFファイル単位でスキップし、他のファイルの解析は継続。

## トランザクション仕様

該当なし（読み取り主体、キャッシュ書き込みは単一ファイル）

## パフォーマンス要件

- BTreeSetによる重複排除でO(log n)の検索
- 訪問済みセットでディレクトリ再走査を防止
- キャッシュ機能で再ビルド時の解析をスキップ

## セキュリティ考慮事項

- pkgar検証にEd25519公開鍵を使用
- ファイルシステムループ攻撃への耐性（訪問済みチェック）

## 備考

- verboseモード時は検出したDT_NEEDEDとマッチしたパッケージをログ出力
- missingライブラリもverboseモードでログ出力

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、自動依存関係のキャッシュ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | recipe.rs | `src/recipe.rs` | AutoDeps構造体（500-503行目） |

**読解のコツ**: `AutoDeps`は`packages: BTreeSet<PackageName>`を持つシンプルな構造体で、TOML形式でシリアライズ可能。

#### Step 2: エントリーポイントを理解する

自動依存関係検出のエントリーポイントを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | cook_build.rs | `src/cook/cook_build.rs` | build_auto_deps関数（574-611行目） |

**主要処理フロー**:
1. **583-588行目**: キャッシュファイルの存在確認と新しさチェック
2. **590-609行目**: キャッシュがあれば読み込み、なければ解析実行

#### Step 3: 動的リンク解析を理解する

ELFファイルからDT_NEEDEDを抽出する処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | cook_build.rs | `src/cook/cook_build.rs` | auto_deps_from_dynamic_linking関数（24-154行目） |

**主要処理フロー**:
- **30-41行目**: 検索対象ディレクトリの初期化（usr/bin, usr/lib等）
- **44-77行目**: ディレクトリの再帰走査（訪問済みチェック付き）
- **79-107行目**: ELFファイル解析とDT_NEEDED抽出
- **109-113行目**: プリインストールライブラリの除外
- **115-153行目**: pkgarからライブラリ提供元を検索

#### Step 4: 静的パッケージ依存解析を理解する

動的リンク以外の依存関係解析を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | cook_build.rs | `src/cook/cook_build.rs` | auto_deps_from_static_package_deps関数（156-168行目） |

**主要処理フロー**:
- **160-164行目**: 動的依存で検出されなかったビルド依存を抽出
- **165行目**: get_package_deps_recursiveで実行時依存を取得

### プログラム呼び出し階層図

```
cook_build::build() [cook_build.rs:170]
    │
    └─ build_auto_deps() [cook_build.rs:574]
           │
           ├─ auto_deps_from_dynamic_linking() [cook_build.rs:24]
           │      │
           │      ├─ fs::read_dir() - ディレクトリ走査
           │      │
           │      ├─ object::build::elf::Builder::read() - ELF解析
           │      │
           │      └─ pkgar::PackageFile::new() - pkgar読み取り
           │             └─ PackageSrc::read_entries() - エントリ列挙
           │
           ├─ auto_deps_from_static_package_deps() [cook_build.rs:156]
           │      │
           │      └─ CookRecipe::get_package_deps_recursive()
           │
           └─ serialize_and_write() - キャッシュ保存
```

### データフロー図

```
[入力]                    [処理]                         [出力]

stage/usr/bin/* ───────▶ ELF解析 ─────────────────────▶ DT_NEEDED一覧
stage/usr/lib/*               │                          (libfoo.so.1等)
                              │
                              ▼

                         プリインストール除外 ──────────▶ needed一覧
                         (libc, libgcc_s, libstdc++)      (絞り込み済)
                              │
                              ▼

dep_pkgars ────────────▶ pkgarエントリ検索 ────────────▶ dynamic_deps
(依存パッケージ)              │                          (パッケージ名)
                              │
                              ▼

build.dependencies ────▶ static_package_deps解析 ─────▶ static_deps
                              │                          (パッケージ名)
                              │
                              ▼

                         dynamic_deps ∪ static_deps ───▶ auto_deps.toml
                                                         BTreeSet<PackageName>
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| cook_build.rs | `src/cook/cook_build.rs` | ソース | 自動依存関係検出のメインロジック |
| recipe.rs | `src/recipe.rs` | ソース | AutoDeps構造体定義 |
| fs.rs | `src/cook/fs.rs` | ソース | ファイルシリアライズユーティリティ |
| package.rs | `src/cook/package.rs` | ソース | パッケージメタデータ処理 |
