# 機能設計書 16-sysroot構築

## 概要

本ドキュメントは、Cookbook（Redox OSパッケージビルドシステム）におけるsysroot構築機能の設計を記述する。依存パッケージをsysrootディレクトリに展開し、クロスコンパイル環境を構築する機能を提供する。

### 本機能の処理概要

sysroot構築機能は、パッケージのビルドに必要な依存ライブラリ（ヘッダファイル、ライブラリファイル等）をsysrootディレクトリに展開し、クロスコンパイラが参照できる環境を整備する機能である。

**業務上の目的・背景**：クロスコンパイルでは、ホストシステムのライブラリではなく、ターゲットシステム（Redox OS）用のライブラリを参照する必要がある。sysrootは、ターゲット用のヘッダファイル（/include）とライブラリ（/lib）を提供し、コンパイラがこれらを正しく参照できるようにする。

**機能の利用シーン**：`repo cook`コマンドでパッケージをビルドする際、ビルドスクリプト実行前に自動的に呼び出される。依存パッケージが更新されるとsysrootも再構築される。

**主要な処理内容**：
1. 依存パッケージのpkgarアーカイブを収集
2. sysroot.tmpディレクトリを作成
3. 各pkgarアーカイブを展開
4. /usr/bin, /usr/include, /usr/lib, /usr/shareへのシンボリックリンク作成
5. sysroot.tmpをsysrootにアトミックリネーム
6. タグファイルで展開済みパッケージを追跡

**関連システム・外部連携**：pkgarライブラリ（パッケージ展開）、Ed25519署名検証と連携する。

**権限による制御**：特別な権限制御はなし。ファイル書き込み権限のみ必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 4 | repo cookコマンド画面 | API連携 | 依存パッケージのsysrootへの展開 |

## 機能種別

環境構築処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| deps_dir | &PathBuf | Yes | sysrootディレクトリのパス | - |
| deps_dir_tmp | PathBuf | Yes | 一時ディレクトリのパス | - |
| dep_pkgars | &BTreeSet<(PackageName, PathBuf)> | Yes | 依存パッケージとpkgarパス | 空でも可 |
| source_modified | SystemTime | Yes | ソースの最終更新時刻 | - |
| deps_modified | SystemTime | Yes | 依存パッケージの最終更新時刻 | - |

### 入力データソース

- 依存パッケージのpkgar: 展開対象のアーカイブ
- build/id_ed25519.pub.toml: pkgar検証用公開鍵

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| sysroot | Directory | 展開されたライブラリ・ヘッダ |
| .tags | Directory | 展開済みパッケージの追跡ファイル |

### 出力先

- sysrootディレクトリ: `{recipe_dir}/target/{target}/sysroot/`
- 構造:
  ```
  sysroot/
  ├─ .tags/           (展開済みパッケージタグ)
  ├─ bin -> usr/bin
  ├─ include -> usr/include
  ├─ lib -> usr/lib
  ├─ share -> usr/share
  └─ usr/
     ├─ bin/
     ├─ include/
     ├─ lib/
     └─ share/
  ```

## 処理フロー

### 処理シーケンス

```
1. 既存sysrootの鮮度チェック
   └─ .tagsディレクトリの更新時刻とソース/依存の更新時刻を比較
2. 再構築判定
   └─ sysrootが古いか、展開済みパッケージが不足していれば再構築
3. sysroot.tmp作成
   └─ クリーンな一時ディレクトリを作成
4. ディレクトリ構造初期化
   └─ .tags, usr/{bin,include,lib,share}を作成
5. シンボリックリンク作成
   └─ /bin -> usr/bin, /lib -> usr/lib等
6. pkgar展開
   └─ 各依存パッケージを展開し、タグファイルを作成
7. アトミックリネーム
   └─ sysroot.tmp -> sysroot
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{sysroot存在?}
    B -->|No| F[sysroot.tmp作成]
    B -->|Yes| C[.tags更新時刻取得]
    C --> D{source/depsより古い?}
    D -->|No| E{未展開パッケージあり?}
    D -->|Yes| F
    E -->|No| Z[終了 - キャッシュ使用]
    E -->|Yes| F
    F --> G[ディレクトリ構造初期化]
    G --> H[シンボリックリンク作成]
    H --> I[pkgar展開ループ]
    I --> J{次のpkgarあり?}
    J -->|Yes| K[pkgar::extract実行]
    K --> L[タグファイル作成]
    L --> J
    J -->|No| M[sysroot.tmp -> sysroot]
    M --> N[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-16-01 | 鮮度チェック | ソースまたは依存が更新されるとsysrootを再構築 | ビルド時 |
| BR-16-02 | 完全性チェック | 未展開パッケージがあればsysrootを再構築 | ビルド時 |
| BR-16-03 | アトミック更新 | sysroot.tmpで構築後、アトミックにリネーム | 構築完了時 |
| BR-16-04 | タグファイル | .tags/{パッケージ名}で展開済みを追跡 | パッケージ展開後 |
| BR-16-05 | ホスト分離 | ホストパッケージはtoolchainへ、ターゲットはsysrootへ | パッケージ種別による |

### 計算ロジック

再構築判定:
```
再構築 = (sysroot_modified < source_modified)
       OR (sysroot_modified < deps_modified)
       OR (存在しないタグファイルがある)
```

## データベース操作仕様

該当なし（ファイルシステム操作のみ）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-SYSROOT-01 | 展開失敗 | pkgar展開エラー | 依存パッケージの再ビルド |
| E-SYSROOT-02 | 署名検証失敗 | 公開鍵と不一致 | 鍵ファイルの確認 |
| E-SYSROOT-03 | ディレクトリ作成失敗 | 権限エラー | ディレクトリ権限の確認 |

### リトライ仕様

自動リトライなし。エラー時はビルド全体が失敗。

## トランザクション仕様

- sysroot.tmpで構築後、renameでアトミックに切り替え
- 構築中に失敗した場合、既存のsysrootは影響を受けない

## パフォーマンス要件

- タグファイルによる差分チェックで不要な再構築を回避
- modified_dir関数で.tagsディレクトリ全体の更新時刻を効率的に取得

## セキュリティ考慮事項

- Ed25519署名によるpkgar整合性検証
- sysrootはビルド時のみ使用され、実行時には含まれない

## 備考

- verboseモード時は「using cached sysroot」等のログを出力
- ホストパッケージのビルド時はsysrootとtoolchainが同一

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

sysroot構築で使用されるパス構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | cook_build.rs | `src/cook/cook_build.rs` | build関数内のsysroot_dir定義（180行目） |

**読解のコツ**: `target_dir.join("sysroot")`でsysrootパスが決定される。target_dirはレシピディレクトリ/target/ターゲット名。

#### Step 2: エントリーポイントを理解する

sysroot構築のエントリーポイントを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | cook_build.rs | `src/cook/cook_build.rs` | build関数内のbuild_deps_dir呼び出し（279-295行目） |

**主要処理フロー**:
1. **279行目**: BuildKind::Remoteでなければsysroot構築を実行
2. **280-291行目**: build_deps_dir関数呼び出し
3. **284-288行目**: ホストパッケージかどうかで展開するpkgarsを選択

#### Step 3: sysroot構築ロジックを理解する

実際のsysroot構築処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | cook_build.rs | `src/cook/cook_build.rs` | build_deps_dir関数（511-572行目） |

**主要処理フロー**:
- **519-530行目**: 既存sysrootの鮮度チェック
- **532-538行目**: ディレクトリ構造の初期化（.tags, usr/*）
- **540-546行目**: シンボリックリンク作成（bin, include, lib, share）
- **548-563行目**: pkgar展開ループとタグファイル作成
- **566行目**: sysroot.tmp -> sysrootのアトミックリネーム

#### Step 4: ファイル操作ユーティリティを理解する

使用されるファイル操作関数を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | fs.rs | `src/cook/fs.rs` | create_dir_clean関数（32-38行目） |
| 4-2 | fs.rs | `src/cook/fs.rs` | symlink関数（103-113行目） |
| 4-3 | fs.rs | `src/cook/fs.rs` | modified_dir関数（163-172行目） |

### プログラム呼び出し階層図

```
cook_build::build() [cook_build.rs:170]
    │
    ├─ sysroot_dir = target_dir.join("sysroot")
    │
    └─ build_deps_dir() [cook_build.rs:511]
           │
           ├─ modified_dir(.tags) - 鮮度チェック
           │
           ├─ remove_all(deps_dir) - 古いsysroot削除
           │
           ├─ create_dir_clean(deps_dir_tmp) - tmp作成
           │
           ├─ create_dir(.tags, usr/*) - 構造初期化
           │
           ├─ symlink(usr/bin, bin) 等 - リンク作成
           │
           ├─ pkgar::extract() - パッケージ展開
           │      │
           │      └─ 各dep_pkgarに対して実行
           │
           ├─ fs::write(tag_file) - タグファイル作成
           │
           └─ rename(tmp, sysroot) - アトミック切替
```

### データフロー図

```
[入力]                    [処理]                         [出力]

dep_pkgars ────────────▶ 鮮度チェック ─────────────────▶ 再構築要否判定
(パッケージ名, pkgarパス)      │
                              │
source_modified ──────────────┤
deps_modified ────────────────┘
                              │
                              ▼

                         sysroot.tmp作成 ──────────────▶ ディレクトリ構造
                              │                          usr/{bin,lib,...}
                              │
                              ▼

pkgar (Ed25519署名済) ─▶ pkgar::extract ───────────────▶ 展開ファイル群
                              │                          ├─ include/
                              │                          ├─ lib/
                              │                          └─ bin/
                              │
                              ▼

                         タグファイル作成 ─────────────▶ .tags/{pkg_name}
                              │
                              ▼

                         rename(tmp, sysroot) ─────────▶ sysroot/
                                                         完成
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| cook_build.rs | `src/cook/cook_build.rs` | ソース | sysroot構築のメインロジック |
| fs.rs | `src/cook/fs.rs` | ソース | ファイル操作ユーティリティ |
| script.rs | `src/cook/script.rs` | ソース | COOKBOOK_SYSROOT環境変数の使用 |
