# 機能設計書 17-toolchain構築

## 概要

本ドキュメントは、Cookbook（Redox OSパッケージビルドシステム）におけるtoolchain構築機能の設計を記述する。ホストツールチェインパッケージをtoolchainディレクトリに展開し、クロスビルド環境を構築する機能を提供する。

### 本機能の処理概要

toolchain構築機能は、パッケージのビルドに必要なホストツール（コンパイラ、リンカ、ビルドツール等）をtoolchainディレクトリに展開し、ビルドスクリプトから参照できるようにする機能である。

**業務上の目的・背景**：Redox OS向けのクロスコンパイルでは、ホストシステム上で動作するツール（ホストツールチェイン）と、ターゲット向けのライブラリ（sysroot）の両方が必要である。ホストツールチェインには、クロスコンパイラ、pkg-config、cmake等が含まれる。本機能により、これらのツールを専用ディレクトリに展開し、PATHに追加することでビルドスクリプトから利用可能にする。

**機能の利用シーン**：`repo cook`コマンドでターゲット向けパッケージをビルドする際、ホスト依存関係（host.*パッケージ）が存在する場合に自動的に呼び出される。

**主要な処理内容**：
1. ホスト依存パッケージ（host.*）のpkgarアーカイブを収集
2. toolchain.tmpディレクトリを作成
3. 各pkgarアーカイブを展開
4. toolchain.tmpをtoolchainにアトミックリネーム
5. BUILD_PRESCRIPTでPATHにtoolchain/binを追加

**関連システム・外部連携**：pkgarライブラリ（パッケージ展開）、Ed25519署名検証と連携する。

**権限による制御**：特別な権限制御はなし。ファイル書き込み権限のみ必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 4 | repo cookコマンド画面 | API連携 | ホストツールチェインのtoolchainディレクトリ展開 |

## 機能種別

環境構築処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| deps_dir | &PathBuf | Yes | toolchainディレクトリのパス | - |
| deps_dir_tmp | PathBuf | Yes | 一時ディレクトリのパス | - |
| dep_host_pkgars | &BTreeSet<(PackageName, PathBuf)> | Yes | ホスト依存パッケージとpkgarパス | 空でも可 |
| source_modified | SystemTime | Yes | ソースの最終更新時刻 | - |
| deps_host_modified | SystemTime | Yes | ホスト依存パッケージの最終更新時刻 | - |

### 入力データソース

- ホスト依存パッケージのpkgar: 展開対象のアーカイブ
- build/id_ed25519.pub.toml: pkgar検証用公開鍵

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| toolchain | Directory | 展開されたホストツール群 |
| .tags | Directory | 展開済みパッケージの追跡ファイル |

### 出力先

- toolchainディレクトリ: `{recipe_dir}/target/{target}/toolchain/`
- 構造:
  ```
  toolchain/
  ├─ .tags/           (展開済みパッケージタグ)
  ├─ bin -> usr/bin
  ├─ include -> usr/include
  ├─ lib -> usr/lib
  ├─ share -> usr/share
  └─ usr/
     ├─ bin/         (コンパイラ、ツール等)
     ├─ include/
     ├─ lib/
     └─ share/
  ```

## 処理フロー

### 処理シーケンス

```
1. toolchain構築条件チェック
   └─ BuildKind::Remoteでない、ホストパッケージでない、ホスト依存がある場合のみ
2. 既存toolchainの鮮度チェック
   └─ sysroot構築と同様のロジック
3. toolchain.tmp作成
   └─ クリーンな一時ディレクトリを作成
4. ディレクトリ構造初期化
   └─ sysrootと同じ構造
5. pkgar展開
   └─ 各ホスト依存パッケージを展開
6. アトミックリネーム
   └─ toolchain.tmp -> toolchain
7. 環境変数設定
   └─ COOKBOOK_TOOLCHAINでビルドスクリプトに渡す
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{構築条件を満たす?}
    B -->|No| Z[終了 - toolchain不要]
    B -->|Yes| C{toolchain存在?}
    C -->|No| F[toolchain.tmp作成]
    C -->|Yes| D[鮮度チェック]
    D --> E{再構築必要?}
    E -->|No| Z2[終了 - キャッシュ使用]
    E -->|Yes| F
    F --> G[ディレクトリ構造初期化]
    G --> H[pkgar展開ループ]
    H --> I{次のpkgarあり?}
    I -->|Yes| J[pkgar::extract実行]
    J --> K[タグファイル作成]
    K --> I
    I -->|No| L[toolchain.tmp -> toolchain]
    L --> M[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-17-01 | 条件付き構築 | ターゲットパッケージでホスト依存がある場合のみ構築 | ビルド時 |
| BR-17-02 | ホストパッケージ除外 | ホストパッケージ自身のビルド時はtoolchain不要 | name.is_host()=true |
| BR-17-03 | sysroot流用 | ホストパッケージのビルドではsysrootをtoolchainとして使用 | name.is_host()=true |
| BR-17-04 | PATH追加 | toolchain/binをPATHに追加 | toolchain存在時 |
| BR-17-05 | LD_LIBRARY_PATH追加 | toolchain/libをLD_LIBRARY_PATHに追加 | toolchain存在時 |

### 計算ロジック

構築条件:
```
toolchain構築 = (BuildKind != Remote)
              AND (NOT name.is_host())
              AND (dep_host_pkgars.len() > 0)
```

## データベース操作仕様

該当なし（ファイルシステム操作のみ）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-TOOLCHAIN-01 | 展開失敗 | pkgar展開エラー | ホスト依存パッケージの再ビルド |
| E-TOOLCHAIN-02 | 署名検証失敗 | 公開鍵と不一致 | 鍵ファイルの確認 |
| E-TOOLCHAIN-03 | ディレクトリ作成失敗 | 権限エラー | ディレクトリ権限の確認 |

### リトライ仕様

自動リトライなし。エラー時はビルド全体が失敗。

## トランザクション仕様

- sysroot構築と同様、toolchain.tmpで構築後にアトミックリネーム

## パフォーマンス要件

- sysrootと同様のキャッシュ機構
- ホスト依存パッケージが少ない場合は高速に完了

## セキュリティ考慮事項

- Ed25519署名によるpkgar整合性検証
- toolchainのバイナリはビルド時にホストで実行されるため、信頼性が重要

## 備考

- COOKBOOK_TOOLCHAIN環境変数でビルドスクリプトにパスを渡す
- ホストパッケージ名は`host.パッケージ名`形式
- clean_target時はtoolchainも削除される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

toolchain構築で使用されるパス構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | cook_build.rs | `src/cook/cook_build.rs` | build関数内のtoolchain_dir定義（181行目） |

**読解のコツ**: `target_dir.join("toolchain")`でtoolchainパスが決定される。

#### Step 2: 構築条件を理解する

toolchain構築が実行される条件を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | cook_build.rs | `src/cook/cook_build.rs` | toolchain構築条件（296行目） |

**主要処理フロー**:
1. **296行目**: `!name.is_host() && dep_host_pkgars.len() > 0`が条件
2. **296-308行目**: build_deps_dir関数をtoolchain用パラメータで呼び出し

#### Step 3: 環境変数設定を理解する

toolchainがビルドスクリプトでどう使われるかを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | cook_build.rs | `src/cook/cook_build.rs` | COOKBOOK_TOOLCHAIN環境変数設定（403-407行目） |
| 3-2 | script.rs | `src/cook/script.rs` | PATH追加処理（86-90行目） |

**主要処理フロー**:
- **403-407行目**: toolchainディレクトリが存在すればCOOKBOOK_TOOLCHAINに設定
- **405-406行目**: ホストパッケージの場合はsysrootをtoolchainとして使用
- **86-90行目（script.rs）**: COOKBOOK_TOOLCHAIN設定時はPATHとLD_LIBRARY_PATHに追加

### プログラム呼び出し階層図

```
cook_build::build() [cook_build.rs:170]
    │
    ├─ toolchain_dir = target_dir.join("toolchain")
    │
    ├─ 条件チェック: !name.is_host() && dep_host_pkgars.len() > 0
    │
    └─ build_deps_dir() [cook_build.rs:511]
           │                          (toolchain_dir, toolchain.tmp, dep_host_pkgars)
           │
           └─ (sysroot構築と同じロジック)

ビルドスクリプト実行時:
    │
    ├─ command.env("COOKBOOK_TOOLCHAIN", toolchain_dir)
    │
    └─ BUILD_PRESCRIPT
           │
           └─ export PATH="${COOKBOOK_TOOLCHAIN}/bin:${PATH}"
              export LD_LIBRARY_PATH="${COOKBOOK_TOOLCHAIN}/lib:${LD_LIBRARY_PATH}"
```

### データフロー図

```
[入力]                    [処理]                         [出力]

dep_host_pkgars ───────▶ 構築条件チェック ────────────▶ 構築要否判定
(host.*パッケージ)             │
                              │
name.is_host() ───────────────┤
BuildKind ────────────────────┘
                              │
                              ▼

                         toolchain.tmp作成 ────────────▶ ディレクトリ構造
                              │
                              ▼

host pkgar ────────────▶ pkgar::extract ──────────────▶ ツールバイナリ
(Ed25519署名済)               │                          usr/bin/
                              │                          (コンパイラ等)
                              │
                              ▼

                         rename(tmp, toolchain) ───────▶ toolchain/
                              │
                              ▼

                         COOKBOOK_TOOLCHAIN ───────────▶ ビルドスクリプト
                         環境変数設定                     PATH追加
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| cook_build.rs | `src/cook/cook_build.rs` | ソース | toolchain構築のメインロジック |
| script.rs | `src/cook/script.rs` | ソース | PATH/LD_LIBRARY_PATH追加処理 |
| fs.rs | `src/cook/fs.rs` | ソース | ファイル操作ユーティリティ |
| package.rs | `src/cook/package.rs` | ソース | is_host()判定 |
