# 機能設計書 18-ステージディレクトリ管理

## 概要

本ドキュメントは、Cookbook（Redox OSパッケージビルドシステム）におけるステージディレクトリ管理機能の設計を記述する。ビルド成果物をstageディレクトリに配置し、オプショナルパッケージ毎に分離する機能を提供する。

### 本機能の処理概要

ステージディレクトリ管理機能は、ビルドスクリプトが生成したファイルをstageディレクトリに収集し、オプショナルパッケージの定義に基づいてファイルを分離する機能である。

**業務上の目的・背景**：パッケージングの準備として、ビルド成果物を一時的なステージディレクトリに収集する必要がある。また、単一のソースから複数のパッケージ（メイン+オプショナル）を生成する場合、ファイルパターンに基づいてファイルを適切に分離する必要がある。

**機能の利用シーン**：`repo cook`コマンドでパッケージをビルドした後、パッケージング前に自動的にステージディレクトリが管理される。オプショナルパッケージが定義されている場合は、ファイル分離も実行される。

**主要な処理内容**：
1. stage.tmpディレクトリの作成と初期化
2. ビルドスクリプトによるファイル配置（DESTDIR=stage.tmp）
3. オプショナルパッケージ定義に基づくファイル分離
4. stage.tmpからstageへのアトミックリネーム
5. 古いstageディレクトリの更新判定と削除

**関連システム・外部連携**：globsetクレート（パターンマッチング）と連携する。

**権限による制御**：特別な権限制御はなし。ファイル書き込み権限のみ必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 4 | repo cookコマンド画面 | API連携 | ビルド成果物のstageディレクトリ配置 |

## 機能種別

ファイル管理処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| target_dir | &Path | Yes | ターゲットディレクトリのパス | 存在するディレクトリ |
| optional_packages | &Vec<OptionalPackageRecipe> | Yes | オプショナルパッケージ定義 | - |
| COOKBOOK_STAGE | 環境変数 | Yes | ビルドスクリプトが参照するステージパス | 書き込み可能 |

### 入力データソース

- recipe.toml: optional-packagesセクション
  - name: オプショナルパッケージ名
  - files: globパターンリスト
  - dependencies: パッケージ依存関係
- ビルド成果物: ビルドスクリプトがDESTDIRに配置したファイル

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| stage | Directory | メインパッケージのステージファイル |
| stage.{name} | Directory | オプショナルパッケージのステージファイル |

### 出力先

- メインステージ: `{recipe_dir}/target/{target}/stage/`
- オプショナルステージ: `{recipe_dir}/target/{target}/stage.{name}/`
- 構造例:
  ```
  target/x86_64-unknown-redox/
  ├─ stage/                    (メインパッケージ)
  │  └─ usr/bin/main_binary
  ├─ stage.dev/                (開発用パッケージ)
  │  └─ usr/include/*.h
  └─ stage.docs/               (ドキュメントパッケージ)
     └─ usr/share/doc/*
  ```

## 処理フロー

### 処理シーケンス

```
1. ステージディレクトリ一覧取得
   └─ get_stage_dirs()でオプショナル含むすべてのステージパスを取得
2. 更新判定
   └─ ソース、依存パッケージ、レシピの更新時刻と比較
3. 古いステージ削除
   └─ 更新が必要な場合、既存のstageディレクトリを削除
4. stage.tmp作成
   └─ クリーンな一時ディレクトリを作成
5. ビルドスクリプト実行
   └─ COOKBOOK_STAGE=stage.tmpでビルド
6. オプショナルパッケージ分離
   └─ globパターンでマッチしたファイルを各stage.{name}に移動
7. アトミックリネーム
   └─ stage.tmp -> stage
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[get_stage_dirs]
    B --> C{stageより新しいソース/依存?}
    C -->|Yes| D[既存stage削除]
    C -->|No| E{キャッシュ使用可能?}
    E -->|Yes| Z[終了 - キャッシュ使用]
    E -->|No| D
    D --> F[stage.tmp作成]
    F --> G[ビルドスクリプト実行]
    G --> H{オプショナルパッケージあり?}
    H -->|Yes| I[globパターン準備]
    I --> J[ファイル分離ループ]
    J --> K[move_dir_all_fn実行]
    K --> L[stage.tmp -> stage]
    H -->|No| L
    L --> M[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-18-01 | メインパッケージ優先 | オプショナルパッケージリストの最後にメインパッケージを配置 | 常時 |
| BR-18-02 | glob先着 | ファイルは最初にマッチしたパターンのパッケージに移動 | オプショナル分離時 |
| BR-18-03 | 残余ファイル | どのパターンにもマッチしないファイルはメインパッケージに残る | オプショナル分離時 |
| BR-18-04 | アトミック更新 | stage.tmpで構築後にアトミックリネーム | 構築完了時 |
| BR-18-05 | 関連ファイル削除 | stage削除時はpkgar、toml、filesも削除 | stage更新時 |

### 計算ロジック

ステージ更新判定:
```
更新必要 = (stage_modified < source_modified)
         OR (stage_modified < deps_modified)
         OR (stage_modified < deps_host_modified)
```

## データベース操作仕様

該当なし（ファイルシステム操作のみ）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-STAGE-01 | ディレクトリ作成失敗 | 権限エラー | ディレクトリ権限の確認 |
| E-STAGE-02 | globパターンエラー | 不正なglobパターン | recipe.tomlの修正 |
| E-STAGE-03 | ファイル移動失敗 | ディスク容量不足等 | ディスク容量の確認 |

### リトライ仕様

自動リトライなし。エラー時はビルド全体が失敗。

## トランザクション仕様

- stage.tmpで構築後、renameでアトミックに切り替え
- 構築中に失敗した場合、既存のstageは影響を受けない

## パフォーマンス要件

- 更新判定でpkgarファイルの更新時刻を使用し、不要な再構築を回避
- globsetクレートによる効率的なパターンマッチング

## セキュリティ考慮事項

- ステージディレクトリは最終的にpkgarに含まれるため、意図しないファイル混入に注意
- ビルドスクリプトが任意のファイルを配置できるため、信頼性が重要

## 備考

- COOKBOOK_CROSS_TARGET環境変数でクロスターゲット用のステージパスに変更可能
- clean_target時はstageは一時的に保持され、最後に削除される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

オプショナルパッケージの定義構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | recipe.rs | `src/recipe.rs` | OptionalPackageRecipe構造体（153-159行目） |

**読解のコツ**: `files`フィールドにglobパターンのリストが格納される。これらのパターンに一致するファイルが該当のオプショナルパッケージに移動される。

#### Step 2: ステージディレクトリ取得を理解する

ステージディレクトリパスの計算ロジックを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | cook_build.rs | `src/cook/cook_build.rs` | get_stage_dirs関数（483-498行目） |

**主要処理フロー**:
- **485-490行目**: COOKBOOK_CROSS_TARGETによるパス変更対応
- **491-494行目**: オプショナルパッケージ用のstage.{name}を追加
- **495-496行目**: メインパッケージ用のstageを最後に追加

#### Step 3: ステージ更新判定を理解する

更新判定と既存ステージ削除のロジックを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | cook_build.rs | `src/cook/cook_build.rs` | stage更新判定（247-276行目） |

**主要処理フロー**:
- **248-255行目**: pkgarファイルの更新時刻でstage_modifiedを計算
- **257-260行目**: ソース、依存より古ければ削除
- **261-266行目**: 既存stageディレクトリの削除

#### Step 4: ファイル分離を理解する

オプショナルパッケージへのファイル分離ロジックを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | cook_build.rs | `src/cook/cook_build.rs` | ファイル分離処理（424-449行目） |

**主要処理フロー**:
- **425-432行目**: globパターンとターゲットディレクトリのペアを準備
- **434-445行目**: move_dir_all_fnでパターンマッチしたファイルを移動
- **448行目**: stage.tmp -> stageへのリネーム

### プログラム呼び出し階層図

```
cook_build::build() [cook_build.rs:170]
    │
    ├─ get_stage_dirs() [cook_build.rs:483]
    │      └─ Vec<PathBuf> (オプショナル + メイン)
    │
    ├─ 更新判定 [cook_build.rs:247-276]
    │      ├─ modified_all(pkgar files)
    │      └─ remove_stage_dir() (必要時)
    │
    ├─ stage.tmp作成 [cook_build.rs:316-317]
    │
    ├─ ビルドスクリプト実行 [cook_build.rs:418-422]
    │      └─ COOKBOOK_STAGE=stage.tmp
    │
    ├─ ファイル分離 [cook_build.rs:424-445]
    │      ├─ globset::Glob::new() - パターンコンパイル
    │      └─ move_dir_all_fn() - ファイル移動
    │
    └─ rename(stage.tmp, stage) [cook_build.rs:448]
```

### データフロー図

```
[入力]                    [処理]                         [出力]

recipe.toml ───────────▶ get_stage_dirs ───────────────▶ stage_dirs[]
  optional-packages            │                          - stage.dev
    - name: dev               │                          - stage.docs
    - files: ["*.h"]          │                          - stage (メイン)
                              │
                              ▼

source_modified ───────▶ 更新判定 ─────────────────────▶ 再構築要否
deps_modified                 │
                              ▼

                         stage.tmp作成 ────────────────▶ 空ディレクトリ
                              │
                              ▼

ビルドスクリプト ──────▶ DESTDIR配置 ──────────────────▶ stage.tmp/
                              │                          ├─ usr/bin/
                              │                          ├─ usr/lib/
                              │                          └─ usr/include/
                              │
                              ▼

globパターン ──────────▶ move_dir_all_fn ──────────────▶ stage.dev/
"usr/include/**"              │                          └─ usr/include/*.h
                              │
                              ▼

                         rename ───────────────────────▶ stage/
                                                         (残りのファイル)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| cook_build.rs | `src/cook/cook_build.rs` | ソース | ステージ管理のメインロジック |
| recipe.rs | `src/recipe.rs` | ソース | OptionalPackageRecipe定義 |
| fs.rs | `src/cook/fs.rs` | ソース | move_dir_all_fn, create_dir_clean等 |
